/*
 * Decompiled with CFR 0.152.
 */
package reactivefeign.client.statushandler;

import feign.Response;
import feign.codec.ErrorDecoder;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.httpclient.HttpStatus;
import reactivefeign.client.ReactiveHttpResponse;
import reactivefeign.client.statushandler.ReactiveStatusHandler;
import reactivefeign.utils.HttpUtils;
import reactor.core.publisher.Mono;

public class ReactiveStatusHandlers {
    public static ReactiveStatusHandler defaultFeignErrorDecoder() {
        return ReactiveStatusHandlers.errorDecoder(new ErrorDecoder.Default());
    }

    public static ReactiveStatusHandler errorDecoder(final ErrorDecoder errorDecoder) {
        return new ReactiveStatusHandler(){

            @Override
            public boolean shouldHandle(int status) {
                return HttpUtils.familyOf(status).isError();
            }

            @Override
            public Mono<? extends Throwable> decode(String methodTag, ReactiveHttpResponse response) {
                return response.bodyData().defaultIfEmpty(new byte[0]).map(bodyData -> errorDecoder.decode(methodTag, Response.builder().status(response.status()).reason(HttpStatus.getStatusText(response.status())).headers(response.headers().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue))).body((byte[])bodyData).build()));
            }
        };
    }

    public static ReactiveStatusHandler throwOnStatus(final Predicate<Integer> statusPredicate, final BiFunction<String, ReactiveHttpResponse, Throwable> errorFunction) {
        return new ReactiveStatusHandler(){

            @Override
            public boolean shouldHandle(int status) {
                return statusPredicate.test(status);
            }

            @Override
            public Mono<? extends Throwable> decode(String methodKey, ReactiveHttpResponse response) {
                return Mono.just((Throwable)errorFunction.apply(methodKey, response));
            }
        };
    }
}

