/*
 * Decompiled with CFR 0.152.
 */
package reactivefeign.client;

import feign.MethodMetadata;
import java.util.function.BiFunction;
import org.reactivestreams.Publisher;
import reactivefeign.client.DelegatingReactiveHttpResponse;
import reactivefeign.client.ReactiveHttpClient;
import reactivefeign.client.ReactiveHttpResponse;
import reactor.core.publisher.Mono;

public class ResponseMappers {
    public static BiFunction<MethodMetadata, ReactiveHttpResponse, ReactiveHttpResponse> ignore404() {
        return (methodMetadata, response) -> {
            if (response.status() == 404) {
                return new DelegatingReactiveHttpResponse((ReactiveHttpResponse)response){

                    @Override
                    public int status() {
                        return 200;
                    }

                    public Publisher<Object> body() {
                        return Mono.empty();
                    }
                };
            }
            return response;
        };
    }

    public static ReactiveHttpClient mapResponse(ReactiveHttpClient reactiveHttpClient, MethodMetadata methodMetadata, BiFunction<MethodMetadata, ReactiveHttpResponse, ReactiveHttpResponse> responseMapper) {
        return request -> reactiveHttpClient.executeRequest(request).map(response -> (ReactiveHttpResponse)responseMapper.apply(methodMetadata, (ReactiveHttpResponse)response));
    }
}

