/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.method.annotation;

import java.util.List;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import org.springframework.core.MethodParameter;
import org.springframework.core.ReactiveAdapter;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.core.ResolvableType;
import org.springframework.core.codec.Hints;
import org.springframework.http.MediaType;
import org.springframework.http.codec.HttpMessageWriter;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.web.reactive.accept.RequestedContentTypeResolver;
import org.springframework.web.reactive.result.HandlerResultHandlerSupport;
import org.springframework.web.server.NotAcceptableStatusException;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public abstract class AbstractMessageWriterResultHandler
extends HandlerResultHandlerSupport {
    private final List<HttpMessageWriter<?>> messageWriters;

    protected AbstractMessageWriterResultHandler(List<HttpMessageWriter<?>> messageWriters, RequestedContentTypeResolver contentTypeResolver) {
        this(messageWriters, contentTypeResolver, ReactiveAdapterRegistry.getSharedInstance());
    }

    protected AbstractMessageWriterResultHandler(List<HttpMessageWriter<?>> messageWriters, RequestedContentTypeResolver contentTypeResolver, ReactiveAdapterRegistry adapterRegistry) {
        super(contentTypeResolver, adapterRegistry);
        Assert.notEmpty(messageWriters, "At least one message writer is required");
        this.messageWriters = messageWriters;
    }

    public List<HttpMessageWriter<?>> getMessageWriters() {
        return this.messageWriters;
    }

    protected Mono<Void> writeBody(@Nullable Object body2, MethodParameter bodyParameter, ServerWebExchange exchange2) {
        return this.writeBody(body2, bodyParameter, null, exchange2);
    }

    protected Mono<Void> writeBody(@Nullable Object body2, MethodParameter bodyParameter, @Nullable MethodParameter actualParam, ServerWebExchange exchange2) {
        ResolvableType elementType;
        Publisher<Object> publisher;
        ResolvableType bodyType = ResolvableType.forMethodParameter(bodyParameter);
        ResolvableType actualType = actualParam != null ? ResolvableType.forMethodParameter(actualParam) : bodyType;
        ReactiveAdapter adapter = this.getAdapterRegistry().getAdapter(bodyType.resolve(), body2);
        if (adapter != null) {
            publisher = adapter.toPublisher(body2);
            ResolvableType genericType = bodyType.getGeneric(new int[0]);
            elementType = this.getElementType(adapter, genericType);
        } else {
            publisher = Mono.justOrEmpty(body2);
            ResolvableType resolvableType = elementType = bodyType.toClass() == Object.class && body2 != null ? ResolvableType.forInstance(body2) : bodyType;
        }
        if (elementType.resolve() == Void.TYPE || elementType.resolve() == Void.class) {
            return Mono.from(publisher);
        }
        ServerHttpRequest request = exchange2.getRequest();
        ServerHttpResponse response = exchange2.getResponse();
        MediaType bestMediaType = this.selectMediaType(exchange2, () -> this.getMediaTypesFor(elementType));
        if (bestMediaType != null) {
            String logPrefix = exchange2.getLogPrefix();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(logPrefix + (publisher instanceof Mono ? "0..1" : "0..N") + " [" + elementType + "]");
            }
            for (HttpMessageWriter<?> writer : this.getMessageWriters()) {
                if (!writer.canWrite(elementType, bestMediaType)) continue;
                return writer.write(publisher, actualType, elementType, bestMediaType, request, response, Hints.from(Hints.LOG_PREFIX_HINT, logPrefix));
            }
        } else if (this.getMediaTypesFor(elementType).isEmpty()) {
            return Mono.error(new IllegalStateException("No writer for : " + elementType));
        }
        return Mono.error(new NotAcceptableStatusException(this.getMediaTypesFor(elementType)));
    }

    private ResolvableType getElementType(ReactiveAdapter adapter, ResolvableType genericType) {
        if (adapter.isNoValue()) {
            return ResolvableType.forClass(Void.class);
        }
        if (genericType != ResolvableType.NONE) {
            return genericType;
        }
        return ResolvableType.forClass(Object.class);
    }

    private List<MediaType> getMediaTypesFor(ResolvableType elementType) {
        return this.getMessageWriters().stream().filter(converter -> converter.canWrite(elementType, null)).flatMap(converter -> converter.getWritableMediaTypes().stream()).collect(Collectors.toList());
    }
}

