/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.httpclient.Header;

public class HeaderGroup {
    private List headers = new ArrayList();

    public void clear() {
        this.headers.clear();
    }

    public void addHeader(Header header) {
        this.headers.add(header);
    }

    public void removeHeader(Header header) {
        this.headers.remove(header);
    }

    public void setHeaders(Header[] headers2) {
        this.clear();
        for (int i = 0; i < headers2.length; ++i) {
            this.addHeader(headers2[i]);
        }
    }

    public Header getCondensedHeader(String name) {
        Header[] headers2 = this.getHeaders(name);
        if (headers2.length == 0) {
            return null;
        }
        if (headers2.length == 1) {
            return new Header(headers2[0].getName(), headers2[0].getValue());
        }
        StringBuffer valueBuffer = new StringBuffer(headers2[0].getValue());
        for (int i = 1; i < headers2.length; ++i) {
            valueBuffer.append(", ");
            valueBuffer.append(headers2[i].getValue());
        }
        return new Header(name.toLowerCase(), valueBuffer.toString());
    }

    public Header[] getHeaders(String name) {
        ArrayList<Header> headersFound = new ArrayList<Header>();
        Iterator headerIter = this.headers.iterator();
        while (headerIter.hasNext()) {
            Header header = (Header)headerIter.next();
            if (!header.getName().equalsIgnoreCase(name)) continue;
            headersFound.add(header);
        }
        return headersFound.toArray(new Header[headersFound.size()]);
    }

    public Header getFirstHeader(String name) {
        Iterator headerIter = this.headers.iterator();
        while (headerIter.hasNext()) {
            Header header = (Header)headerIter.next();
            if (!header.getName().equalsIgnoreCase(name)) continue;
            return header;
        }
        return null;
    }

    public Header getLastHeader(String name) {
        for (int i = this.headers.size() - 1; i >= 0; --i) {
            Header header = (Header)this.headers.get(i);
            if (!header.getName().equalsIgnoreCase(name)) continue;
            return header;
        }
        return null;
    }

    public Header[] getAllHeaders() {
        return this.headers.toArray(new Header[this.headers.size()]);
    }

    public boolean containsHeader(String name) {
        Iterator headerIter = this.headers.iterator();
        while (headerIter.hasNext()) {
            Header header = (Header)headerIter.next();
            if (!header.getName().equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public Iterator getIterator() {
        return this.headers.iterator();
    }
}

