/*
 * Decompiled with CFR 0.152.
 */
package com.pixima.libmvgoogleplay;

import android.app.Activity;
import android.net.Uri;
import android.webkit.JavascriptInterface;
import androidx.annotation.NonNull;
import com.google.android.gms.games.AnnotatedData;
import com.google.android.gms.games.EventsClient;
import com.google.android.gms.games.event.Event;
import com.google.android.gms.games.event.EventBuffer;
import com.pixima.libmvgoogleplay.AbstractHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

class EventsHandler
extends AbstractHandler<EventsClient> {
    static final String INTERFACE_NAME = "__google_play_events";
    private Map<String, EventShell> mEventsCache = new HashMap<String, EventShell>();
    private Map<String, Long> mOfflineEventCache = new HashMap<String, Long>();

    EventsHandler(Activity activity) {
        super(activity);
    }

    @JavascriptInterface
    public void incrementEvent(@NonNull String eventId, @NonNull Long stepAmount) {
        if (this.mClient != null) {
            ((EventsClient)this.mClient).increment(eventId, stepAmount.intValue());
        }
        if (!this.mEventsCache.isEmpty()) {
            EventShell shell = this.mEventsCache.get(eventId);
            if (shell == null) {
                return;
            }
            shell.val += stepAmount.longValue();
            this.mEventsCache.put(eventId, shell);
            Long offlineStep = this.mOfflineEventCache.get(eventId);
            if (offlineStep != null) {
                this.mOfflineEventCache.put(eventId, offlineStep + stepAmount);
            } else {
                this.mOfflineEventCache.put(eventId, stepAmount);
            }
        }
    }

    @JavascriptInterface
    public String getAllEventDataAsJson() {
        return !this.mEventsCache.isEmpty() ? gson.toJson((Object)this.mEventsCache.values().toArray()) : null;
    }

    @JavascriptInterface
    public String getEventDataAsJson(String eventId) {
        return !this.mEventsCache.isEmpty() ? gson.toJson((Object)this.mEventsCache.get(eventId)) : null;
    }

    void cacheEvents(boolean forceReload) {
        ((EventsClient)this.mClient).load(forceReload).addOnCompleteListener(task -> {
            if (!task.isSuccessful()) {
                return;
            }
            try {
                EventBuffer eventBuffer = (EventBuffer)((AnnotatedData)Objects.requireNonNull(task.getResult())).get();
                int buffSize = eventBuffer != null ? eventBuffer.getCount() : 0;
                for (int i = 0; i < buffSize; ++i) {
                    Event event = (Event)eventBuffer.get(i).freeze();
                    EventShell shell = new EventShell(event);
                    this.mEventsCache.put(shell.id, shell);
                }
                if (eventBuffer != null) {
                    eventBuffer.release();
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        });
    }

    void incrementCachedEvents() {
        if (this.mOfflineEventCache.isEmpty()) {
            return;
        }
        for (Map.Entry<String, Long> entry : this.mOfflineEventCache.entrySet()) {
            this.incrementEvent(entry.getKey(), entry.getValue());
        }
        this.mOfflineEventCache.clear();
    }

    private static class EventShell {
        String id;
        String name;
        String desc;
        String formattedVal;
        Uri imageUri;
        long val;

        EventShell(@NonNull Event event) {
            this.id = event.getEventId();
            this.name = event.getName();
            this.desc = event.getDescription();
            this.formattedVal = event.getFormattedValue();
            this.imageUri = event.getIconImageUri();
            this.val = event.getValue();
        }
    }
}

