/*
 * Decompiled with CFR 0.152.
 */
package com.pixima.libmvgoogleplay;

import android.app.Activity;
import android.net.Uri;
import android.webkit.JavascriptInterface;
import androidx.annotation.NonNull;
import com.google.android.gms.games.AchievementsClient;
import com.google.android.gms.games.AnnotatedData;
import com.google.android.gms.games.achievement.Achievement;
import com.google.android.gms.games.achievement.AchievementBuffer;
import com.pixima.libmvgoogleplay.AbstractHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

class AchievementsHandler
extends AbstractHandler<AchievementsClient> {
    static final String INTERFACE_NAME = "__google_play_achievements";
    private static final int RC_ACHIEVEMENT_UI = 9003;
    private Map<String, AchievementShell> mAchievementCache = new HashMap<String, AchievementShell>();
    private List<String> mUnlockQueue = new ArrayList<String>();

    AchievementsHandler(Activity activity) {
        super(activity);
    }

    @JavascriptInterface
    public void showAchievementView() {
        if (this.mClient != null) {
            ((AchievementsClient)this.mClient).getAchievementsIntent().addOnSuccessListener(intent -> this.mParentActivity.startActivityForResult(intent, 9003));
        }
    }

    @JavascriptInterface
    public void unlockAchievement(@NonNull String achievementId) {
        if (this.mClient != null) {
            ((AchievementsClient)this.mClient).unlock(achievementId);
        }
        if (!this.mAchievementCache.isEmpty()) {
            AchievementShell shell = this.mAchievementCache.get(achievementId);
            if (shell == null) {
                return;
            }
            if (shell.state == 0) {
                return;
            }
            shell.state = 0;
            this.mUnlockQueue.add(shell.id);
            this.mAchievementCache.put(achievementId, shell);
        }
    }

    @JavascriptInterface
    public void incrementAchievementStep(String achievementId, int stepAmount) {
        if (this.mClient != null) {
            ((AchievementsClient)this.mClient).increment(achievementId, stepAmount);
        }
        if (!this.mAchievementCache.isEmpty()) {
            AchievementShell shell = this.mAchievementCache.get(achievementId);
            if (shell == null) {
                return;
            }
            if (shell.type != 1 && shell.state == 0) {
                return;
            }
            shell.currentSteps += stepAmount;
            this.mAchievementCache.put(achievementId, shell);
            if (shell.currentSteps >= shell.stepsToUnlock) {
                this.unlockAchievement(achievementId);
            }
        }
    }

    @JavascriptInterface
    public String getAllAchievementDataAsJson() {
        return !this.mAchievementCache.isEmpty() ? gson.toJson((Object)this.mAchievementCache.values().toArray()) : null;
    }

    @JavascriptInterface
    public String getAchievementDataAsJson(String achievementId) {
        return !this.mAchievementCache.isEmpty() ? gson.toJson((Object)this.mAchievementCache.get(achievementId)) : null;
    }

    void cacheAchievements(boolean forceReload) {
        ((AchievementsClient)this.mClient).load(forceReload).addOnCompleteListener(task -> {
            if (!task.isSuccessful()) {
                return;
            }
            try {
                AchievementBuffer achievementBuffer = (AchievementBuffer)((AnnotatedData)Objects.requireNonNull(task.getResult())).get();
                int buffSize = achievementBuffer != null ? achievementBuffer.getCount() : 0;
                for (int i = 0; i < buffSize; ++i) {
                    Achievement achievement = (Achievement)achievementBuffer.get(i).freeze();
                    AchievementShell achievementShell = new AchievementShell(achievement);
                    this.mAchievementCache.put(achievementShell.id, achievementShell);
                }
                if (achievementBuffer != null) {
                    achievementBuffer.release();
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        });
    }

    void unlockCachedAchievements() {
        if (this.mUnlockQueue.isEmpty()) {
            return;
        }
        for (String achievementId : this.mUnlockQueue) {
            this.unlockAchievement(achievementId);
        }
        this.mUnlockQueue.clear();
    }

    private static class AchievementShell {
        String id;
        String name;
        String desc;
        Uri revealedImageUri;
        Uri unlockedImageUri;
        int state;
        int type;
        int currentSteps = 0;
        int stepsToUnlock = 0;

        AchievementShell(@NonNull Achievement achievement) {
            this.id = achievement.getAchievementId();
            this.name = achievement.getName();
            this.desc = achievement.getDescription();
            this.revealedImageUri = achievement.getRevealedImageUri();
            this.unlockedImageUri = achievement.getUnlockedImageUri();
            this.state = achievement.getState();
            this.type = achievement.getType();
            if (this.type == 1) {
                this.currentSteps = achievement.getCurrentSteps();
                this.stepsToUnlock = achievement.getTotalSteps();
            }
        }
    }
}

