/*
 * Decompiled with CFR 0.152.
 */
package com.pixima.libmvgoogleplay;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.support.annotation.NonNull;
import android.util.Log;
import android.webkit.JavascriptInterface;
import android.webkit.WebView;
import com.google.android.gms.auth.api.Auth;
import com.google.android.gms.auth.api.signin.GoogleSignIn;
import com.google.android.gms.auth.api.signin.GoogleSignInAccount;
import com.google.android.gms.auth.api.signin.GoogleSignInClient;
import com.google.android.gms.auth.api.signin.GoogleSignInOptions;
import com.google.android.gms.auth.api.signin.GoogleSignInResult;
import com.google.android.gms.common.api.ApiException;
import com.google.android.gms.games.Games;
import com.pixima.libmvgoogleplay.AchievementsHandler;
import com.pixima.libmvgoogleplay.EventsHandler;
import com.pixima.libmvgoogleplay.LeaderboardsHandler;
import com.pixima.libmvgoogleplay.R;

public class GPlayMain {
    private static final String INTERFACE_NAME = "__google_play_main";
    private static final int RC_SIGN_IN = 9001;
    private Activity mParentActivity;
    private GoogleSignInClient mGoogleSignInClient;
    private AchievementsHandler mAchievementsHandler;
    private EventsHandler mEventsHandler;
    private LeaderboardsHandler mLeaderboardsHandler;
    private boolean enable_achievements;
    private boolean enable_events;
    private boolean enable_leaderboards;
    private boolean enable_auto_signin;
    private boolean manualSignOut = false;
    private boolean isFirstStart = true;

    public GPlayMain(@NonNull Context context, @NonNull WebView webView) {
        this.mParentActivity = (Activity)context;
        Resources res = this.mParentActivity.getResources();
        this.enable_achievements = res.getBoolean(R.bool.gplay_enable_achievements);
        this.enable_events = res.getBoolean(R.bool.gplay_enable_events);
        this.enable_leaderboards = res.getBoolean(R.bool.gplay_enable_leaderboards);
        this.enable_auto_signin = res.getBoolean(R.bool.gplay_enable_auto_signin);
        String val = this.mParentActivity.getString(R.string.app_id);
        if (val.contains("YOUR_") || val.isEmpty()) {
            Log.d((String)INTERFACE_NAME, (String)"The APP_ID in ids.xml for this app has not been set, Google Play Services will not be initialized");
        }
        GoogleSignInOptions googleSignInOptions = new GoogleSignInOptions.Builder(GoogleSignInOptions.DEFAULT_GAMES_SIGN_IN).build();
        this.mGoogleSignInClient = GoogleSignIn.getClient((Activity)this.mParentActivity, (GoogleSignInOptions)googleSignInOptions);
        webView.addJavascriptInterface((Object)this, INTERFACE_NAME);
        if (this.enable_achievements) {
            this.mAchievementsHandler = new AchievementsHandler(this.mParentActivity);
            webView.addJavascriptInterface((Object)this.mAchievementsHandler, "__google_play_achievements");
        }
        if (this.enable_events) {
            this.mEventsHandler = new EventsHandler(this.mParentActivity);
            webView.addJavascriptInterface((Object)this.mEventsHandler, "__google_play_events");
        }
        if (this.enable_leaderboards) {
            this.mLeaderboardsHandler = new LeaderboardsHandler(this.mParentActivity);
            webView.addJavascriptInterface((Object)this.mLeaderboardsHandler, "__google_play_leaderboards");
        }
    }

    public void OnActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == 9001) {
            GoogleSignInResult result = Auth.GoogleSignInApi.getSignInResultFromIntent(data);
            if (result.isSuccess()) {
                GoogleSignInAccount signInAccount = result.getSignInAccount();
                this.onConnected(signInAccount);
                this.manualSignOut = false;
            } else {
                int statusCode = result.getStatus().getStatusCode();
                this.onDisconnected();
                this.handleErrorStatusCodes(statusCode);
            }
        }
    }

    public void onResume() {
        if (!this.manualSignOut && this.enable_auto_signin) {
            this.startSilentSignIn();
        }
    }

    public void onStart() {
        if (!this.manualSignOut && this.enable_auto_signin) {
            this.startInteractiveSignIn();
        }
    }

    @JavascriptInterface
    public void startInteractiveSignIn() {
        this.mParentActivity.startActivityForResult(this.mGoogleSignInClient.getSignInIntent(), 9001);
    }

    @JavascriptInterface
    public void signOut() {
        if (!this.isSignedIn()) {
            return;
        }
        this.mGoogleSignInClient.signOut().addOnCompleteListener(this.mParentActivity, task -> this.onDisconnected());
        this.manualSignOut = true;
    }

    @JavascriptInterface
    public boolean isSignedIn() {
        return GoogleSignIn.getLastSignedInAccount((Context)this.mParentActivity) != null;
    }

    private void startSilentSignIn() {
        this.mGoogleSignInClient.silentSignIn().addOnCompleteListener(this.mParentActivity, task -> {
            if (task.isSuccessful()) {
                GoogleSignInAccount signInAccount = (GoogleSignInAccount)task.getResult();
                this.onConnected(signInAccount);
            } else {
                ApiException exception = (ApiException)task.getException();
                if (exception != null) {
                    if (exception.getStatusCode() == 4) {
                        this.startSilentSignIn();
                    } else {
                        this.handleErrorStatusCodes(exception.getStatusCode());
                    }
                } else {
                    Log.e((String)INTERFACE_NAME, (String)"Sign-in is really broken.");
                }
            }
        });
    }

    private void onConnected(GoogleSignInAccount googleSignInAccount) {
        if (this.enable_achievements) {
            this.mAchievementsHandler.setClient(Games.getAchievementsClient((Activity)this.mParentActivity, (GoogleSignInAccount)googleSignInAccount));
            this.mAchievementsHandler.unlockCachedAchievements();
            this.mAchievementsHandler.cacheAchievements(this.isFirstStart);
        }
        if (this.enable_events) {
            this.mEventsHandler.setClient(Games.getEventsClient((Activity)this.mParentActivity, (GoogleSignInAccount)googleSignInAccount));
            this.mEventsHandler.incrementCachedEvents();
            this.mEventsHandler.cacheEvents(this.isFirstStart);
        }
        if (this.enable_leaderboards) {
            this.mLeaderboardsHandler.setClient(Games.getLeaderboardsClient((Activity)this.mParentActivity, (GoogleSignInAccount)googleSignInAccount));
        }
        if (this.isFirstStart) {
            this.isFirstStart = false;
        }
    }

    private void onDisconnected() {
        if (this.enable_achievements) {
            this.mAchievementsHandler.setClient(null);
        }
        if (this.enable_events) {
            this.mEventsHandler.setClient(null);
        }
        if (this.enable_leaderboards) {
            this.mLeaderboardsHandler.setClient(null);
        }
    }

    private void handleErrorStatusCodes(int statusCode) {
        String message;
        switch (statusCode) {
            case 17: {
                message = this.mParentActivity.getString(R.string.gplay_api_not_connected);
                break;
            }
            case 16: {
                message = this.mParentActivity.getString(R.string.gplay_api_cancelled);
                break;
            }
            case 10: {
                message = this.mParentActivity.getString(R.string.gplay_api_misconfigured);
                break;
            }
            case 13: {
                message = this.mParentActivity.getString(R.string.gplay_api_error);
                break;
            }
            case 7: 
            case 8: {
                message = this.mParentActivity.getString(R.string.gplay_api_internal_network_error);
                break;
            }
            case 5: {
                message = this.mParentActivity.getString(R.string.gplay_api_invalid_account);
                break;
            }
            case 15: {
                message = this.mParentActivity.getString(R.string.gplay_api_timeout);
                break;
            }
            case 12502: {
                return;
            }
            default: {
                message = this.mParentActivity.getString(R.string.gplay_api_unspecified) + statusCode;
            }
        }
        new AlertDialog.Builder((Context)this.mParentActivity).setMessage((CharSequence)message).setNeutralButton(17039370, null).show();
    }
}

