/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.ktlint.cli.internal;

import com.github.ajalt.clikt.core.BaseCliktCommand;
import com.github.ajalt.clikt.core.CliktCommand;
import com.github.ajalt.clikt.core.Context;
import com.pinterest.ktlint.cli.internal.KtlintCommandLineKt;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.util.Arrays;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b \u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001c\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00032\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010J\b\u0010\u0012\u001a\u00020\u0013H\u0002J\b\u0010\u0014\u001a\u00020\u0013H\u0002J\b\u0010\u0015\u001a\u00020\u0003H\u0002J(\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u0003H\u0002J\u0014\u0010\u001a\u001a\n \u001b*\u0004\u0018\u00010\u00030\u0003*\u00020\u0011H\u0002R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001c"}, d2={"Lcom/pinterest/ktlint/cli/internal/GitHookCliktCommand;", "Lcom/github/ajalt/clikt/core/CliktCommand;", "name", "", "helpText", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getHelpText", "()Ljava/lang/String;", "help", "context", "Lcom/github/ajalt/clikt/core/Context;", "installGitHook", "", "gitHookName", "hookContentProvider", "Lkotlin/Function0;", "", "resolveGitHooksDir", "Ljava/io/File;", "getGitDir", "getHooksDirName", "backupExistingHook", "hooksDir", "hookFile", "expectedHookContent", "toUniqueId", "kotlin.jvm.PlatformType", "ktlint-cli"})
@SourceDebugExtension(value={"SMAP\nGitHookCliktCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitHookCliktCommand.kt\ncom/pinterest/ktlint/cli/internal/GitHookCliktCommand\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,123:1\n1#2:124\n*E\n"})
public abstract class GitHookCliktCommand
extends CliktCommand {
    @NotNull
    private final String helpText;

    public GitHookCliktCommand(@NotNull String name, @NotNull String helpText) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)helpText, (String)"helpText");
        super(name);
        this.helpText = helpText;
    }

    @NotNull
    public final String getHelpText() {
        return this.helpText;
    }

    @NotNull
    public String help(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this.helpText;
    }

    public final void installGitHook(@NotNull String gitHookName, @NotNull Function0<byte[]> hookContentProvider) {
        File file;
        Intrinsics.checkNotNullParameter((Object)gitHookName, (String)"gitHookName");
        Intrinsics.checkNotNullParameter(hookContentProvider, (String)"hookContentProvider");
        try {
            file = this.resolveGitHooksDir();
        }
        catch (IOException e) {
            BaseCliktCommand.echo$default((BaseCliktCommand)((BaseCliktCommand)this), (Object)e.getMessage(), (boolean)false, (boolean)true, (int)2, null);
            KtlintCommandLineKt.exitKtLintProcess(1);
            throw new KotlinNothingValueException();
        }
        File gitHooksDir = file;
        File gitHookFile = FilesKt.resolve((File)gitHooksDir, (String)gitHookName);
        byte[] hookContent = (byte[])hookContentProvider.invoke();
        if (gitHookFile.exists()) {
            this.backupExistingHook(gitHooksDir, gitHookFile, hookContent, gitHookName);
        }
        FilesKt.writeBytes((File)gitHookFile, (byte[])hookContent);
        gitHookFile.setExecutable(true);
        BaseCliktCommand.echo$default((BaseCliktCommand)((BaseCliktCommand)this), (Object)(gitHookFile.getPath() + " is installed. Be aware that this hook assumes to find ktlint on the PATH. Either ensure that ktlint is actually added to the path or expand the ktlint command in the hook with the path."), (boolean)false, (boolean)false, (int)6, null);
    }

    private final File resolveGitHooksDir() throws IOException {
        String gitHooksDirName;
        File gitDir = this.getGitDir();
        File hooksDir = FilesKt.resolve((File)gitDir, (String)(gitHooksDirName = this.getHooksDirName()));
        if (!hooksDir.exists() && !hooksDir.mkdir()) {
            throw new IOException("Failed to create " + hooksDir.getPath() + " folder");
        }
        return hooksDir;
    }

    private final File getGitDir() {
        Object object;
        try {
            object = new String[]{"git", "rev-parse", "--show-toplevel"};
            Process $this$getGitDir_u24lambda_u240 = new ProcessBuilder((String[])object).start();
            boolean bl = false;
            InputStream inputStream = $this$getGitDir_u24lambda_u240.getInputStream();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
            InputStream inputStream2 = inputStream;
            Charset charset = Charsets.UTF_8;
            Reader reader = new InputStreamReader(inputStream2, charset);
            int n = 8192;
            String rootDir = (reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n)).readLine();
            $this$getGitDir_u24lambda_u240.waitFor();
            String string = rootDir;
            if (string == null) {
                string = ".git";
            }
            object = FilesKt.resolve((File)new File(string), (String)".git");
        }
        catch (IOException iOException) {
            object = new File(".git");
        }
        Object gitDir = object;
        if (!((File)gitDir).isDirectory()) {
            throw new IOException(".git directory not found. Are you sure you are inside project directory?");
        }
        return gitDir;
    }

    private final String getHooksDirName() {
        Object object;
        try {
            Object object2;
            String string;
            object = new String[]{"git", "config", "--get", "core.hooksPath"};
            Process $this$getHooksDirName_u24lambda_u240 = new ProcessBuilder((String)object).start();
            boolean bl = false;
            InputStream inputStream = $this$getHooksDirName_u24lambda_u240.getInputStream();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
            Object object3 = inputStream;
            Charset charset = Charsets.UTF_8;
            Reader reader = new InputStreamReader((InputStream)object3, charset);
            int n = 8192;
            String hooksDir = (reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n)).readLine();
            $this$getHooksDirName_u24lambda_u240.waitFor();
            if ((hooksDir != null ? ((Object)StringsKt.trim((CharSequence)hooksDir)).toString() : (string = null)) == null) {
                string = "";
            }
            if ((object3 = (CharSequence)string).length() == 0) {
                boolean bl2 = false;
                object2 = "hooks";
            } else {
                object2 = object3;
            }
            object = (String)object2;
        }
        catch (IOException iOException) {
            object = "hooks";
        }
        return object;
    }

    private final void backupExistingHook(File hooksDir, File hookFile, byte[] expectedHookContent, String gitHookName) {
        byte[] actualHookContent = FilesKt.readBytes((File)hookFile);
        if (!(actualHookContent.length == 0) && !Arrays.equals(actualHookContent, expectedHookContent)) {
            File backupFile = FilesKt.resolve((File)hooksDir, (String)(gitHookName + ".ktlint-backup." + this.toUniqueId(actualHookContent)));
            BaseCliktCommand.echo$default((BaseCliktCommand)((BaseCliktCommand)this), (Object)("Existing git hook " + hookFile.getPath() + " is copied to " + backupFile.getPath()), (boolean)false, (boolean)false, (int)6, null);
            FilesKt.copyTo$default((File)hookFile, (File)backupFile, (boolean)true, (int)0, (int)4, null);
        }
    }

    private final String toUniqueId(byte[] $this$toUniqueId) {
        byte[] it = MessageDigest.getInstance("SHA-256").digest($this$toUniqueId);
        boolean bl = false;
        return new BigInteger(it).toString(16);
    }
}

