/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.ktlint.cli.internal;

import com.pinterest.ktlint.cli.internal.CustomJarProviderCheck;
import com.pinterest.ktlint.cli.internal.KtlintCommandLineKt;
import com.pinterest.ktlint.logger.api.KtLintKLoggerInitializerKt;
import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KotlinLogging;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.Set;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0003\u001aH\u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0005\"\u0004\b\u0000\u0010\u0006*\b\u0012\u0004\u0012\u0002H\u00060\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u0002H\u0006\u0012\u0004\u0012\u00020\u00030\f2\u0006\u0010\r\u001a\u00020\u000eH\u0000\u001a(\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0005\"\u0004\b\u0000\u0010\u0006*\b\u0012\u0004\u0012\u0002H\u00060\u00072\b\u0010\u0010\u001a\u0004\u0018\u00010\nH\u0002\u001a\u001b\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\u0012*\u0004\u0018\u00010\nH\u0002\u00a2\u0006\u0002\u0010\u0013\u001a\u000e\u0010\u0014\u001a\u00020\u0003*\u0004\u0018\u00010\nH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"LOGGER", "Lio/github/oshai/kotlinlogging/KLogger;", "KTLINT_JAR", "", "loadFromJarFiles", "", "T", "Ljava/lang/Class;", "urls", "", "Ljava/net/URL;", "providerId", "Lkotlin/Function1;", "customJarProviderCheck", "Lcom/pinterest/ktlint/cli/internal/CustomJarProviderCheck;", "loadProvidersFromJars", "url", "toArray", "", "(Ljava/net/URL;)[Ljava/net/URL;", "jarFilePath", "ktlint-cli"})
@SourceDebugExtension(value={"SMAP\nKtlintServiceLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KtlintServiceLoader.kt\ncom/pinterest/ktlint/cli/internal/KtlintServiceLoaderKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,148:1\n1617#2,9:149\n1869#2:158\n1870#2:160\n1626#2:161\n1869#2,2:162\n1563#2:164\n1634#2,3:165\n1563#2:168\n1634#2,2:169\n827#2:171\n855#2,2:172\n1617#2,9:174\n1869#2:183\n1870#2:185\n1626#2:186\n1636#2:187\n1617#2,9:188\n1869#2:197\n1870#2:199\n1626#2:200\n1#3:159\n1#3:184\n1#3:198\n1#3:201\n18#4:202\n*S KotlinDebug\n*F\n+ 1 KtlintServiceLoader.kt\ncom/pinterest/ktlint/cli/internal/KtlintServiceLoaderKt\n*L\n26#1:149,9\n26#1:158\n26#1:160\n26#1:161\n27#1:162,2\n33#1:164\n33#1:165,3\n38#1:168\n38#1:169,2\n42#1:171\n42#1:172,2\n71#1:174,9\n71#1:183\n71#1:185\n71#1:186\n38#1:187\n111#1:188,9\n111#1:197\n111#1:199\n111#1:200\n26#1:159\n71#1:184\n111#1:198\n130#1:202\n*E\n"})
public final class KtlintServiceLoaderKt {
    @NotNull
    private static final KLogger LOGGER = KtLintKLoggerInitializerKt.initKtLintKLogger((KLogger)KotlinLogging.INSTANCE.logger(KtlintServiceLoaderKt::LOGGER$lambda$0));
    @NotNull
    private static final String KTLINT_JAR = "ktlint";

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <T> Set<T> loadFromJarFiles(@NotNull Class<T> $this$loadFromJarFiles, @NotNull List<URL> urls, @NotNull Function1<? super T, String> providerId, @NotNull CustomJarProviderCheck customJarProviderCheck) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        void $this$map$iv2;
        Object element$iv2;
        void $this$forEach$iv;
        Iterator it$iv$iv;
        Object element$iv$iv$iv;
        Iterator $this$mapNotNullTo$iv$iv2;
        Iterable $this$mapNotNull$iv2;
        Set<T> set;
        Intrinsics.checkNotNullParameter($this$loadFromJarFiles, (String)"<this>");
        Intrinsics.checkNotNullParameter(urls, (String)"urls");
        Intrinsics.checkNotNullParameter(providerId, (String)"providerId");
        Intrinsics.checkNotNullParameter((Object)((Object)customJarProviderCheck), (String)"customJarProviderCheck");
        Iterable<Object> providers = set = KtlintServiceLoaderKt.loadProvidersFromJars($this$loadFromJarFiles, null);
        boolean bl = false;
        Iterable iterable = providers;
        boolean $i$f$mapNotNull = false;
        void var10_12 = $this$mapNotNull$iv2;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl2 = false;
            Object it = element$iv$iv;
            boolean bl3 = false;
            if (it == null) continue;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv2 = (List)destination$iv$iv;
        boolean $i$f$forEach2 = false;
        for (Object element$iv2 : $this$forEach$iv) {
            Object it = element$iv2;
            boolean bl5 = false;
            LOGGER.debug(() -> KtlintServiceLoaderKt.loadFromJarFiles$lambda$4$lambda$3$lambda$2($this$loadFromJarFiles, providerId, it));
        }
        Set<T> providersFromKtlintJars = set;
        providers = providersFromKtlintJars;
        boolean $i$f$map22 = false;
        $this$forEach$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        element$iv2 = $this$mapTo$iv$iv2.iterator();
        while (element$iv2.hasNext()) {
            void it;
            Object item$iv$iv;
            Object bl5 = item$iv$iv = element$iv2.next();
            collection = destination$iv$iv2;
            boolean bl6 = false;
            collection.add((String)providerId.invoke((Object)it));
        }
        List providerIdsFromKtlintJars = (List)destination$iv$iv2;
        Iterable $i$f$map22 = CollectionsKt.distinct((Iterable)urls);
        boolean $i$f$map = false;
        destination$iv$iv2 = $this$map$iv;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            List list;
            void $this$filterNotTo$iv$iv;
            Iterable $this$filterNot$iv;
            void url;
            URL bl6 = (URL)item$iv$iv;
            collection = destination$iv$iv3;
            boolean bl7 = false;
            element$iv$iv$iv = KtlintServiceLoaderKt.loadProvidersFromJars($this$loadFromJarFiles, (URL)url);
            boolean $i$f$filterNot = false;
            void bl2 = $this$filterNot$iv;
            Collection destination$iv$iv4 = new ArrayList();
            boolean $i$f$filterNotTo = false;
            it$iv$iv = $this$filterNotTo$iv$iv.iterator();
            while (it$iv$iv.hasNext()) {
                Object element$iv$iv;
                Object it = element$iv$iv = it$iv$iv.next();
                boolean bl8 = false;
                if (providerIdsFromKtlintJars.contains(providerId.invoke(it))) continue;
                destination$iv$iv4.add(element$iv$iv);
            }
            List providers2 = (List)destination$iv$iv4;
            if (providers2.isEmpty()) {
                if (customJarProviderCheck == CustomJarProviderCheck.ERROR_WHEN_REQUIRED_PROVIDER_IS_MISSING) {
                    if (KLogger.DefaultImpls.isDebugEnabled$default((KLogger)LOGGER, null, (int)1, null)) {
                        LOGGER.error(() -> KtlintServiceLoaderKt.loadFromJarFiles$lambda$13$lambda$7((URL)url, $this$loadFromJarFiles));
                    } else {
                        LOGGER.error(() -> KtlintServiceLoaderKt.loadFromJarFiles$lambda$13$lambda$8((URL)url, $this$loadFromJarFiles));
                    }
                    KtlintCommandLineKt.exitKtLintProcess(1);
                    throw new KotlinNothingValueException();
                }
                list = providers2;
            } else {
                void $this$mapNotNullTo$iv$iv3;
                void $this$mapNotNull$iv3;
                $this$filterNot$iv = providers2;
                boolean $i$f$mapNotNull2 = false;
                $this$filterNotTo$iv$iv = $this$mapNotNull$iv3;
                destination$iv$iv4 = new ArrayList();
                boolean $i$f$mapNotNullTo2 = false;
                void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv3;
                boolean $i$f$forEach3 = false;
                Iterator iterator2 = $this$forEach$iv$iv$iv2.iterator();
                while (iterator2.hasNext()) {
                    Object it$iv$iv2;
                    Object element$iv$iv$iv2;
                    Object element$iv$iv = element$iv$iv$iv2 = iterator2.next();
                    boolean bl9 = false;
                    Object it = element$iv$iv;
                    boolean bl10 = false;
                    if (customJarProviderCheck == CustomJarProviderCheck.ERROR_WHEN_DEPRECATED_PROVIDER_IS_FOUND) {
                        if (KLogger.DefaultImpls.isDebugEnabled$default((KLogger)LOGGER, null, (int)1, null)) {
                            LOGGER.error(() -> KtlintServiceLoaderKt.loadFromJarFiles$lambda$13$lambda$12$lambda$9((URL)url, $this$loadFromJarFiles));
                        } else {
                            LOGGER.error(() -> KtlintServiceLoaderKt.loadFromJarFiles$lambda$13$lambda$12$lambda$10((URL)url, $this$loadFromJarFiles));
                        }
                        KtlintCommandLineKt.exitKtLintProcess(1);
                        throw new KotlinNothingValueException();
                    }
                    LOGGER.debug(() -> KtlintServiceLoaderKt.loadFromJarFiles$lambda$13$lambda$12$lambda$11($this$loadFromJarFiles, providerId, it, (URL)url));
                    if (it == null) continue;
                    boolean bl11 = false;
                    destination$iv$iv4.add(it$iv$iv2);
                }
                list = (List)destination$iv$iv4;
            }
            collection.add(list);
        }
        Set providersFromCustomJars = CollectionsKt.toSet((Iterable)CollectionsKt.flatten((Iterable)((List)destination$iv$iv3)));
        $this$map$iv = SetsKt.plus(providersFromKtlintJars, (Iterable)providersFromCustomJars);
        boolean $i$f$mapNotNull3 = false;
        $this$mapTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv3 = new ArrayList();
        boolean $i$f$mapNotNullTo3 = false;
        void $this$forEach$iv$iv$iv3 = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach4 = false;
        Iterator iterator3 = $this$forEach$iv$iv$iv3.iterator();
        while (iterator3.hasNext()) {
            Object it$iv$iv3;
            Object element$iv$iv$iv3;
            Object element$iv$iv = element$iv$iv$iv3 = iterator3.next();
            boolean bl12 = false;
            Object it = element$iv$iv;
            boolean bl13 = false;
            if (it == null) continue;
            boolean bl14 = false;
            destination$iv$iv3.add(it$iv$iv3);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv3));
    }

    private static final <T> Set<T> loadProvidersFromJars(Class<T> $this$loadProvidersFromJars, URL url) {
        Set set;
        try {
            ServiceLoader<T> serviceLoader = ServiceLoader.load($this$loadProvidersFromJars, new URLClassLoader(KtlintServiceLoaderKt.toArray(url)));
            Intrinsics.checkNotNullExpressionValue(serviceLoader, (String)"load(...)");
            set = CollectionsKt.toSet((Iterable)serviceLoader);
        }
        catch (ServiceConfigurationError e) {
            LOGGER.warn(() -> KtlintServiceLoaderKt.loadProvidersFromJars$lambda$15(url, e));
            set = SetsKt.emptySet();
        }
        return set;
    }

    private static final URL[] toArray(URL $this$toArray) {
        URL[] uRLArray;
        if ($this$toArray != null) {
            URL it = $this$toArray;
            boolean bl = false;
            URL[] uRLArray2 = new URL[]{$this$toArray};
            uRLArray = uRLArray2;
        } else {
            uRLArray = null;
        }
        URL[] $this$orEmpty$iv = uRLArray;
        boolean $i$f$orEmpty = false;
        URL[] uRLArray3 = $this$orEmpty$iv;
        if ($this$orEmpty$iv == null) {
            uRLArray3 = new URL[]{};
        }
        return uRLArray3;
    }

    private static final String jarFilePath(URL $this$jarFilePath) {
        String string;
        return $this$jarFilePath != null && (string = $this$jarFilePath.getPath()) != null ? string : KTLINT_JAR;
    }

    private static final Unit LOGGER$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Object loadFromJarFiles$lambda$4$lambda$3$lambda$2(Class $this_loadFromJarFiles, Function1 $providerId, Object $it) {
        return "Discovered " + $this_loadFromJarFiles.getSimpleName() + " with id '" + (String)$providerId.invoke($it) + "' in ktlint JAR";
    }

    private static final Object loadFromJarFiles$lambda$13$lambda$7(URL $url, Class $this_loadFromJarFiles) {
        return StringsKt.trimIndent((String)("\n                                JAR file '" + $url.getPath() + "' is missing a class implementing interface '" + $this_loadFromJarFiles.getCanonicalName() + "'\n                                    KtLint uses a ServiceLoader to dynamically load classes from JAR files specified at the command line of KtLint.\n                                    The JAR file below does not contain an implementation of the interface.\n                                        Interface: " + $this_loadFromJarFiles.getCanonicalName() + "\n                                        JAR file : " + $url.getPath() + "\n                                    Check following:\n                                      - Does the jar contain an implementation of the interface above?\n                                      - Does the jar contain a resource file with name '" + $this_loadFromJarFiles.getCanonicalName() + "'?\n                                      - Is the resource file located in directory \"src/main/resources/META-INF/services\"?\n                                      - Does the resource file contain the fully qualified class name of the class implementing the interface above?\n                                "));
    }

    private static final Object loadFromJarFiles$lambda$13$lambda$8(URL $url, Class $this_loadFromJarFiles) {
        return "JAR file '" + $url.getPath() + "' is missing a class implementing interface '" + $this_loadFromJarFiles.getCanonicalName() + "' (run in debug mode for more information)";
    }

    private static final Object loadFromJarFiles$lambda$13$lambda$12$lambda$9(URL $url, Class $this_loadFromJarFiles) {
        return StringsKt.trimIndent((String)("\n                                        JAR file '" + $url.getPath() + "' contains a class implementing an unsupported interface '" + $this_loadFromJarFiles.getCanonicalName() + "'\n                                            KtLint uses a ServiceLoader to dynamically load classes from JAR files specified at the command line of KtLint.\n                                            The JAR file below contains an implementation of an interface which is no longer supported by this version of\n                                            KtLint. Please contact the maintainer of this JAR file (not maintained by KtLint) to upgrade the JAR file so\n                                            that you can use it again.\n                                                Interface: " + $this_loadFromJarFiles.getCanonicalName() + "\n                                                JAR file : " + $url.getPath() + "\n                                        "));
    }

    private static final Object loadFromJarFiles$lambda$13$lambda$12$lambda$10(URL $url, Class $this_loadFromJarFiles) {
        return "JAR file '" + $url.getPath() + "' contains a class implementing an unsupported interface '" + $this_loadFromJarFiles.getCanonicalName() + "' (run in debug mode for more information)";
    }

    private static final Object loadFromJarFiles$lambda$13$lambda$12$lambda$11(Class $this_loadFromJarFiles, Function1 $providerId, Object $it, URL $url) {
        return StringsKt.trimIndent((String)("\n                                    Discovered " + $this_loadFromJarFiles.getSimpleName() + " with id '" + (String)$providerId.invoke($it) + "' in JAR file '" + $url.getPath() + "'\n                                        KtLint uses a ServiceLoader to dynamically load classes from JAR files specified at the command line of KtLint.\n                                        The JAR file below contains an implementation of an interface which is supported by this version of ktlint:\n                                            Interface: " + $this_loadFromJarFiles.getCanonicalName() + "\n                                            Id       : " + (String)$providerId.invoke($it) + "\n                                            JAR file : " + $url.getPath() + "\n                                    "));
    }

    private static final Object loadProvidersFromJars$lambda$15(URL $url, ServiceConfigurationError $e) {
        StringBuilder stringBuilder = new StringBuilder().append("Error while loading JAR file '").append(KtlintServiceLoaderKt.jarFilePath($url)).append("':\n");
        $e.printStackTrace();
        return stringBuilder.append(Unit.INSTANCE).toString();
    }
}

