/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.platform;

import com.pi4j.common.Descriptor;
import com.pi4j.context.Context;
import com.pi4j.extension.Extension;
import com.pi4j.internal.IOCreator;
import com.pi4j.internal.ProviderProvider;
import com.pi4j.io.IO;
import com.pi4j.io.IOConfig;
import com.pi4j.io.IOType;
import com.pi4j.provider.Provider;
import com.pi4j.provider.exception.ProviderInterfaceException;
import com.pi4j.provider.exception.ProviderNotFoundException;
import java.util.Map;

public interface Platform
extends IOCreator,
ProviderProvider,
Extension<Platform> {
    public int priority();

    public boolean enabled(Context var1);

    public Map<IOType, Provider> providers();

    @Override
    default public <T extends Provider> T provider(Class<T> providerClass) throws ProviderNotFoundException, ProviderInterfaceException {
        for (Provider p : this.providers().values()) {
            if (!providerClass.isAssignableFrom(p.getClass())) continue;
            return (T)p;
        }
        if (providerClass.isInterface()) {
            throw new ProviderNotFoundException(providerClass);
        }
        throw new ProviderInterfaceException(providerClass);
    }

    @Override
    default public <T extends Provider> T provider(IOType ioType) throws ProviderNotFoundException {
        if (this.providers().containsKey((Object)ioType)) {
            return (T)this.providers().get((Object)ioType);
        }
        throw new ProviderNotFoundException(ioType);
    }

    @Override
    default public <T extends Provider> T provider(String providerId, Class<T> providerClass) throws ProviderNotFoundException {
        for (Provider provider : this.providers().values()) {
            if (!provider.id().equalsIgnoreCase(providerId) || !providerClass.isInstance(provider)) continue;
            return (T)provider;
        }
        throw new ProviderNotFoundException(providerId, providerClass);
    }

    @Override
    default public <T extends Provider> T provider(String providerId) throws ProviderNotFoundException {
        if (this.providers().containsKey(providerId)) {
            return (T)this.providers().get(providerId);
        }
        try {
            Class<?> providerClass = Class.forName(providerId);
            if (providerClass != null && Provider.class.isAssignableFrom(providerClass)) {
                for (Provider provider : this.providers().values()) {
                    if (!providerClass.isInstance(provider)) continue;
                    return (T)provider;
                }
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        throw new ProviderNotFoundException(providerId);
    }

    @Override
    default public boolean hasProvider(String providerId) {
        if (this.providers().containsKey(providerId)) {
            return true;
        }
        try {
            Class<?> providerClass = Class.forName(providerId);
            if (providerClass != null && Provider.class.isAssignableFrom(providerClass)) {
                for (Provider provider : this.providers().values()) {
                    if (!providerClass.isInstance(provider)) continue;
                    return true;
                }
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return false;
    }

    @Override
    default public <T extends Provider> boolean hasProvider(Class<T> providerClass) {
        try {
            return this.provider(providerClass) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    default public <T extends Provider> boolean hasProvider(IOType ioType) {
        try {
            return this.provider(ioType) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public <I extends IO> I create(IOConfig var1, IOType var2);

    public <T extends IO> T create(String var1);

    public <T extends IO> T create(String var1, IOType var2);

    @Override
    default public Descriptor describe() {
        return Descriptor.create().id(this.id()).name(this.name()).category("PLATFORM").description(this.description()).type(this.getClass());
    }
}

