/*
 * Decompiled with CFR 0.152.
 */
package com.pholser.junit.quickcheck.guava.generator;

import com.google.common.base.Optional;
import com.pholser.junit.quickcheck.generator.ComponentizedGenerator;
import com.pholser.junit.quickcheck.generator.GenerationStatus;
import com.pholser.junit.quickcheck.generator.Generator;
import com.pholser.junit.quickcheck.random.SourceOfRandomness;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class OptionalGenerator
extends ComponentizedGenerator<Optional> {
    public OptionalGenerator() {
        super(Optional.class);
    }

    public Optional<?> generate(SourceOfRandomness random, GenerationStatus status) {
        double trial = random.nextDouble();
        return trial < 0.25 ? Optional.absent() : Optional.fromNullable((Object)((Generator)this.componentGenerators().get(0)).generate(random, status));
    }

    public List<Optional> doShrink(SourceOfRandomness random, Optional larger) {
        if (!larger.isPresent()) {
            return new ArrayList<Optional>();
        }
        ArrayList<Optional> shrinks = new ArrayList<Optional>();
        shrinks.add(Optional.absent());
        shrinks.addAll(((Generator)this.componentGenerators().get(0)).shrink(random, larger.get()).stream().map(Optional::fromNullable).collect(Collectors.toList()));
        return shrinks;
    }

    public int numberOfNeededComponents() {
        return 1;
    }
}

