/*
 * Decompiled with CFR 0.152.
 */
package com.pholser.junit.quickcheck.generator.java.util;

import com.pholser.junit.quickcheck.generator.GenerationStatus;
import com.pholser.junit.quickcheck.generator.Generator;
import com.pholser.junit.quickcheck.generator.InRange;
import com.pholser.junit.quickcheck.generator.java.lang.LongGenerator;
import com.pholser.junit.quickcheck.random.SourceOfRandomness;
import java.util.ArrayList;
import java.util.List;
import java.util.OptionalLong;
import java.util.stream.Collectors;

public class OptionalLongGenerator
extends Generator<OptionalLong> {
    private final LongGenerator longGenerator = new LongGenerator();

    public OptionalLongGenerator() {
        super(OptionalLong.class);
    }

    public void configure(InRange range) {
        this.longGenerator.configure(range);
    }

    public OptionalLong generate(SourceOfRandomness random, GenerationStatus status) {
        double trial = random.nextDouble();
        return trial < 0.25 ? OptionalLong.empty() : OptionalLong.of(this.longGenerator.generate(random, status));
    }

    public List<OptionalLong> doShrink(SourceOfRandomness random, OptionalLong larger) {
        if (!larger.isPresent()) {
            return new ArrayList<OptionalLong>();
        }
        ArrayList<OptionalLong> shrinks = new ArrayList<OptionalLong>();
        shrinks.add(OptionalLong.empty());
        shrinks.addAll(this.longGenerator.shrink(random, larger.getAsLong()).stream().map(OptionalLong::of).collect(Collectors.toList()));
        return shrinks;
    }
}

