/*
 * Decompiled with CFR 0.152.
 */
package com.pholser.junit.quickcheck.generator.java.lang.strings;

import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CodePoints {
    private static final Map<Charset, CodePoints> ENCODABLES = new HashMap<Charset, CodePoints>();
    private final List<CodePointRange> ranges = new ArrayList<CodePointRange>();

    CodePoints() {
    }

    public int at(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("illegal negative index: " + index);
        }
        int min = 0;
        int max = this.ranges.size() - 1;
        while (min <= max) {
            int midpoint = min + (max - min) / 2;
            CodePointRange current = this.ranges.get(midpoint);
            if (index >= current.previousCount && index < current.previousCount + current.size()) {
                return current.low + index - current.previousCount;
            }
            if (index < current.previousCount) {
                max = midpoint - 1;
                continue;
            }
            min = midpoint + 1;
        }
        throw new IndexOutOfBoundsException(String.valueOf(index));
    }

    public int size() {
        if (this.ranges.isEmpty()) {
            return 0;
        }
        CodePointRange last = this.ranges.get(this.ranges.size() - 1);
        return last.previousCount + last.size();
    }

    public boolean contains(int codePoint) {
        return this.ranges.stream().anyMatch(r -> r.contains(codePoint));
    }

    public static CodePoints forCharset(Charset c) {
        if (ENCODABLES.containsKey(c)) {
            return ENCODABLES.get(c);
        }
        CodePoints points = CodePoints.load(c);
        ENCODABLES.put(c, points);
        return points;
    }

    private static CodePoints load(Charset c) {
        if (!c.canEncode()) {
            throw new IllegalArgumentException("Charset " + c.name() + " does not support encoding");
        }
        return CodePoints.encodableCodePoints(c.newEncoder());
    }

    void add(CodePointRange range) {
        this.ranges.add(range);
    }

    private static CodePoints encodableCodePoints(CharsetEncoder encoder) {
        int current;
        CodePoints points = new CodePoints();
        int start = 0;
        boolean inRange = false;
        int previousCount = 0;
        int[] buffer = new int[1];
        for (current = 0; current <= 0x10FFFF; ++current) {
            encoder.reset();
            buffer[0] = current;
            String s = new String(buffer, 0, 1);
            if (encoder.canEncode(s)) {
                if (inRange) continue;
                inRange = true;
                start = current;
                continue;
            }
            if (!inRange) continue;
            inRange = false;
            CodePointRange range = new CodePointRange(start, current - 1, previousCount);
            points.add(range);
            previousCount += range.size();
        }
        if (inRange) {
            points.add(new CodePointRange(start, current - 1, previousCount));
        }
        return points;
    }

    static class CodePointRange {
        final int low;
        final int high;
        final int previousCount;

        CodePointRange(int low, int high, int previousCount) {
            if (low > high) {
                throw new IllegalArgumentException(String.format("%d > %d", low, high));
            }
            this.low = low;
            this.high = high;
            this.previousCount = previousCount;
        }

        boolean contains(int codePoint) {
            return codePoint >= this.low && codePoint <= this.high;
        }

        int size() {
            return this.high - this.low + 1;
        }
    }
}

