/*
 * Decompiled with CFR 0.152.
 */
package com.pholser.junit.quickcheck.runner;

import com.pholser.junit.quickcheck.internal.generator.PropertyParameterGenerationContext;
import com.pholser.junit.quickcheck.runner.PropertyFalsified;
import com.pholser.junit.quickcheck.runner.PropertyVerifier;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.TestClass;

final class ShrinkNode {
    private final FrameworkMethod method;
    private final TestClass testClass;
    private final List<PropertyParameterGenerationContext> params;
    private final Object[] args;
    private final long[] seeds;
    private final int argIndex;
    private final int depth;
    private AssertionError failure;

    private ShrinkNode(FrameworkMethod method, TestClass testClass, List<PropertyParameterGenerationContext> params, Object[] args, long[] seeds, int argIndex, int depth, AssertionError failure) {
        this.method = method;
        this.testClass = testClass;
        this.params = params;
        this.args = args;
        this.seeds = seeds;
        this.argIndex = argIndex;
        this.depth = depth;
        this.failure = failure;
    }

    Object[] getArgs() {
        return this.args;
    }

    static ShrinkNode root(FrameworkMethod method, TestClass testClass, List<PropertyParameterGenerationContext> params, Object[] args, long[] seeds, AssertionError failure) {
        return new ShrinkNode(method, testClass, params, args, seeds, 0, 0, failure);
    }

    List<ShrinkNode> shrinks() {
        if (this.argIndex >= this.args.length) {
            return Collections.emptyList();
        }
        PropertyParameterGenerationContext param = this.params.get(this.argIndex);
        return param.shrink(this.args[this.argIndex]).stream().map(this::shrinkNodeFor).collect(Collectors.toList());
    }

    boolean verifyProperty() throws Throwable {
        boolean[] result = new boolean[1];
        this.property(result).verify();
        return result[0];
    }

    ShrinkNode advanceToNextArg() {
        return new ShrinkNode(this.method, this.testClass, this.params, this.args, this.seeds, this.argIndex + 1, this.depth, this.failure);
    }

    AssertionError fail(AssertionError originalFailure, Object[] originalArgs) {
        return originalFailure == this.failure ? PropertyFalsified.counterexampleFound(this.method.getName(), this.args, this.seeds, this.failure) : PropertyFalsified.smallerCounterexampleFound(this.method.getName(), originalArgs, this.args, this.seeds, this.failure, originalFailure);
    }

    boolean mightBePast(ShrinkNode other) {
        return this.argIndex >= other.argIndex && this.depth >= other.depth;
    }

    boolean deeperThan(int max) {
        return this.depth > max;
    }

    private PropertyVerifier property(boolean[] result) throws InitializationError {
        return new PropertyVerifier(this.testClass, this.method, this.args, this.seeds, s -> {
            result[0] = true;
        }, v -> {
            result[0] = true;
        }, (e, repeatTestOption) -> {
            this.failure = e;
            result[0] = false;
        });
    }

    private ShrinkNode shrinkNodeFor(Object shrunk) {
        Object[] shrunkArgs = new Object[this.args.length];
        System.arraycopy(this.args, 0, shrunkArgs, 0, this.args.length);
        shrunkArgs[this.argIndex] = shrunk;
        return new ShrinkNode(this.method, this.testClass, this.params, shrunkArgs, this.seeds, this.argIndex, this.depth + 1, this.failure);
    }
}

