/*
 * Decompiled with CFR 0.152.
 */
package com.pholser.junit.quickcheck.internal.generator;

import com.pholser.junit.quickcheck.generator.GenerationStatus;
import com.pholser.junit.quickcheck.generator.Generator;
import com.pholser.junit.quickcheck.generator.Generators;
import com.pholser.junit.quickcheck.generator.Size;
import com.pholser.junit.quickcheck.internal.Lists;
import com.pholser.junit.quickcheck.internal.Ranges;
import com.pholser.junit.quickcheck.internal.Reflection;
import com.pholser.junit.quickcheck.internal.Sequences;
import com.pholser.junit.quickcheck.random.SourceOfRandomness;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class ArrayGenerator
extends Generator<Object> {
    private final Class<?> componentType;
    private final Generator<?> component;
    private Size lengthRange;

    public ArrayGenerator(Class<?> componentType, Generator<?> component) {
        super(Object.class);
        this.componentType = componentType;
        this.component = component;
    }

    public void configure(Size size) {
        this.lengthRange = size;
        Ranges.checkRange(Ranges.Type.INTEGRAL, size.min(), size.max());
    }

    @Override
    public Object generate(SourceOfRandomness random, GenerationStatus status) {
        int length = this.length(random, status);
        Object array = Array.newInstance(this.componentType, length);
        for (int i = 0; i < length; ++i) {
            Array.set(array, i, this.component.generate(random, status));
        }
        return array;
    }

    @Override
    public boolean canShrink(Object larger) {
        return larger.getClass().getComponentType() == this.componentType;
    }

    @Override
    public List<Object> doShrink(SourceOfRandomness random, Object larger) {
        int length = Array.getLength(larger);
        ArrayList<Object> asList = new ArrayList<Object>();
        for (int i = 0; i < length; ++i) {
            asList.add(Array.get(larger, i));
        }
        ArrayList<Object> shrinks = new ArrayList<Object>();
        shrinks.addAll(this.removals(asList));
        List oneItemShrinks = Lists.shrinksOfOneItem(random, asList, this.component);
        shrinks.addAll(oneItemShrinks.stream().map(this::convert).filter(this::inLengthRange).collect(Collectors.toList()));
        return shrinks;
    }

    @Override
    public void provide(Generators provided) {
        super.provide(provided);
        this.component.provide(provided);
    }

    @Override
    public void configure(AnnotatedType annotatedType) {
        super.configure(annotatedType);
        List<AnnotatedType> annotated = Reflection.annotatedComponentTypes(annotatedType);
        if (!annotated.isEmpty()) {
            this.component.configure(annotated.get(0));
        }
    }

    private int length(SourceOfRandomness random, GenerationStatus status) {
        return this.lengthRange != null ? random.nextInt(this.lengthRange.min(), this.lengthRange.max()) : status.size();
    }

    private boolean inLengthRange(Object items) {
        int length = Array.getLength(items);
        return this.lengthRange == null || length >= this.lengthRange.min() && length <= this.lengthRange.max();
    }

    private List<Object> removals(List<?> items) {
        return StreamSupport.stream(Sequences.halving(items.size()).spliterator(), false).map((? super T i) -> Lists.removeFrom(items, i)).flatMap(Collection::stream).map(this::convert).filter(this::inLengthRange).collect(Collectors.toList());
    }

    private Object convert(List<?> items) {
        Object array = Array.newInstance(this.componentType, items.size());
        for (int i = 0; i < items.size(); ++i) {
            Array.set(array, i, items.get(i));
        }
        return array;
    }
}

