/*
 * Decompiled with CFR 0.152.
 */
package com.pholser.junit.quickcheck.internal;

import com.pholser.junit.quickcheck.random.SourceOfRandomness;
import java.math.BigInteger;

public final class Ranges {
    private Ranges() {
        throw new UnsupportedOperationException();
    }

    public static <T extends Comparable<? super T>> int checkRange(Type type, T min, T max) {
        int comparison = min.compareTo(max);
        if (comparison > 0) {
            throw new IllegalArgumentException(String.format("bad range, %" + type.pattern + " > %" + type.pattern, min, max));
        }
        return comparison;
    }

    public static BigInteger choose(SourceOfRandomness random, BigInteger min, BigInteger max) {
        BigInteger generated;
        BigInteger range = max.subtract(min).add(BigInteger.ONE);
        while ((generated = random.nextBigInteger(range.bitLength())).compareTo(range) >= 0) {
        }
        return generated.add(min);
    }

    public static long choose(SourceOfRandomness random, long min, long max) {
        boolean noOverflowIssues;
        Ranges.checkRange(Type.INTEGRAL, min, max);
        boolean bl = noOverflowIssues = max < 0x4000000000000000L && min > -4611686018427387904L;
        if (noOverflowIssues) {
            long generated;
            long range = max - min + 1L;
            long mask = Ranges.findNextPowerOfTwoLong(range) - 1L;
            while ((generated = Math.abs(random.nextLong()) & mask) >= range) {
            }
            return generated + min;
        }
        return Ranges.choose(random, BigInteger.valueOf(min), BigInteger.valueOf(max)).longValue();
    }

    static long findNextPowerOfTwoLong(long positiveLong) {
        return Ranges.isPowerOfTwoLong(positiveLong) ? positiveLong : 1L << 64 - Long.numberOfLeadingZeros(positiveLong);
    }

    private static boolean isPowerOfTwoLong(long positiveLong) {
        return (positiveLong & positiveLong - 1L) == 0L;
    }

    public static enum Type {
        CHARACTER("c"),
        INTEGRAL("d"),
        FLOAT("f"),
        STRING("s");

        private final String pattern;

        private Type(String pattern) {
            this.pattern = pattern;
        }
    }
}

