/*
 * Decompiled with CFR 0.152.
 */
package com.readystatesoftware.chuck.internal.ui;

import android.content.Context;
import android.database.Cursor;
import android.support.v4.content.ContextCompat;
import android.support.v4.widget.CursorAdapter;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import com.readystatesoftware.chuck.R;
import com.readystatesoftware.chuck.internal.data.HttpTransaction;
import com.readystatesoftware.chuck.internal.data.LocalCupboard;
import com.readystatesoftware.chuck.internal.ui.TransactionListFragment;

class TransactionAdapter
extends RecyclerView.Adapter<ViewHolder> {
    private final Context context;
    private final TransactionListFragment.OnListFragmentInteractionListener listener;
    private final CursorAdapter cursorAdapter;
    private final int colorDefault;
    private final int colorRequested;
    private final int colorError;
    private final int color500;
    private final int color400;
    private final int color300;

    TransactionAdapter(Context context, TransactionListFragment.OnListFragmentInteractionListener listener) {
        this.listener = listener;
        this.context = context;
        this.colorDefault = ContextCompat.getColor((Context)context, (int)R.color.chuck_status_default);
        this.colorRequested = ContextCompat.getColor((Context)context, (int)R.color.chuck_status_requested);
        this.colorError = ContextCompat.getColor((Context)context, (int)R.color.chuck_status_error);
        this.color500 = ContextCompat.getColor((Context)context, (int)R.color.chuck_status_500);
        this.color400 = ContextCompat.getColor((Context)context, (int)R.color.chuck_status_400);
        this.color300 = ContextCompat.getColor((Context)context, (int)R.color.chuck_status_300);
        this.cursorAdapter = new CursorAdapter(this.context, null, 2){

            public View newView(Context context, Cursor cursor, ViewGroup parent) {
                View itemView = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.chuck_list_item_transaction, parent, false);
                ViewHolder holder = new ViewHolder(itemView);
                itemView.setTag((Object)holder);
                return itemView;
            }

            public void bindView(View view, Context context, Cursor cursor) {
                HttpTransaction transaction = (HttpTransaction)LocalCupboard.getInstance().withCursor(cursor).get(HttpTransaction.class);
                final ViewHolder holder = (ViewHolder)((Object)view.getTag());
                holder.path.setText((CharSequence)(transaction.getMethod() + " " + transaction.getPath()));
                holder.host.setText((CharSequence)transaction.getHost());
                holder.start.setText((CharSequence)transaction.getRequestStartTimeString());
                holder.ssl.setVisibility(transaction.isSsl() ? 0 : 8);
                if (transaction.getStatus() == HttpTransaction.Status.Complete) {
                    holder.code.setText((CharSequence)String.valueOf(transaction.getResponseCode()));
                    holder.duration.setText((CharSequence)transaction.getDurationString());
                    holder.size.setText((CharSequence)transaction.getTotalSizeString());
                } else {
                    holder.code.setText(null);
                    holder.duration.setText(null);
                    holder.size.setText(null);
                }
                if (transaction.getStatus() == HttpTransaction.Status.Failed) {
                    holder.code.setText((CharSequence)"!!!");
                }
                this.showMalformedJsonIfNeeded(holder, transaction);
                this.setStatusColor(holder, transaction);
                holder.transaction = transaction;
                holder.view.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        if (null != TransactionAdapter.this.listener) {
                            TransactionAdapter.this.listener.onListFragmentInteraction(holder.transaction);
                        }
                    }
                });
            }

            private void showMalformedJsonIfNeeded(ViewHolder holder, HttpTransaction transaction) {
                Integer malformedJson = transaction.getMalformedJson();
                holder.malformedJson.setVisibility(malformedJson != null && malformedJson == 1 ? 0 : 8);
            }

            private void setStatusColor(ViewHolder holder, HttpTransaction transaction) {
                int color2 = transaction.getStatus() == HttpTransaction.Status.Failed ? TransactionAdapter.this.colorError : (transaction.getStatus() == HttpTransaction.Status.Requested ? TransactionAdapter.this.colorRequested : (transaction.getResponseCode() >= 500 ? TransactionAdapter.this.color500 : (transaction.getResponseCode() >= 400 ? TransactionAdapter.this.color400 : (transaction.getResponseCode() >= 300 ? TransactionAdapter.this.color300 : TransactionAdapter.this.colorDefault))));
                holder.code.setTextColor(color2);
                holder.path.setTextColor(color2);
            }
        };
    }

    public int getItemCount() {
        return this.cursorAdapter.getCount();
    }

    public void onBindViewHolder(ViewHolder holder, int position) {
        this.cursorAdapter.getCursor().moveToPosition(position);
        this.cursorAdapter.bindView(holder.itemView, this.context, this.cursorAdapter.getCursor());
    }

    public ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View v = this.cursorAdapter.newView(this.context, this.cursorAdapter.getCursor(), parent);
        return new ViewHolder(v);
    }

    void swapCursor(Cursor newCursor) {
        this.cursorAdapter.swapCursor(newCursor);
        this.notifyDataSetChanged();
    }

    class ViewHolder
    extends RecyclerView.ViewHolder {
        public final View view;
        public final TextView code;
        public final TextView path;
        public final TextView host;
        public final TextView start;
        public final TextView duration;
        public final TextView size;
        public final ImageView ssl;
        public final ImageView malformedJson;
        HttpTransaction transaction;

        ViewHolder(View view) {
            super(view);
            this.view = view;
            this.code = (TextView)view.findViewById(R.id.code);
            this.path = (TextView)view.findViewById(R.id.path);
            this.host = (TextView)view.findViewById(R.id.host);
            this.start = (TextView)view.findViewById(R.id.start);
            this.duration = (TextView)view.findViewById(R.id.duration);
            this.size = (TextView)view.findViewById(R.id.size);
            this.ssl = (ImageView)view.findViewById(R.id.ssl);
            this.malformedJson = (ImageView)view.findViewById(R.id.malformedJson);
        }
    }
}

