/*
 * Decompiled with CFR 0.152.
 */
package com.readystatesoftware.chuck;

import android.content.ContentValues;
import android.content.Context;
import android.net.Uri;
import android.util.Log;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.readystatesoftware.chuck.R;
import com.readystatesoftware.chuck.internal.data.ChuckContentProvider;
import com.readystatesoftware.chuck.internal.data.HttpTransaction;
import com.readystatesoftware.chuck.internal.data.LocalCupboard;
import com.readystatesoftware.chuck.internal.support.JsonConvertor;
import com.readystatesoftware.chuck.internal.support.NotificationHelper;
import com.readystatesoftware.chuck.internal.support.RetentionManager;
import java.io.EOFException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.internal.http.HttpHeaders;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.GzipSource;
import okio.Okio;
import okio.Source;

public final class ChuckInterceptor
implements Interceptor {
    private static final String LOG_TAG = "ChuckInterceptor";
    private static final Period DEFAULT_RETENTION = Period.ONE_WEEK;
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private final Context context;
    private final NotificationHelper notificationHelper;
    private RetentionManager retentionManager;
    private boolean showNotification;
    private long maxContentLength = Long.MAX_VALUE;

    public ChuckInterceptor(Context context) {
        this.context = context.getApplicationContext();
        this.notificationHelper = new NotificationHelper(this.context);
        this.showNotification = true;
        this.retentionManager = new RetentionManager(this.context, DEFAULT_RETENTION);
    }

    public ChuckInterceptor showNotification(boolean show) {
        this.showNotification = show;
        return this;
    }

    public ChuckInterceptor maxContentLength(long max) {
        this.maxContentLength = max;
        return this;
    }

    public ChuckInterceptor retainDataFor(Period period) {
        this.retentionManager = new RetentionManager(this.context, period);
        return this;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Response response;
        Request request = chain.request();
        RequestBody requestBody = request.body();
        boolean hasRequestBody = requestBody != null;
        HttpTransaction transaction = new HttpTransaction();
        transaction.setRequestDate(new Date());
        transaction.setMethod(request.method());
        transaction.setUrl(request.url().toString());
        transaction.setRequestHeaders(request.headers());
        if (hasRequestBody) {
            if (requestBody.contentType() != null) {
                transaction.setRequestContentType(requestBody.contentType().toString());
            }
            if (requestBody.contentLength() != -1L) {
                transaction.setRequestContentLength(requestBody.contentLength());
            }
        }
        transaction.setRequestBodyIsPlainText(!this.bodyHasUnsupportedEncoding(request.headers()));
        if (hasRequestBody && transaction.requestBodyIsPlainText()) {
            BufferedSource source = this.getNativeSource((BufferedSource)new Buffer(), this.bodyGzipped(request.headers()));
            Buffer buffer = source.buffer();
            requestBody.writeTo((BufferedSink)buffer);
            Charset charset = UTF8;
            MediaType contentType = requestBody.contentType();
            if (contentType != null) {
                charset = contentType.charset(UTF8);
            }
            if (this.isPlaintext(buffer)) {
                transaction.setRequestBody(this.readFromBuffer(buffer, charset));
            } else {
                transaction.setResponseBodyIsPlainText(false);
            }
        }
        Uri transactionUri = this.create(transaction);
        long startNs = System.nanoTime();
        try {
            response = chain.proceed(request);
        }
        catch (Exception e) {
            transaction.setError(e.toString());
            this.update(transaction, transactionUri);
            throw e;
        }
        long tookMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNs);
        ResponseBody responseBody = response.body();
        transaction.setRequestHeaders(response.request().headers());
        transaction.setResponseDate(new Date());
        transaction.setTookMs(tookMs);
        transaction.setProtocol(response.protocol().toString());
        transaction.setResponseCode(response.code());
        transaction.setResponseMessage(response.message());
        transaction.setResponseContentLength(responseBody.contentLength());
        if (responseBody.contentType() != null) {
            transaction.setResponseContentType(responseBody.contentType().toString());
        }
        transaction.setResponseHeaders(response.headers());
        transaction.setResponseBodyIsPlainText(!this.bodyHasUnsupportedEncoding(response.headers()));
        if (HttpHeaders.hasBody((Response)response) && transaction.responseBodyIsPlainText()) {
            BufferedSource source = this.getNativeSource(response);
            source.request(Long.MAX_VALUE);
            Buffer buffer = source.buffer();
            Charset charset = UTF8;
            MediaType contentType = responseBody.contentType();
            if (contentType != null) {
                try {
                    charset = contentType.charset(UTF8);
                }
                catch (UnsupportedCharsetException e) {
                    this.update(transaction, transactionUri);
                    return response;
                }
            }
            if (this.isPlaintext(buffer)) {
                transaction.setResponseBody(this.readFromBuffer(buffer.clone(), charset));
            } else {
                transaction.setResponseBodyIsPlainText(false);
            }
            transaction.setResponseContentLength(buffer.size());
            if (contentType != null && contentType.toString().toLowerCase().contains("json")) {
                transaction.setMalformedJson(this.isMalformedJson(transaction));
            }
        }
        this.update(transaction, transactionUri);
        return response;
    }

    private Integer isMalformedJson(HttpTransaction transaction) {
        try {
            JsonParser jp = new JsonParser();
            JsonElement je = jp.parse(transaction.getResponseBody());
            String result = JsonConvertor.getInstance().toJson(je);
            return 0;
        }
        catch (Exception e) {
            return 1;
        }
    }

    private Uri create(HttpTransaction transaction) {
        ContentValues values = LocalCupboard.getInstance().withEntity(HttpTransaction.class).toContentValues((Object)transaction);
        Uri uri = this.context.getContentResolver().insert(ChuckContentProvider.TRANSACTION_URI, values);
        transaction.setId(Long.valueOf(uri.getLastPathSegment()));
        if (this.showNotification) {
            this.notificationHelper.show(transaction);
        }
        this.retentionManager.doMaintenance();
        return uri;
    }

    private int update(HttpTransaction transaction, Uri uri) {
        ContentValues values = LocalCupboard.getInstance().withEntity(HttpTransaction.class).toContentValues((Object)transaction);
        int updated = this.context.getContentResolver().update(uri, values, null, null);
        if (this.showNotification && updated > 0) {
            this.notificationHelper.show(transaction);
        }
        return updated;
    }

    private boolean isPlaintext(Buffer buffer) {
        try {
            Buffer prefix = new Buffer();
            long byteCount = buffer.size() < 64L ? buffer.size() : 64L;
            buffer.copyTo(prefix, 0L, byteCount);
            for (int i = 0; i < 16 && !prefix.exhausted(); ++i) {
                int codePoint = prefix.readUtf8CodePoint();
                if (!Character.isISOControl(codePoint) || Character.isWhitespace(codePoint)) continue;
                return false;
            }
            return true;
        }
        catch (EOFException e) {
            return false;
        }
    }

    private boolean bodyHasUnsupportedEncoding(Headers headers) {
        String contentEncoding = headers.get("Content-Encoding");
        return contentEncoding != null && !contentEncoding.equalsIgnoreCase("identity") && !contentEncoding.equalsIgnoreCase("gzip");
    }

    private boolean bodyGzipped(Headers headers) {
        String contentEncoding = headers.get("Content-Encoding");
        return "gzip".equalsIgnoreCase(contentEncoding);
    }

    private String readFromBuffer(Buffer buffer, Charset charset) {
        long bufferSize = buffer.size();
        long maxBytes = Math.min(bufferSize, this.maxContentLength);
        String body = "";
        try {
            body = buffer.readString(maxBytes, charset);
        }
        catch (EOFException e) {
            body = body + this.context.getString(R.string.chuck_body_unexpected_eof);
        }
        if (bufferSize > this.maxContentLength) {
            body = body + this.context.getString(R.string.chuck_body_content_truncated);
        }
        return body;
    }

    private BufferedSource getNativeSource(BufferedSource input, boolean isGzipped) {
        if (isGzipped) {
            GzipSource source = new GzipSource((Source)input);
            return Okio.buffer((Source)source);
        }
        return input;
    }

    private BufferedSource getNativeSource(Response response) throws IOException {
        if (this.bodyGzipped(response.headers())) {
            BufferedSource source = response.peekBody(this.maxContentLength).source();
            if (source.buffer().size() < this.maxContentLength) {
                return this.getNativeSource(source, true);
            }
            Log.w((String)LOG_TAG, (String)"gzip encoded response was too long");
        }
        return response.body().source();
    }

    public static enum Period {
        ONE_HOUR,
        ONE_DAY,
        ONE_WEEK,
        FOREVER;

    }
}

