/*
 * Decompiled with CFR 0.152.
 */
package com.peterphi.std.guice.common.daemon;

import com.google.inject.Singleton;
import com.peterphi.std.guice.common.daemon.GuiceDaemon;
import com.peterphi.std.guice.common.daemon.GuiceRecurringDaemon;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

@Singleton
public final class GuiceDaemonRegistry {
    private Set<GuiceDaemon> daemons = new HashSet<GuiceDaemon>();

    public synchronized void register(GuiceDaemon daemon) {
        this.daemons.add(daemon);
    }

    public synchronized void unregister(GuiceDaemon daemon) {
        this.daemons.remove(daemon);
    }

    public synchronized List<GuiceDaemon> getDaemons() {
        return this.daemons.stream().filter(d -> !(d instanceof GuiceRecurringDaemon)).collect(Collectors.toList());
    }

    public synchronized List<GuiceRecurringDaemon> getRecurring() {
        return this.daemons.stream().filter(d -> d instanceof GuiceRecurringDaemon).map(d -> (GuiceRecurringDaemon)d).collect(Collectors.toList());
    }
}

