/*
 * Decompiled with CFR 0.152.
 */
package com.peterphi.std.guice.common.cached.module;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.peterphi.std.guice.common.cached.annotation.Cache;
import java.util.HashMap;
import java.util.Map;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.joda.time.DateTime;

final class CacheMethodInterceptor
implements MethodInterceptor {
    private static final Logger log = Logger.getLogger(CacheMethodInterceptor.class);
    Map<String, CacheResult> results = new HashMap<String, CacheResult>();
    private final Meter hits;
    private final Meter misses;

    public CacheMethodInterceptor(MetricRegistry registry) {
        this.hits = registry.meter("cache.hits");
        this.misses = registry.meter("cache.misses");
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        CacheResult cacheResult;
        if (invocation.getArguments().length > 0) {
            throw new IllegalArgumentException("This caching interceptor does not support caching results of method calls with arguments");
        }
        Cache options = invocation.getMethod().getAnnotation(Cache.class);
        long timeout = options.timeout();
        String key = StringUtils.isEmpty((String)options.name()) ? invocation.getMethod().toGenericString() : options.name();
        if (this.results.containsKey(key) && (cacheResult = this.results.get(key)).time.withDurationAdded(timeout, 1).isAfterNow()) {
            log.debug((Object)("Returning cached result for " + key));
            this.hits.mark();
            return cacheResult.result;
        }
        Object result = invocation.proceed();
        DateTime now = DateTime.now();
        CacheResult cr = new CacheResult(result, now);
        this.results.put(key, cr);
        this.misses.mark();
        return result;
    }

    class CacheResult {
        private final Object result;
        private final DateTime time;

        public CacheResult(Object result, DateTime time) {
            this.result = result;
            this.time = time;
        }
    }
}

