/*
 * Decompiled with CFR 0.152.
 */
package com.peterphi.std.guice.common;

import com.peterphi.std.guice.common.ClassScanner;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import org.apache.log4j.Logger;
import org.apache.xbean.finder.AnnotationFinder;
import org.apache.xbean.finder.archive.Archive;
import org.apache.xbean.finder.archive.CompositeArchive;
import org.apache.xbean.finder.archive.FileArchive;
import org.apache.xbean.finder.archive.FilteredArchive;
import org.apache.xbean.finder.archive.JarArchive;
import org.apache.xbean.finder.filter.Filter;
import org.apache.xbean.finder.filter.PrefixFilter;

public class ClassScannerFactory {
    private static final Logger log = Logger.getLogger(ClassScannerFactory.class);
    private WeakReference<ClassScanner> cached = null;
    private ClassLoader classloader;
    private String[] packages;
    private int constructions = 0;
    private long constructionTime = 0L;

    public ClassScannerFactory(String ... packages) {
        this((ClassLoader)null, packages);
    }

    public ClassScannerFactory(ClassLoader loader, String ... packages) {
        this.classloader = loader;
        this.packages = packages;
    }

    public ClassScanner getInstance() {
        ClassScanner scanner;
        if (this.packages.length == 0) {
            return null;
        }
        ClassScanner classScanner = scanner = this.cached != null ? (ClassScanner)this.cached.get() : null;
        if (scanner == null) {
            ClassLoader loader = this.classloader;
            if (loader == null) {
                loader = Thread.currentThread().getContextClassLoader();
            }
            scanner = ClassScannerFactory.forPackages(loader, this.packages);
            this.cached = new WeakReference<ClassScanner>(scanner);
            ++this.constructions;
        }
        return scanner;
    }

    private static ClassScanner forPackages(ClassLoader classloader, String ... packages) {
        long started = System.currentTimeMillis();
        CompositeArchive archive = ClassScannerFactory.getArchivesForPackage(classloader, packages);
        AnnotationFinder finder = new AnnotationFinder((Archive)archive, true);
        long finished = System.currentTimeMillis();
        return new ClassScanner(finder, finished - started);
    }

    private static CompositeArchive getArchivesForPackage(ClassLoader classloader, String ... packages) {
        try {
            ArrayList<Object> archives = new ArrayList<Object>();
            for (String pkg : packages) {
                if (!pkg.endsWith(".")) {
                    pkg = pkg + ".";
                }
                String baseFolder = pkg.replace('.', '/');
                Enumeration<URL> urls = classloader.getResources(baseFolder);
                while (urls.hasMoreElements()) {
                    URL url = urls.nextElement();
                    log.info((Object)("Found source: " + url));
                    if (url.getProtocol() != null && (url.getProtocol().equals("zip") || url.getProtocol().equals("jar"))) {
                        archives.add(new FilteredArchive((Archive)new JarArchive(classloader, url), (Filter)new PrefixFilter(pkg)));
                        continue;
                    }
                    archives.add(new FileArchive(classloader, url, pkg));
                }
            }
            return new CompositeArchive(archives);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Error loading archives for packages: " + Arrays.asList(packages), e);
        }
    }

    public int getMetricNewInstanceCount() {
        return this.constructions;
    }
}

