/*
 * Decompiled with CFR 0.152.
 */
package com.peterphi.std.guice.common;

import com.google.common.base.Predicate;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.log4j.Logger;
import org.apache.xbean.finder.AnnotationFinder;

public class ClassScanner {
    private static final Logger log = Logger.getLogger(ClassScanner.class);
    private final AnnotationFinder finder;
    private final long constructionTime;
    private final AtomicLong searchTime = new AtomicLong(0L);

    public ClassScanner(AnnotationFinder finder, long constructionTime) {
        this.finder = finder;
        this.constructionTime = constructionTime;
    }

    public long getConstructionTime() {
        return this.constructionTime;
    }

    public long getSearchTime() {
        return this.searchTime.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Class<?>> getClasses(String pkg, boolean recursive, Predicate<Class<?>> predicate) {
        long started = System.currentTimeMillis();
        try {
            List<Class<?>> list = this.filter(this.finder.findClassesInPackage(pkg, recursive), predicate);
            return list;
        }
        finally {
            long finished = System.currentTimeMillis();
            this.searchTime.addAndGet(finished - started);
            if (log.isTraceEnabled()) {
                log.trace((Object)("getClasses " + pkg + " with predicate=" + predicate + " returned in " + (finished - started) + " ms"));
            }
        }
    }

    public List<Class<?>> getClasses(String pkg, boolean recursive) {
        return this.getClasses(pkg, recursive, null);
    }

    public List<Class<?>> getSiblingClasses(Class<?> clazz, boolean recursive, Predicate<Class<?>> predicate) {
        return this.getClasses(ClassScanner.getPackages(clazz)[0], recursive, predicate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Class<?>> getAnnotatedClasses(Class<? extends Annotation> annotation, Predicate<Class<?>> predicate) {
        long started = System.currentTimeMillis();
        try {
            List<Class<?>> list = this.filter(this.finder.findAnnotatedClasses(annotation), predicate);
            return list;
        }
        finally {
            long finished = System.currentTimeMillis();
            this.searchTime.addAndGet(finished - started);
            if (log.isTraceEnabled()) {
                log.trace((Object)("getAnnotatedClasses " + annotation + " with predicate=" + predicate + " returned in " + (finished - started) + " ms"));
            }
        }
    }

    public List<Class<?>> getAnnotatedClasses(Class<? extends Annotation> annotation) {
        return this.getAnnotatedClasses(annotation, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Class<?>> getInheritedAnnotatedClasses(Class<? extends Annotation> annotation, Predicate<Class<?>> predicate) {
        long started = System.currentTimeMillis();
        try {
            List<Class<?>> list = this.filter(this.finder.findInheritedAnnotatedClasses(annotation), predicate);
            return list;
        }
        finally {
            long finished = System.currentTimeMillis();
            this.searchTime.addAndGet(finished - started);
            if (log.isTraceEnabled()) {
                log.trace((Object)("getInheritedAnnotatedClasses " + annotation + " with predicate=" + predicate + " returned in " + (finished - started) + " ms"));
            }
        }
    }

    public List<Class<?>> getInheritedAnnotatedClasses(Class<? extends Annotation> annotation) {
        return this.getInheritedAnnotatedClasses(annotation, null);
    }

    public <T> List<Class<? extends T>> getImplementations(Class<T> clazz) {
        return this.getImplementations(clazz, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> List<Class<? extends T>> getImplementations(Class<T> clazz, Predicate<Class<? extends T>> predicate) {
        long started = System.currentTimeMillis();
        try {
            if (clazz.isInterface()) {
                List<Class<? extends T>> list = this.filter(this.finder.findImplementations(clazz), predicate);
                return list;
            }
            List<Class<? extends T>> list = this.filter(this.finder.findSubclasses(clazz), predicate);
            return list;
        }
        finally {
            long finished = System.currentTimeMillis();
            this.searchTime.addAndGet(finished - started);
            if (log.isTraceEnabled()) {
                log.trace((Object)("getExtendingClasses " + clazz + " with predicate=" + predicate + " returned in " + (finished - started) + " ms"));
            }
        }
    }

    private <T> List<T> filter(List<T> list, Predicate<T> predicate) {
        if (predicate != null) {
            Iterator<T> it = list.iterator();
            while (it.hasNext()) {
                if (predicate.apply(it.next())) continue;
                it.remove();
            }
        }
        return list;
    }

    private static String[] getPackages(Class<?> ... classes) {
        HashSet<String> set = new HashSet<String>(classes.length);
        for (Class<?> clazz : classes) {
            set.add(clazz.getPackage().getName());
        }
        return set.toArray(new String[set.size()]);
    }

    public static Predicate<Class<?>> annotatedWith(final Class<? extends Annotation> annotation) {
        return new Predicate<Class<?>>(){

            public boolean apply(Class<?> input) {
                return input.isAnnotationPresent(annotation);
            }
        };
    }

    public static Predicate<Class<?>> packagePredicate(final Predicate<String> packagePredicate) {
        return new Predicate<Class<?>>(){

            public boolean apply(Class<?> input) {
                return packagePredicate.apply((Object)input.getPackage().getName());
            }
        };
    }

    public static Predicate<Class<?>> interfaceClass() {
        return new Predicate<Class<?>>(){

            public boolean apply(Class<?> input) {
                return input.isInterface();
            }
        };
    }
}

