/*
 * Decompiled with CFR 0.152.
 */
package com.peterphi.std.guice.apploader.impl;

import com.google.inject.Injector;
import com.peterphi.std.guice.apploader.GuiceApplication;
import com.peterphi.std.guice.apploader.impl.GuiceBuilder;
import com.peterphi.std.guice.common.shutdown.iface.ShutdownManager;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class GuiceRegistry {
    private static final Logger log = Logger.getLogger(GuiceRegistry.class);
    private final Object monitor = new Object();
    private final GuiceBuilder builder;
    private Injector injector;
    private Set<GuiceApplication> services = new HashSet<GuiceApplication>();

    public GuiceRegistry() {
        this(new GuiceBuilder());
    }

    public GuiceRegistry(GuiceBuilder builder) {
        this.builder = builder;
        builder.withRegistry(this);
    }

    public GuiceBuilder getBuilder() {
        return this.builder;
    }

    public synchronized void register(GuiceApplication service, boolean durable) {
        Injector injector = this.getInjector();
        injector.injectMembers((Object)service);
        if (durable && !this.services.contains(service)) {
            this.services.add(service);
        }
        service.configured();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Injector getInjector() {
        if (this.injector == null) {
            Object object = this.monitor;
            synchronized (object) {
                if (this.injector == null) {
                    log.info((Object)"Trying to create Guice Injector...");
                    this.injector = this.builder.build();
                }
            }
        }
        return this.injector;
    }

    public synchronized void stop() {
        if (this.injector != null) {
            for (GuiceApplication service : this.services) {
                try {
                    service.stopping();
                }
                catch (Throwable t) {
                    log.warn((Object)("Error shutting down service " + service + ": " + t.getMessage()), t);
                }
            }
            ShutdownManager manager = (ShutdownManager)this.injector.getInstance(ShutdownManager.class);
            manager.shutdown();
            this.injector = null;
        }
    }

    public synchronized void restart() {
        this.stop();
        try {
            for (GuiceApplication service : this.services) {
                this.register(service, true);
            }
        }
        catch (Error | RuntimeException e) {
            log.warn((Object)("Failed to restart: " + e.getMessage()), e);
            this.stop();
            throw e;
        }
    }
}

