/*
 * Decompiled with CFR 0.152.
 */
package com.peterphi.std.guice.common.stringparsing;

import com.peterphi.std.guice.common.stringparsing.InetAddressTypeConverter;
import com.peterphi.std.guice.common.stringparsing.TimeoutConverter;
import com.peterphi.std.guice.common.stringparsing.URLTypeConverter;
import com.peterphi.std.threading.Timeout;
import java.io.File;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.URI;
import java.net.URL;
import org.joda.time.DateTimeZone;

public class StringToTypeConverter {
    public static Object convert(Class<?> clazz, String val) {
        if (clazz.equals(String.class)) {
            return val;
        }
        if (clazz.equals(Integer.class) || clazz.equals(Integer.TYPE)) {
            return Integer.valueOf(val);
        }
        if (clazz.equals(Long.class) || clazz.equals(Long.TYPE)) {
            return Long.valueOf(val);
        }
        if (clazz.equals(Boolean.class) || clazz.equals(Boolean.TYPE)) {
            return StringToTypeConverter.parseBoolean(val);
        }
        if (clazz.equals(Short.class) || clazz.equals(Short.TYPE)) {
            return Short.valueOf(val);
        }
        if (clazz.equals(Double.class) || clazz.equals(Double.TYPE)) {
            return Double.valueOf(val);
        }
        if (clazz.equals(Float.class) || clazz.equals(Float.TYPE)) {
            return Float.valueOf(val);
        }
        if (clazz.equals(Timeout.class)) {
            return new TimeoutConverter().convert(val);
        }
        if (clazz.equals(InetAddress.class)) {
            return new InetAddressTypeConverter().convert(val);
        }
        if (clazz.equals(URI.class)) {
            return URI.create(val);
        }
        if (clazz.equals(URL.class)) {
            return new URLTypeConverter().convert(val);
        }
        if (clazz.equals(File.class)) {
            return new File(val);
        }
        if (clazz.equals(DateTimeZone.class)) {
            return DateTimeZone.forID((String)val);
        }
        return StringToTypeConverter.tryReflection(clazz, val);
    }

    private static Boolean parseBoolean(String val) {
        if (val.equalsIgnoreCase("true")) {
            return Boolean.TRUE;
        }
        if (val.equalsIgnoreCase("false")) {
            return Boolean.FALSE;
        }
        throw new NumberFormatException("Boolean must be true/false, got \"" + val + "\"");
    }

    private static Object tryReflection(Class<?> clazz, String val) {
        try {
            Method method = clazz.getDeclaredMethod("valueOf", String.class);
            return method.invoke(null, val);
        }
        catch (ReflectiveOperationException method) {
            try {
                Method method2 = clazz.getDeclaredMethod("getInstance", String.class);
                return method2.invoke(null, val);
            }
            catch (ReflectiveOperationException method2) {
                try {
                    Method method3 = clazz.getDeclaredMethod("parse", String.class);
                    return method3.invoke(null, val);
                }
                catch (ReflectiveOperationException reflectiveOperationException) {
                    throw new IllegalArgumentException("Could not parse \"" + val + "\" as " + clazz);
                }
            }
        }
    }
}

