/*
 * Decompiled with CFR 0.152.
 */
package com.peterphi.std.guice.common.lifecycle;

import com.google.inject.AbstractModule;
import com.google.inject.Binding;
import com.google.inject.Key;
import com.google.inject.TypeLiteral;
import com.google.inject.internal.Errors;
import com.google.inject.matcher.AbstractMatcher;
import com.google.inject.matcher.Matcher;
import com.google.inject.spi.ProvisionListener;
import com.peterphi.std.guice.common.lifecycle.GuiceLifecycleListener;
import java.lang.reflect.Field;
import org.apache.log4j.Logger;

public class GuiceLifecycleModule
extends AbstractModule {
    private static final Logger log = Logger.getLogger(GuiceLifecycleModule.class);

    protected void configure() {
        ProvisionListener provisionListener = new ProvisionListener(){

            public <T> void onProvision(ProvisionListener.ProvisionInvocation<T> provision) {
                Errors errors;
                Object instance = provision.provision();
                try {
                    Class<?> clazz = provision.getClass();
                    Field field = clazz.getDeclaredField("errors");
                    field.setAccessible(true);
                    errors = (Errors)field.get(provision);
                }
                catch (Throwable t) {
                    throw new RuntimeException("Error reflectively getting Errors object to evaluate", t);
                }
                if (errors.hasErrors()) {
                    log.warn((Object)("Errors prevent the lifecycle initialisation of instance " + instance));
                    errors.throwProvisionExceptionIfErrorsExist();
                } else {
                    GuiceLifecycleListener asLifecycle = (GuiceLifecycleListener)instance;
                    asLifecycle.postConstruct();
                }
            }
        };
        this.bindListener((Matcher)new ImplementsGuiceLifecycleBindingListener(), new ProvisionListener[]{provisionListener});
    }

    static class ImplementsGuiceLifecycleBindingListener
    extends AbstractMatcher<Binding<?>> {
        ImplementsGuiceLifecycleBindingListener() {
        }

        public boolean matches(Binding<?> binding) {
            Key key = binding.getKey();
            TypeLiteral typeLiteral = key.getTypeLiteral();
            return GuiceLifecycleListener.class.isAssignableFrom(typeLiteral.getRawType());
        }
    }
}

