/*
 * Decompiled with CFR 0.152.
 */
package com.peterphi.std.guice.apploader.impl;

import com.google.inject.Injector;
import com.google.inject.Module;
import com.peterphi.std.guice.apploader.BasicSetup;
import com.peterphi.std.guice.apploader.GuiceRole;
import com.peterphi.std.guice.apploader.GuiceSetup;
import com.peterphi.std.guice.apploader.impl.CoreGuiceRole;
import com.peterphi.std.guice.apploader.impl.GuiceFactory;
import com.peterphi.std.guice.apploader.impl.GuiceRegistry;
import com.peterphi.std.guice.common.ClassScannerFactory;
import com.peterphi.std.io.PropertyFile;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.MapConfiguration;
import org.apache.log4j.Logger;

public class GuiceBuilder {
    private static final Logger log = Logger.getLogger(GuiceBuilder.class);
    private boolean autoLoadProperties = true;
    private boolean autoLoadRoles = true;
    private ClassScannerFactory scannerFactory = null;
    private List<Configuration> configs = new ArrayList<Configuration>();
    private List<GuiceRole> roles = new ArrayList<GuiceRole>();
    private GuiceSetup setup;
    private ClassLoader classloader = Thread.currentThread().getContextClassLoader();
    private GuiceRegistry registry;

    public GuiceBuilder() {
        this.roles.add(new CoreGuiceRole());
    }

    public GuiceBuilder withRegistry(GuiceRegistry registry) {
        this.registry = registry;
        return this;
    }

    public GuiceBuilder withScannerFactory(ClassScannerFactory scannerFactory) {
        this.scannerFactory = scannerFactory;
        return this;
    }

    public GuiceBuilder withNoScannerFactory() {
        return this.withScannerFactory(new ClassScannerFactory(new String[0]));
    }

    public GuiceBuilder withRole(GuiceRole ... roles) {
        for (GuiceRole role : roles) {
            this.roles.add(role);
        }
        return this;
    }

    public GuiceBuilder withAutoLoadRoles(boolean autoLoadRoles) {
        this.autoLoadRoles = autoLoadRoles;
        return this;
    }

    public GuiceBuilder withConfig(PropertyFile ... props) {
        for (PropertyFile prop : props) {
            this.configs.add((Configuration)new MapConfiguration(prop.toProperties()));
        }
        return this;
    }

    public GuiceBuilder withConfig(String ... filenames) {
        for (String filename : filenames) {
            try {
                this.configs.addAll(GuiceFactory.loadConfig(this.classloader, filename));
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Error loading property file: " + filename);
            }
        }
        return this;
    }

    public GuiceBuilder withConfig(Configuration ... configs) {
        for (Configuration config : configs) {
            this.configs.add(config);
        }
        return this;
    }

    public GuiceBuilder withSetup(Class<? extends GuiceSetup> clazz) {
        GuiceSetup obj;
        try {
            obj = clazz.newInstance();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not instantiate class " + clazz, e);
        }
        return this.withSetup(obj);
    }

    public GuiceBuilder withSetup(GuiceSetup setup) {
        this.setup = setup;
        return this;
    }

    public GuiceBuilder withClassloader(ClassLoader classloader) {
        this.classloader = classloader;
        return this;
    }

    public GuiceBuilder withAutoLoadProperties(boolean autoLoadProperties) {
        this.autoLoadProperties = autoLoadProperties;
        return this;
    }

    public boolean isAutoLoadProperties() {
        return this.autoLoadProperties;
    }

    public Injector build() {
        ArrayList<Configuration> configs = new ArrayList<Configuration>(this.configs);
        ArrayList<GuiceRole> roles = new ArrayList<GuiceRole>(this.roles);
        return GuiceFactory.build(this.registry, this.scannerFactory, configs, roles, this.setup, this.autoLoadProperties, this.autoLoadRoles, this.classloader);
    }

    public static GuiceBuilder forTesting() {
        return new GuiceBuilder().withAutoLoadRoles(false);
    }

    public static GuiceBuilder forTesting(Module ... modules) {
        return GuiceBuilder.forTesting().withSetup(new BasicSetup(modules));
    }
}

