/*
 * Decompiled with CFR 0.152.
 */
package com.peterphi.std.guice.common.stringparsing;

import com.peterphi.std.threading.Timeout;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class TimeoutConverter {
    private static final Pattern pattern = Pattern.compile("^([0-9]+)\\s*([a-zA-Z]+)$", 2);

    TimeoutConverter() {
    }

    public Object convert(String value) {
        char last = (value = value.trim()).charAt(value.length() - 1);
        if (Character.isDigit(last)) {
            return new Timeout(Long.parseLong(value), TimeUnit.MILLISECONDS);
        }
        Matcher matcher = pattern.matcher(value);
        if (matcher.matches()) {
            long quantity = Long.valueOf(matcher.group(1));
            String unit = matcher.group(2);
            return new Timeout(quantity, this.parseUnit(unit));
        }
        throw new IllegalArgumentException("Cannot parse duration: " + value);
    }

    private TimeUnit parseUnit(String unit) {
        if ("ms".equalsIgnoreCase(unit) || "millisecond".equalsIgnoreCase(unit) || "milliseconds".equalsIgnoreCase(unit)) {
            return TimeUnit.MILLISECONDS;
        }
        if ("s".equalsIgnoreCase(unit) || "sec".equalsIgnoreCase(unit) || "seconds".equalsIgnoreCase(unit) || "second".equalsIgnoreCase(unit)) {
            return TimeUnit.SECONDS;
        }
        if ("m".equalsIgnoreCase(unit) || "min".equalsIgnoreCase(unit) || "minute".equalsIgnoreCase(unit) || "minutes".equalsIgnoreCase(unit)) {
            return TimeUnit.MINUTES;
        }
        if ("h".equalsIgnoreCase(unit) || "hour".equalsIgnoreCase(unit) || "hours".equalsIgnoreCase(unit)) {
            return TimeUnit.HOURS;
        }
        if ("d".equalsIgnoreCase(unit) || "day".equalsIgnoreCase(unit) || "days".equalsIgnoreCase(unit)) {
            return TimeUnit.DAYS;
        }
        throw new IllegalArgumentException("Unknown unit: " + unit);
    }
}

