/*
 * Decompiled with CFR 0.152.
 */
package com.peterphi.std.guice.common.retry.retry;

import com.codahale.metrics.Meter;
import com.codahale.metrics.Timer;
import com.peterphi.std.guice.common.retry.retry.Retryable;
import com.peterphi.std.guice.common.retry.retry.backoff.BackoffStrategy;
import org.apache.log4j.Logger;

public class RetryManager {
    private static final Logger log = Logger.getLogger(RetryManager.class);
    private final BackoffStrategy backoff;
    private final int maxAttempts;
    private final Timer attempts;
    private final Meter attemptFailures;

    public RetryManager(BackoffStrategy strategy, int maxAttempts, Timer attempts, Meter attemptFailures) {
        this.attempts = attempts;
        this.attemptFailures = attemptFailures;
        if (strategy == null) {
            throw new IllegalArgumentException("Must provide a backoff strategy!");
        }
        if (maxAttempts <= 0) {
            throw new IllegalArgumentException("Must provide max attempts!");
        }
        this.backoff = strategy;
        this.maxAttempts = maxAttempts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T run(Retryable<T> operation) throws Exception {
        int attempt = 1;
        while (true) {
            if (attempt != 1) {
                this.sleep(attempt);
            }
            Timer.Context timer = this.attempts.time();
            try {
                T t = operation.attempt(attempt);
                return t;
            }
            catch (Throwable e) {
                boolean retry;
                this.attemptFailures.mark();
                boolean bl = retry = !this.maxAttemptsReached(attempt) && operation.shouldRetry(attempt, e);
                if (!retry) {
                    T t = this.finalAttemptFailed(operation, attempt, e);
                    return t;
                }
                log.warn((Object)("Attempt #" + attempt + " of " + operation + " failed, will retry."), e);
            }
            finally {
                timer.stop();
            }
            ++attempt;
        }
    }

    protected boolean maxAttemptsReached(int attempt) {
        return attempt >= this.maxAttempts;
    }

    protected <T> T finalAttemptFailed(Retryable<T> operation, int attempt, Throwable e) throws Exception {
        log.error((Object)("Final attempt #" + attempt + " of " + operation + " failed."), e);
        if (e instanceof Exception) {
            throw (Exception)e;
        }
        if (e instanceof Error) {
            throw (Error)e;
        }
        throw new RuntimeException(e);
    }

    public <T> T runUnchecked(Retryable<T> operation) throws RuntimeException {
        try {
            return this.run(operation);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Retryable " + operation + " failed: " + e.getMessage(), e);
        }
    }

    private void sleep(int attempt) {
        long sleepTime = this.backoff.getBackoff(attempt);
        try {
            Thread.sleep(sleepTime);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
    }
}

