/*
 * Decompiled with CFR 0.152.
 */
package com.peterphi.std.guice.apploader.impl;

import com.codahale.metrics.MetricRegistry;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Stage;
import com.peterphi.std.guice.apploader.GuiceRole;
import com.peterphi.std.guice.apploader.GuiceSetup;
import com.peterphi.std.guice.apploader.impl.GuiceRegistry;
import com.peterphi.std.guice.apploader.impl.GuiceRegistryModule;
import com.peterphi.std.guice.common.ClassScanner;
import com.peterphi.std.guice.common.metrics.CoreMetricsModule;
import com.peterphi.std.guice.common.shutdown.ShutdownModule;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

class GuiceFactory {
    private static final Logger log = Logger.getLogger(GuiceFactory.class);

    GuiceFactory() {
    }

    static Injector build(GuiceRegistry registry, ClassScanner scanner, List<Configuration> configs, List<GuiceRole> roles, GuiceSetup staticSetup, boolean autoLoadProperties, boolean autoLoadRoles, ClassLoader classloader) {
        GuiceSetup setup;
        CompositeConfiguration config;
        PropertiesConfiguration overrideFile;
        ServiceLoader<GuiceRole> loader = ServiceLoader.load(GuiceRole.class);
        if (autoLoadRoles) {
            for (GuiceRole role : loader) {
                log.debug((Object)("Discovered guice role: " + role));
                roles.add(role);
            }
        }
        for (GuiceRole role : roles) {
            log.debug((Object)("Adding requested guice role: " + role));
            role.adjustConfigurations(configs);
        }
        if (autoLoadProperties) {
            CompositeConfiguration tempConfig = GuiceFactory.combine(null, configs);
            configs.addAll(GuiceFactory.loadConfigs(classloader, tempConfig));
        }
        if ((overrideFile = GuiceFactory.load((config = GuiceFactory.combine(null, configs)).getString("override-properties.file"))) != null) {
            log.debug((Object)("Applying overrides: " + overrideFile.getFile()));
            config = GuiceFactory.combine((Configuration)overrideFile, configs);
        }
        if (staticSetup == null) {
            Class<GuiceSetup> setupClass = GuiceFactory.getClass((Configuration)config, GuiceSetup.class, "guice.bootstrap.class");
            try {
                if (setupClass == null) {
                    throw new IllegalArgumentException("Could not find a setup class!");
                }
                setup = setupClass.newInstance();
                log.debug((Object)("Constructed GuiceSetup: " + setupClass));
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new IllegalArgumentException("Error constructing instance of " + setupClass, e);
            }
        } else {
            log.debug((Object)("Using static GuiceSetup: " + staticSetup));
            setup = staticSetup;
        }
        return GuiceFactory.createInjector(registry, scanner, config, overrideFile, setup, roles);
    }

    private static Injector createInjector(GuiceRegistry registry, ClassScanner scanner, CompositeConfiguration config, PropertiesConfiguration override, GuiceSetup setup, List<GuiceRole> roles) {
        List packages;
        AtomicReference<Injector> injectorRef = new AtomicReference<Injector>();
        ArrayList<Module> modules = new ArrayList<Module>();
        Stage stage = Stage.valueOf((String)config.getString("mode", Stage.DEVELOPMENT.name()));
        ShutdownModule shutdown = new ShutdownModule();
        if (scanner == null && (packages = config.getList("scan.packages", Collections.emptyList())) != null && !packages.isEmpty()) {
            scanner = ClassScanner.forPackages(packages.toArray(new String[packages.size()]));
        }
        try {
            MetricRegistry metricRegistry = CoreMetricsModule.buildRegistry();
            modules.add((Module)shutdown);
            if (registry != null) {
                modules.add((Module)new GuiceRegistryModule(registry));
            }
            for (GuiceRole role : roles) {
                role.register(stage, scanner, config, override, setup, modules, injectorRef, metricRegistry);
            }
            setup.registerModules(modules, (Configuration)config);
            if (log.isTraceEnabled()) {
                log.trace((Object)("Creating Injector with modules: " + modules));
            }
            Injector injector = Guice.createInjector((Stage)stage, modules);
            injectorRef.set(injector);
            for (GuiceRole role : roles) {
                role.injectorCreated(stage, scanner, config, override, setup, modules, injectorRef, metricRegistry);
            }
            setup.injectorCreated(injector);
            return injector;
        }
        catch (Throwable t) {
            log.error((Object)"Error creating injector", t);
            shutdown.shutdown();
            throw t;
        }
    }

    private static List<Configuration> loadConfigs(ClassLoader classloader, CompositeConfiguration tempConfig) {
        ArrayList<Configuration> configs = new ArrayList<Configuration>();
        for (String configFile : GuiceFactory.getPropertyFiles(tempConfig)) {
            try {
                configs.addAll(GuiceFactory.loadConfig(classloader, configFile));
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Error loading configuration URLs from " + configFile, e);
            }
        }
        return configs;
    }

    private static List<String> getPropertyFiles(CompositeConfiguration tempConfig) {
        ArrayList<String> configFiles = new ArrayList<String>();
        configFiles.add("environment.properties");
        configFiles.add("service.properties");
        String contextName = tempConfig.getString("servlet:context-name", "").replaceAll("/", "");
        if (!StringUtils.isEmpty((String)contextName)) {
            configFiles.add("services/" + contextName + ".properties");
        }
        return configFiles;
    }

    static List<Configuration> loadConfig(ClassLoader loader, String name) throws IOException {
        log.trace((Object)("Search for config files with name: " + name));
        ArrayList<Configuration> configs = new ArrayList<Configuration>();
        Enumeration<URL> urls = loader.getResources(name);
        while (urls.hasMoreElements()) {
            URL url = urls.nextElement();
            log.debug((Object)("Loading property file: " + url));
            try {
                configs.add((Configuration)new PropertiesConfiguration(url));
            }
            catch (ConfigurationException e) {
                throw new IOException("Error loading config from " + url, e);
            }
        }
        return configs;
    }

    private static <T> Class<? extends T> getClass(Configuration configuration, Class<T> base, String property) {
        String prop = configuration.getString(property);
        if (StringUtils.isEmpty((String)prop)) {
            return null;
        }
        try {
            Class<?> clazz = Class.forName(prop);
            if (base.isAssignableFrom(clazz)) {
                return clazz;
            }
            throw new IllegalArgumentException("Error loading class " + clazz + " - is not assignable from " + base);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Error loading class " + prop + " from config property " + property, e);
        }
    }

    private static PropertiesConfiguration load(String propertyFile) {
        if (propertyFile == null) {
            return null;
        }
        try {
            File file = new File(propertyFile);
            if (file.exists()) {
                return new PropertiesConfiguration(file);
            }
            PropertiesConfiguration prop = new PropertiesConfiguration();
            prop.setFile(file);
            return prop;
        }
        catch (ConfigurationException e) {
            throw new IllegalArgumentException("Failed to load property file: " + propertyFile, e);
        }
    }

    private static CompositeConfiguration combine(Configuration overrides, List<Configuration> configs) {
        CompositeConfiguration config = new CompositeConfiguration();
        if (overrides != null) {
            config.addConfiguration(overrides, true);
        }
        for (int i = configs.size() - 1; i >= 0; --i) {
            config.addConfiguration(configs.get(i));
        }
        return config;
    }
}

