/*
 * Decompiled with CFR 0.152.
 */
package com.peterphi.std.guice.common.resource.impl;

import com.peterphi.std.guice.common.resource.iface.ResourceNotFoundException;
import com.peterphi.std.guice.common.resource.iface.ResourceProvider;
import com.peterphi.std.io.PropertyFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.Reader;
import org.apache.commons.io.IOUtils;

public class FilesystemResourceProviderImpl
implements ResourceProvider {
    private final File root;

    public FilesystemResourceProviderImpl(File root) {
        this.root = root;
    }

    private File getFileForResource(String name) {
        String relativePath = name.replace('/', File.pathSeparatorChar);
        return new File(this.root, relativePath);
    }

    @Override
    public InputStream getBinaryResource(String name) {
        File file = this.getFileForResource(name);
        if (file.exists()) {
            try {
                return new FileInputStream(file);
            }
            catch (Exception e) {
                throw new ResourceNotFoundException("Error reading resource from " + file + ": " + e.getMessage(), e);
            }
        }
        throw new ResourceNotFoundException("No such resource '" + name + "' in " + this.root);
    }

    @Override
    public Reader getTextResource(String name) {
        File file = this.getFileForResource(name);
        if (file.exists()) {
            try {
                return new FileReader(file);
            }
            catch (Exception e) {
                throw new ResourceNotFoundException("Error reading resource from " + file + ": " + e.getMessage(), e);
            }
        }
        throw new ResourceNotFoundException("No such resource '" + name + "' in " + this.root);
    }

    @Override
    public PropertyFile getPropertyResource(String name) {
        Reader reader = this.getTextResource(name);
        try {
            PropertyFile propertyFile = new PropertyFile(reader);
            return propertyFile;
        }
        catch (Exception e) {
            throw new ResourceNotFoundException("Error loading PropertyFile '" + name + ": " + e.getMessage(), e);
        }
        finally {
            IOUtils.closeQuietly((Reader)reader);
        }
    }
}

