/*
 * Decompiled with CFR 0.152.
 */
package com.peterphi.std.guice.common.metrics;

import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.jvm.FileDescriptorRatioGauge;
import com.codahale.metrics.jvm.GarbageCollectorMetricSet;
import com.codahale.metrics.jvm.MemoryUsageGaugeSet;
import com.codahale.metrics.jvm.ThreadStatesGaugeSet;
import com.codahale.metrics.log4j.InstrumentedAppender;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.peterphi.std.guice.common.shutdown.iface.ShutdownManager;
import com.peterphi.std.guice.common.shutdown.iface.StoppableService;
import org.apache.log4j.Appender;
import org.apache.log4j.LogManager;

@Singleton
public class StatsRegistry
implements StoppableService {
    private final MetricRegistry registry = new MetricRegistry();

    @Inject
    public StatsRegistry(ShutdownManager manager) {
        this.registry.register(MetricRegistry.name((String)"jvm", (String[])new String[]{"gc"}), (Metric)new GarbageCollectorMetricSet());
        this.registry.register(MetricRegistry.name((String)"jvm", (String[])new String[]{"memory"}), (Metric)new MemoryUsageGaugeSet());
        this.registry.register(MetricRegistry.name((String)"jvm", (String[])new String[]{"thread-states"}), (Metric)new ThreadStatesGaugeSet());
        this.registry.register(MetricRegistry.name((String)"jvm", (String[])new String[]{"fd", "usage"}), (Metric)new FileDescriptorRatioGauge());
        InstrumentedAppender log4jmetrics = new InstrumentedAppender(this.registry);
        log4jmetrics.activateOptions();
        LogManager.getRootLogger().addAppender((Appender)log4jmetrics);
        manager.register(this);
    }

    public MetricRegistry getRegistry() {
        return this.registry;
    }

    @Override
    public void shutdown() {
    }
}

