/*
 * Decompiled with CFR 0.152.
 */
package com.peterphi.std.guice.common;

import com.google.inject.AbstractModule;
import com.peterphi.std.io.PropertyFile;
import java.util.Properties;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class Log4JModule
extends AbstractModule {
    private static Logger log = Logger.getLogger(Log4JModule.class);
    private PropertyFile guiceConfig;
    private String configFile;

    public Log4JModule(PropertyFile properties) {
        this.guiceConfig = properties;
        this.configFile = properties.get("log4j.properties", null);
    }

    protected void configure() {
        if (this.configFile != null) {
            log.debug((Object)("Loading log4j configuration from " + this.configFile));
            PropertyFile config = this.configFile.equals("embedded") ? this.guiceConfig : PropertyFile.find((String)this.configFile);
            LogManager.resetConfiguration();
            PropertyConfigurator.configure((Properties)config.toProperties());
        } else {
            log.debug((Object)"Leaving logging subsystem to initialise itself");
        }
    }
}

