/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.rpc.sys.helper;

import com.perforce.p4java.Log;
import java.lang.reflect.Method;

public class TextNormalizationHelper {
    public static final String NORMALIZER_CLASS_NAME = "java.text.Normalizer";
    public static final String NORMALIZER_FORM_CLASS_NAME = "java.text.Normalizer$Form";
    public static final String NORMALIZER_NORMALIZE_METHOD_NAME = "normalize";
    public static final String NORMALIZER_IS_NORMALIZED_METHOD_NAME = "isNormalized";
    private static Class<?> normalizerClass = null;
    private static Class<?> normalizerFormClass = null;
    private static Method normalizeMethod = null;
    private static Method isNormalizedMethod = null;
    private static Object[] normalizerForms = null;
    private static Object nfcNormalization = null;
    private static boolean normalizeCapable = false;

    public static boolean isNormalizationCapable() {
        return normalizeCapable;
    }

    public static boolean isNormalized(String text) {
        if (normalizeCapable && text != null) {
            try {
                return (Boolean)isNormalizedMethod.invoke(null, text, nfcNormalization);
            }
            catch (Throwable thr) {
                Log.error("Unexpected exception invoking method: " + thr.getLocalizedMessage(), new Object[0]);
                Log.exception(thr);
            }
        }
        return false;
    }

    public static String normalize(String text) {
        if (normalizeCapable && text != null) {
            try {
                return (String)normalizeMethod.invoke(null, text, nfcNormalization);
            }
            catch (Throwable thr) {
                Log.error("Unexpected exception invoking method: " + thr.getLocalizedMessage(), new Object[0]);
                Log.exception(thr);
            }
        }
        return null;
    }

    static {
        Log.info("Checking this Java for text normalization support...", new Object[0]);
        try {
            normalizerClass = Class.forName(NORMALIZER_CLASS_NAME);
            normalizerFormClass = Class.forName(NORMALIZER_FORM_CLASS_NAME);
            normalizeMethod = normalizerClass.getDeclaredMethod(NORMALIZER_NORMALIZE_METHOD_NAME, CharSequence.class, normalizerFormClass);
            isNormalizedMethod = normalizerClass.getDeclaredMethod(NORMALIZER_IS_NORMALIZED_METHOD_NAME, CharSequence.class, normalizerFormClass);
            normalizerForms = normalizerFormClass.getEnumConstants();
            for (int i = 0; i < normalizerForms.length; ++i) {
                if (!normalizerForms[i].toString().equals("NFC")) continue;
                nfcNormalization = normalizerForms[i];
            }
            if (normalizeMethod != null && isNormalizedMethod != null && normalizerForms != null && nfcNormalization != null) {
                normalizeCapable = true;
                Log.info("It seems this Java supports text normalization.", new Object[0]);
            }
        }
        catch (ClassNotFoundException cnfe) {
            Log.error("Unable to find class: " + cnfe.getLocalizedMessage(), new Object[0]);
            Log.exception(cnfe);
        }
        catch (NoSuchMethodException nsme) {
            Log.error("No such method for class: " + nsme.getLocalizedMessage(), new Object[0]);
            Log.exception(nsme);
        }
        catch (Throwable thr) {
            Log.error("Unexpected exception introspecting class: " + thr.getLocalizedMessage(), new Object[0]);
            Log.exception(thr);
        }
    }
}

