/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.generic.core;

import com.perforce.p4java.Log;
import com.perforce.p4java.core.IMapEntry;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class MapEntry
implements IMapEntry {
    protected static String elementPatternStr = "([^\"]\\S*|\".+?\")\\s*";
    protected static Pattern elementPattern = Pattern.compile(elementPatternStr);
    protected int order = -1;
    protected IMapEntry.EntryType type = null;
    protected String left = null;
    protected String right = null;
    protected String comment = null;

    public MapEntry() {
    }

    public MapEntry(int order, String left, String right) {
        this.order = order;
        if (right != null) {
            this.right = MapEntry.stripTypePrefix(right);
            this.comment = MapEntry.parseComments(right);
        }
        if (left != null) {
            this.type = IMapEntry.EntryType.fromString(left);
            this.left = MapEntry.stripTypePrefix(left);
            this.comment = MapEntry.parseComments(left);
        }
    }

    public MapEntry(int order, IMapEntry.EntryType type, String left, String right) {
        this.order = order;
        this.type = type;
        if (left != null) {
            this.left = MapEntry.stripTypePrefix(left);
            this.comment = MapEntry.parseComments(left);
        }
        if (right != null) {
            this.right = MapEntry.stripTypePrefix(right);
            this.comment = MapEntry.parseComments(right);
        }
    }

    public MapEntry(int order, String mappingStr) {
        this.order = order;
        if (mappingStr != null) {
            String[] entries = MapEntry.parseViewMappingString(mappingStr);
            this.type = IMapEntry.EntryType.fromString(entries[0]);
            this.left = MapEntry.stripTypePrefix(entries[0]);
            this.right = entries[1];
            this.comment = MapEntry.parseComments(mappingStr);
        }
    }

    public MapEntry(IMapEntry entry) {
        if (entry != null) {
            this.order = entry.getOrder();
            this.type = entry.getType();
            this.left = entry.getLeft();
            this.right = entry.getRight();
            this.comment = entry.getComment();
        }
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    @Override
    public void setOrder(int position) {
        this.order = position;
    }

    @Override
    public IMapEntry.EntryType getType() {
        return this.type;
    }

    @Override
    public void setType(IMapEntry.EntryType type) {
        this.type = type;
    }

    @Override
    public String getLeft() {
        return this.getLeft(false);
    }

    @Override
    public String getLeft(boolean quoteBlanks) {
        if (quoteBlanks && this.left != null && (this.left.contains(" ") || this.left.contains("\t"))) {
            return "\"" + this.left + "\"";
        }
        return this.left;
    }

    @Override
    public void setLeft(String left) {
        this.left = left;
    }

    @Override
    public String getRight() {
        return this.getRight(false);
    }

    @Override
    public String getRight(boolean quoteBlanks) {
        if (quoteBlanks && this.right != null && (this.right.contains(" ") || this.right.contains("\t"))) {
            return "\"" + this.right + "\"";
        }
        return this.right;
    }

    @Override
    public void setRight(String right) {
        this.right = right;
    }

    @Override
    public String getComment() {
        return this.getComment(false);
    }

    @Override
    public String getComment(boolean quoteBlanks) {
        if (quoteBlanks && this.comment != null && (this.comment.contains(" ") || this.comment.contains("\t"))) {
            return "\"" + this.comment + "\"";
        }
        return this.comment;
    }

    @Override
    public void setComment(String comment) {
        this.comment = comment;
    }

    @Override
    public String toString(String sepString, boolean quoteBlanks) {
        StringBuilder retVal = new StringBuilder();
        this.formatLeft(quoteBlanks, retVal);
        if (StringUtils.isNotEmpty((CharSequence)sepString) && this.right != null) {
            retVal.append(sepString);
        }
        this.formatRight(quoteBlanks, retVal);
        if (this.comment != null) {
            retVal.append(" ## ");
            retVal.append(this.comment);
        }
        return retVal.toString();
    }

    private void formatRight(boolean quoteBlanks, StringBuilder retVal) {
        if (!Objects.isNull(this.right)) {
            boolean shouldQuoteBlank;
            boolean bl = shouldQuoteBlank = quoteBlanks && this.right.contains(" ") && !this.right.startsWith("\"");
            if (shouldQuoteBlank) {
                retVal.append("\"");
            }
            retVal.append(this.right);
            if (shouldQuoteBlank) {
                retVal.append("\"");
            }
        }
    }

    private void formatLeft(boolean quoteBlanks, StringBuilder retVal) {
        if (Objects.nonNull(this.left)) {
            boolean shouldAppendType;
            boolean shouldQuote;
            boolean bl = shouldQuote = quoteBlanks && this.left.contains(" ") && !this.left.startsWith("\"");
            if (shouldQuote) {
                retVal.append("\"");
            }
            boolean bl2 = shouldAppendType = this.type != null && this.type != IMapEntry.EntryType.INCLUDE;
            if (shouldAppendType) {
                if (this.left.startsWith("\"")) {
                    retVal.append(this.left);
                    String startWith1 = "\"" + this.type;
                    retVal.replace(0, 1, startWith1);
                } else {
                    retVal.append((Object)this.type);
                    retVal.append(this.left);
                }
            } else {
                retVal.append(this.left);
            }
            if (shouldQuote) {
                retVal.append("\"");
            }
        }
    }

    @Override
    public String toString() {
        return this.toString(" ", true);
    }

    public static String stripTypePrefix(String str) {
        if (str == null) {
            return null;
        }
        String stripped = MapEntry.stripComments(str);
        for (IMapEntry.EntryType type : IMapEntry.EntryType.values()) {
            if (type.equals((Object)IMapEntry.EntryType.INCLUDE) || !stripped.startsWith(type.getSymbol())) continue;
            return stripped.substring(type.getSymbol().length());
        }
        return stripped;
    }

    public static String parseComments(String str) {
        if (str == null) {
            return null;
        }
        if (!str.contains("##")) {
            return null;
        }
        String retVal = str.substring(str.indexOf("##") + 2);
        return retVal.trim();
    }

    public static String stripComments(String str) {
        if (str == null) {
            return null;
        }
        if (str.contains("##")) {
            return str.substring(0, str.indexOf("##"));
        }
        return str;
    }

    public static String[] parseViewMappingString(String rawStr) {
        String[] retVal = new String[]{null, null};
        if (rawStr == null) {
            return retVal;
        }
        String str = MapEntry.stripComments(rawStr);
        Matcher mat = elementPattern.matcher(str);
        int fields = 0;
        while (mat.find()) {
            if (mat.groupCount() <= 0 || mat.group(1) == null) continue;
            retVal[fields] = mat.group(1).startsWith("\"") ? mat.group(1).replaceAll("^\"|\"$", "") : mat.group(1);
            ++fields;
        }
        if (fields > 3) {
            Log.warn("Bad view map field count in MapEntry.parseViewString: '" + str + "' (" + fields + ")", new Object[0]);
        }
        return retVal;
    }

    protected static String quoteWhitespaceString(String str) {
        if (str != null && (((String)str).contains(" ") || ((String)str).contains("\t"))) {
            if (!((String)str).startsWith("\"")) {
                str = "\"" + (String)str;
            }
            if (!((String)str).endsWith("\"")) {
                str = (String)str + "\"";
            }
        }
        return str;
    }
}

