/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.diff;

import com.perforce.p4java.diff.ISequence;
import com.perforce.p4java.diff.Snake;
import com.perforce.p4java.exception.FileEncoderException;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;

public class DiffAnalyze {
    static int P4TUNE_DIFF_STHRESH = 50000;
    static int P4TUNE_DIFF_SLIMIT1 = 10000000;
    static int P4TUNE_DIFF_SLIMIT2 = 100000000;
    static int DEBUG_LEVEL = 0;
    private int maxD;
    private ISequence a;
    private ISequence b;
    private Snake firstSnake;
    private Snake lastSnake;
    private SymmetricVector fV = new SymmetricVector();
    private SymmetricVector rV = new SymmetricVector();

    public DiffAnalyze(ISequence fromFile, ISequence toFile) throws IOException, FileEncoderException {
        this.Init(fromFile, toFile, 0);
    }

    public DiffAnalyze(ISequence fromFile, ISequence toFile, int fastMaxD) throws IOException, FileEncoderException {
        this.Init(fromFile, toFile, fastMaxD);
    }

    private void Init(ISequence fromFile, ISequence toFile, int fastMaxD) throws IOException, FileEncoderException {
        this.a = fromFile;
        this.b = toFile;
        int avgLines = (this.a.Lines() + this.b.Lines()) / 2;
        int sThresh = P4TUNE_DIFF_STHRESH;
        int sLimit1 = P4TUNE_DIFF_SLIMIT1;
        int sLimit2 = P4TUNE_DIFF_SLIMIT2;
        int sLimit = fastMaxD == 0 && avgLines < sThresh ? sLimit2 : sLimit1;
        this.maxD = sLimit / (avgLines != 0 ? avgLines : 1);
        if (this.maxD > avgLines) {
            this.maxD = avgLines;
        }
        if (this.maxD < 42) {
            this.maxD = 42;
        }
        this.fV.Resize(this.maxD);
        this.rV.Resize(this.maxD);
        this.lastSnake = null;
        this.firstSnake = null;
        if (DEBUG_LEVEL > 0) {
            System.out.printf("N %d M %d maxD %d\n", this.a.Lines(), this.b.Lines(), this.maxD);
        }
        if (this.a.Lines() > 0 && this.b.Lines() > 0) {
            this.LCS(0, 0, this.a.Lines(), this.b.Lines());
        }
        this.fV.Resize(0);
        this.rV.Resize(0);
        this.BracketSnake();
        this.ApplyForwardBias();
    }

    public ISequence GetFromFile() {
        return this.a;
    }

    public ISequence GetToFile() {
        return this.b;
    }

    public Snake GetSnake() {
        return this.firstSnake;
    }

    private void BracketSnake() {
        Snake toadd;
        Snake s = this.firstSnake;
        if (s == null || s.x.get() != 0 || s.y.get() != 0) {
            toadd = new Snake();
            toadd.x.set(0);
            toadd.u.set(0);
            toadd.y.set(0);
            toadd.v.set(0);
            toadd.next = s;
            if (s == null) {
                this.lastSnake = toadd;
            }
            this.firstSnake = toadd;
        }
        s = this.lastSnake;
        if (s.u.get() < this.a.Lines() || s.v.get() < this.b.Lines()) {
            toadd = new Snake();
            toadd.x.set(this.a.Lines());
            toadd.u.set(this.a.Lines());
            toadd.y.set(this.b.Lines());
            toadd.v.set(this.b.Lines());
            toadd.next = null;
            s.next = toadd;
            this.lastSnake = toadd;
        }
    }

    private void ApplyForwardBias() throws IOException, FileEncoderException {
        int endx = this.a.Lines();
        int endy = this.b.Lines();
        Snake s = this.firstSnake;
        Snake next = s.next;
        while (next != null) {
            while (s.u.get() < endx && s.v.get() < endy && this.a.Equal(s.u.get(), this.b, s.v.get())) {
                s.u.incrementAndGet();
                s.v.incrementAndGet();
                if (s.u.get() <= next.x.get() && s.v.get() <= next.y.get()) continue;
                next.x.incrementAndGet();
                next.y.incrementAndGet();
                if (next.x.get() != next.u.get() || next == this.lastSnake) continue;
                next = s.next = next.next;
            }
            s = next;
            next = next.next;
        }
    }

    private void FollowDiagonal(AtomicInteger x, AtomicInteger y, int endx, int endy) {
        while (x.get() < endx && y.get() < endy && this.a.ProbablyEqual(x.get(), this.b, y.get())) {
            x.incrementAndGet();
            y.incrementAndGet();
        }
    }

    private void FollowReverseDiagonal(AtomicInteger x, AtomicInteger y, int startx, int starty) {
        while (x.get() > startx && y.get() > starty && this.a.ProbablyEqual(x.get() - 1, this.b, y.get() - 1)) {
            x.decrementAndGet();
            y.decrementAndGet();
        }
    }

    private void FindSnake(Snake s, int startx, int starty, int endx, int endy) {
        boolean deltaEven;
        int n = endx - startx;
        int m = endy - starty;
        int delta = n - m;
        boolean bl = deltaEven = delta % 2 == 0;
        if (DEBUG_LEVEL > 2) {
            System.out.printf("FindSnake(%d,%d,%d,%d)\n", startx, starty, endx, endy);
            if (n <= 0 || m <= 0 || this.maxD <= 0) {
                throw new RuntimeException("N<=0 or M<=0 or maxD<=0 - that's not good!");
            }
        }
        s.x.set(startx);
        s.u.set(startx);
        this.fV.Set(0, startx);
        s.y.set(starty);
        s.v.set(starty);
        this.FollowDiagonal(s.u, s.v, endx, endy);
        if (s.u.get() > s.x.get()) {
            if (DEBUG_LEVEL > 2) {
                System.out.printf("FindSnake returning with initial prefix %d to %d\n", s.x.get(), s.u.get());
            }
            return;
        }
        s.u.set(endx);
        s.x.set(endx);
        this.rV.Set(0, endx);
        s.y.set(endy);
        s.v.set(endy);
        this.FollowReverseDiagonal(s.x, s.y, startx, starty);
        if (s.u.get() > s.x.get()) {
            if (DEBUG_LEVEL > 2) {
                System.out.printf("FindSnake returning with initial suffix %d to %d\n", s.x.get(), s.u.get());
            }
            return;
        }
        for (int d = 1; d <= this.maxD; ++d) {
            int k;
            int minkF = d <= m ? -d : -(2 * m - d);
            int maxkF = d <= n ? d : 2 * n - d;
            int minkR = -maxkF;
            int maxkR = -minkF;
            if (DEBUG_LEVEL > 3) {
                System.out.printf("D=%d Forward min,max (%d,%d) Reverse min,max (%d,%d)\n", d, minkF, maxkF, minkR, maxkR);
            }
            for (k = minkF; k <= maxkF; k += 2) {
                if (k == minkF || k != maxkF && this.fV.Get(k + 1) > this.fV.Get(k - 1)) {
                    s.x.set(this.fV.Get(k + 1));
                } else {
                    s.x.set(this.fV.Get(k - 1) + 1);
                }
                s.u.set(s.x.get());
                s.v.set(DiffAnalyze.mapxtoy(s.u.get(), k, startx, starty));
                this.FollowDiagonal(s.u, s.v, endx, endy);
                if (!deltaEven) {
                    int pmaxkR;
                    int dr = d - 1;
                    int pminkR = dr <= n ? -dr : -(2 * n - dr);
                    int n2 = pmaxkR = dr <= m ? dr : 2 * m - dr;
                    if (DEBUG_LEVEL > 3) {
                        System.out.printf("DR=%d Reverse min,max (%d,%d)\n", dr, pminkR, pmaxkR);
                    }
                    if (k - delta >= pminkR && k - delta <= pmaxkR) {
                        if (DEBUG_LEVEL > 3) {
                            System.out.printf("s.u %d rv[%d] %d\n", s.u.get(), k - delta, this.rV.Get(k - delta));
                        }
                        if (s.u.get() >= this.rV.Get(k - delta)) {
                            s.y.set(DiffAnalyze.mapxtoy(s.x.get(), k, startx, starty));
                            if (DEBUG_LEVEL > 2) {
                                System.out.printf("FindSnake returning during forward search (%d,%d) to (%d,%d)\n", s.x.get(), s.y.get(), s.u.get(), s.v.get());
                            }
                            return;
                        }
                    }
                }
                this.fV.Set(k, s.u.get());
            }
            if (DEBUG_LEVEL > 2) {
                System.out.printf("Forward D=%d\n", d);
                this.fV.Dump(d);
            }
            for (k = minkR; k <= maxkR; k += 2) {
                if (k == maxkR || k != minkR && this.rV.Get(-1) < this.rV.Get(k + 1)) {
                    s.u.set(this.rV.Get(k - 1));
                } else {
                    s.u.set(this.rV.Get(k + 1) - 1);
                }
                s.x.set(s.u.get());
                s.y.set(DiffAnalyze.mapxtoy(s.x.get(), k, endx, endy));
                this.FollowReverseDiagonal(s.x, s.y, startx, starty);
                if (deltaEven && k + delta >= minkF && k + delta <= maxkF) {
                    if (DEBUG_LEVEL > 3) {
                        System.out.printf("s.x %d fV[%d] %d\n", s.x.get(), k + delta, this.fV.Get(k + delta));
                    }
                    if (s.x.get() <= this.fV.Get(k + delta)) {
                        s.v.set(DiffAnalyze.mapxtoy(s.u.get(), k, endx, endy));
                        if (DEBUG_LEVEL > 2) {
                            System.out.printf("FindSnake returning during reverse search (%d,%d) to (%d,%d)\n", s.x.get(), s.y.get(), s.u.get(), s.v.get());
                        }
                        return;
                    }
                }
                this.rV.Set(k, s.x.get());
            }
            if (DEBUG_LEVEL <= 2) continue;
            System.out.printf("Reverse D=%d\n", d);
            this.rV.Dump(d);
        }
        s.u.set(startx + (endx - startx) / 2);
        s.x.set(s.u.get());
        s.v.set(starty + (endy - starty) / 2);
        s.y.set(s.v.get());
        if (DEBUG_LEVEL > 2) {
            System.out.printf("exceeded maxD midpt (%d,%d)\n", s.x.get(), s.y.get());
        }
        this.FollowReverseDiagonal(s.x, s.y, startx, starty);
        this.FollowDiagonal(s.u, s.v, endx, endy);
        if (DEBUG_LEVEL > 2) {
            System.out.printf("after extending: (%d,%d) to (%d,%d)\n", s.x.get(), s.y.get(), s.u.get(), s.v.get());
        }
    }

    private static int mapxtoy(int x, int diagonal, int originx, int originy) {
        return x - (diagonal + (originx - originy));
    }

    private void LCS(int startx, int starty, int endx, int endy) throws IOException, FileEncoderException {
        Snake s = new Snake();
        this.FindSnake(s, startx, starty, endx, endy);
        if (s.x.get() > startx && s.y.get() > starty) {
            if (DEBUG_LEVEL > 0) {
                System.out.printf("LCS %d , %d , %d , %d\n", startx, starty, s.x.get(), s.y.get());
                if (s.x.get() == endx && s.y.get() == endy) {
                    throw new RuntimeException("INFINITE RECURSION!");
                }
            }
            this.LCS(startx, starty, s.x.get(), s.y.get());
        }
        if (s.u.get() > s.x.get()) {
            int snakes_added = 0;
            if (DEBUG_LEVEL > 1) {
                System.out.printf("SNAKE (%d,%d) to (%d,%d)\n", s.x.get(), s.y.get(), s.u.get(), s.v.get());
            }
            int cx = s.x.get();
            int cy = s.y.get();
            while (cx < s.u.get()) {
                s.x.set(cx);
                s.y.set(cy);
                while (cx < s.u.get() && this.a.Equal(cx, this.b, cy)) {
                    ++cx;
                    ++cy;
                }
                if (cx > s.x.get()) {
                    Snake toadd = new Snake();
                    toadd.next = null;
                    toadd.x.set(s.x.get());
                    toadd.y.set(s.y.get());
                    toadd.u.set(cx);
                    toadd.v.set(cy);
                    if (DEBUG_LEVEL > 1) {
                        ++snakes_added;
                        System.out.printf("Adding snake (%d,%d) to (%d,%d)\n", toadd.x.get(), toadd.y.get(), toadd.u.get(), toadd.v.get());
                    }
                    if (this.firstSnake != null) {
                        this.lastSnake.next = toadd;
                        this.lastSnake = toadd;
                    } else {
                        this.firstSnake = this.lastSnake = toadd;
                    }
                }
                ++cx;
                ++cy;
            }
            if (DEBUG_LEVEL > 1) {
                if (snakes_added == 0) {
                    System.out.print("SNAKE WAS COMPLETELY BOGUS!!!\n");
                }
                if (snakes_added > 1) {
                    System.out.printf("Snake was broken into %d parts!\n", snakes_added);
                }
            }
        }
        if (endx > s.u.get() && endy > s.v.get()) {
            if (DEBUG_LEVEL > 0) {
                System.out.printf("LCS %d , %d , %d , %d\n", s.u.get(), s.v.get(), endx, endy);
                if (s.u.get() == startx && s.v.get() == starty) {
                    throw new RuntimeException("INFINITE RECURSION!");
                }
            }
            this.LCS(s.u.get(), s.v.get(), endx, endy);
        }
    }

    static class SymmetricVector {
        private int halfSize = 0;
        private int[] vec = null;

        int Get(int k) {
            return this.vec[this.halfSize + k];
        }

        void Set(int k, int v) {
            this.vec[this.halfSize + k] = v;
        }

        void Resize(int newHalfSize) {
            this.halfSize = newHalfSize;
            this.vec = new int[this.halfSize * 2 + 1];
        }

        void Dump(int d) {
            int i;
            System.out.print("index: ");
            for (i = -d; i <= d; i += 2) {
                System.out.printf("%3d ", i);
            }
            System.out.print("\nline:  ");
            for (i = -d; i <= d; i += 2) {
                System.out.printf("%3d ", this.Get(i));
            }
            System.out.print("\n");
        }
    }
}

