/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.diff;

import com.perforce.p4java.diff.DiffFlags;
import com.perforce.p4java.diff.ISequence;
import com.perforce.p4java.exception.FileEncoderException;
import com.perforce.p4java.impl.mapbased.rpc.sys.RpcInputStream;
import com.perforce.p4java.impl.mapbased.rpc.sys.RpcPerforceFile;
import java.io.Closeable;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class Sequence
implements ISequence,
Closeable {
    public static int P4TUNE_FILESYS_BUFSIZE = 0x4000000;
    private final List<VarInfo> lines = new ArrayList<VarInfo>();
    private ISequencer sequencer;
    private final ReadFile readfile;

    private boolean isspace(char c) {
        return c == ' ';
    }

    private static int CHARHASH(int h, char c) {
        return 293 * h + c;
    }

    public Sequence(Sequence other, DiffFlags flags) {
        this.lines.addAll(other.lines);
        this.sequencer = null;
        this.readfile = new ReadFile();
        switch (flags.sequence) {
            case Line: {
                this.sequencer = new LineReader();
                break;
            }
            case Word: {
                this.sequencer = new WordReader();
                break;
            }
            case WClass: {
                this.sequencer = new WClassReader();
                break;
            }
            case DashL: {
                this.sequencer = new DifflReader();
                break;
            }
            case DashB: {
                this.sequencer = new DiffbReader();
                break;
            }
            case DashW: {
                this.sequencer = new DiffwReader();
            }
        }
        this.sequencer.a = this;
        this.sequencer.src = this.readfile;
    }

    public Sequence(RpcPerforceFile f, Charset charset, DiffFlags flags) throws IOException, FileEncoderException {
        this.sequencer = null;
        this.readfile = new ReadFile();
        switch (flags.sequence) {
            case Line: {
                this.sequencer = new LineReader();
                break;
            }
            case Word: {
                this.sequencer = new WordReader();
                break;
            }
            case WClass: {
                this.sequencer = new WClassReader();
                break;
            }
            case DashL: {
                this.sequencer = new DifflReader();
                break;
            }
            case DashB: {
                this.sequencer = new DiffbReader();
                break;
            }
            case DashW: {
                this.sequencer = new DiffwReader();
            }
        }
        this.sequencer.a = this;
        this.sequencer.src = this.readfile;
        this.readfile.Open(f, charset);
        this.lines.clear();
        VarInfo vi = new VarInfo();
        vi.offset = 0L;
        vi.hash = 0;
        this.lines.add(vi);
        this.sequencer.Load();
    }

    @Override
    public int Lines() {
        return this.lines.size() - 1;
    }

    public void SeekLine(int l) throws IOException, FileEncoderException {
        this.readfile.Seek(this.Off(l));
    }

    public int CopyLines(AtomicInteger l, int m, byte[] buf, int length, LineType lineType) throws IOException {
        if (this.Lines() < m) {
            m = this.Lines();
        }
        length = this.readfile.Textcpy(buf, length, this.LengthLeft(m - 1), lineType);
        if (this.LengthLeft(m - 1) == 0L) {
            l.set(m);
        }
        return length;
    }

    public boolean Dump(PrintWriter out, AtomicInteger l, int m, LineType lineType) throws IOException {
        int len;
        int llen = 0;
        byte[] buf = new byte[1024];
        while ((len = this.CopyLines(l, m, buf, 1024, lineType)) != 0) {
            for (int i = 0; i < len; ++i) {
                out.write(buf[i]);
            }
            llen = len;
        }
        return llen <= 0 || buf[llen - 1] == 10;
    }

    public long Length(int l) {
        return this.Off(l + 1) - this.Off(l);
    }

    public long Length(int l, int m) {
        return this.Off(m) - this.Off(l);
    }

    public long LengthLeft(int l) {
        return this.Off(l + 1) - this.readfile.Tell();
    }

    @Override
    public boolean Equal(int lA, ISequence b, int lB) throws IOException, FileEncoderException {
        return this.ProbablyEqual(lA, b, lB) && this.sequencer.Equal(lA, (Sequence)b, lB);
    }

    @Override
    public boolean ProbablyEqual(int lA, ISequence b, int lB) {
        return this.Hash(lA) == ((Sequence)b).Hash(lB);
    }

    public void StoreLine(int intue) {
        this.lines.get((int)this.Lines()).hash = intue;
        VarInfo varInfo = new VarInfo();
        varInfo.hash = 0;
        varInfo.offset = this.readfile.Tell();
        this.lines.add(varInfo);
    }

    private int Hash(int l) {
        return this.lines.get((int)l).hash;
    }

    private long Off(int l) {
        return this.lines.get((int)l).offset;
    }

    @Override
    public void close() {
        try {
            this.readfile.Close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void deleteFile() {
        try {
            this.readfile.deleteFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void Reuse(RpcPerforceFile f, Charset charset) throws FileEncoderException, IOException {
        this.readfile.Open(f, charset);
    }

    class DiffwReader
    extends DiffbReader {
        DiffwReader() {
        }

        @Override
        boolean Equal(int lineA, Sequence b, int lineB) throws IOException, FileEncoderException {
            char cb;
            ISequencer bs = b.sequencer;
            this.a.SeekLine(lineA);
            b.SeekLine(lineB);
            long la = this.a.Length(lineA);
            long lb = b.Length(lineB);
            char ca = la != 0L ? this.src.Get() : (char)'\u0000';
            char c = cb = lb != 0L ? bs.src.Get() : (char)'\u0000';
            while (la != 0L && lb != 0L) {
                while (this.IsWhitespace(ca) && --la != 0L) {
                    ca = this.src.Get();
                }
                while (this.IsWhitespace(cb) && --lb != 0L) {
                    cb = bs.src.Get();
                }
                if (la == 0L || lb == 0L || ca != cb) break;
                if (--la != 0L) {
                    ca = this.src.Get();
                }
                if (--lb == 0L) continue;
                cb = bs.src.Get();
            }
            while (la != 0L && (this.IsWhitespace(ca) || this.IsNewLine(ca)) && --la != 0L) {
                ca = this.src.Get();
            }
            while (lb != 0L && (this.IsWhitespace(cb) || this.IsNewLine(cb)) && --lb != 0L) {
                cb = bs.src.Get();
            }
            return la == 0L && lb == 0L;
        }

        @Override
        void Load() throws IOException {
            int h = 0;
            while (!this.src.Eof()) {
                char c = this.src.Char();
                this.src.Next();
                while (this.IsWhitespace(c) && !this.src.Eof()) {
                    c = this.src.Char();
                    this.src.Next();
                }
                if (!this.src.Eof() && c == '\r' && this.src.Char() == '\n') {
                    this.src.Next();
                }
                if (!this.IsNewLine(c) && !this.IsWhitespace(c)) {
                    h = Sequence.CHARHASH(h, c);
                }
                if (!this.src.Eof() && !this.IsNewLine(c)) continue;
                this.a.StoreLine(h);
                h = 0;
            }
        }
    }

    class DiffbReader
    extends DifflReader {
        DiffbReader() {
        }

        @Override
        boolean Equal(int lineA, Sequence b, int lineB) throws IOException, FileEncoderException {
            char cb;
            ISequencer bs = b.sequencer;
            this.a.SeekLine(lineA);
            b.SeekLine(lineB);
            long la = this.a.Length(lineA);
            long lb = b.Length(lineB);
            char ca = la != 0L ? this.src.Get() : (char)'\u0000';
            char c = cb = lb != 0L ? bs.src.Get() : (char)'\u0000';
            while (la != 0L && lb != 0L) {
                if ((this.IsWhitespace(ca) || this.IsNewLine(ca)) && (this.IsWhitespace(cb) || this.IsNewLine(cb))) {
                    while (this.IsWhitespace(ca) && --la != 0L) {
                        ca = this.src.Get();
                    }
                    while (this.IsWhitespace(cb) && --lb != 0L) {
                        cb = bs.src.Get();
                    }
                    if (la == 0L || lb == 0L) break;
                }
                if (ca != cb) break;
                if (--la != 0L) {
                    ca = this.src.Get();
                }
                if (--lb == 0L) continue;
                cb = bs.src.Get();
            }
            while (la != 0L && (this.IsWhitespace(ca) || this.IsNewLine(ca)) && --la != 0L) {
                ca = this.src.Get();
            }
            while (lb != 0L && (this.IsWhitespace(cb) || this.IsNewLine(cb)) && --lb != 0L) {
                cb = bs.src.Get();
            }
            return la == 0L && lb == 0L;
        }

        @Override
        void Load() throws IOException {
            int h = 0;
            while (!this.src.Eof()) {
                char c = this.src.Char();
                this.src.Next();
                if (this.IsWhitespace(c)) {
                    c = ' ';
                    while (!this.src.Eof() && this.IsWhitespace(this.src.Char())) {
                        this.src.Next();
                    }
                    if (this.src.Eof()) {
                        this.a.StoreLine(h);
                        break;
                    }
                    if (!this.IsNewLine(this.src.Char())) {
                        h = Sequence.CHARHASH(h, c);
                    }
                    c = this.src.Char();
                    this.src.Next();
                }
                if (!this.src.Eof() && c == '\r' && this.src.Char() == '\n') {
                    this.src.Next();
                }
                if (!this.IsNewLine(c)) {
                    h = Sequence.CHARHASH(h, c);
                }
                if (!this.src.Eof() && !this.IsNewLine(c)) continue;
                this.a.StoreLine(h);
                h = 0;
            }
        }

        boolean IsWhitespace(char c) {
            return c == ' ' || c == '\t';
        }
    }

    class DifflReader
    extends ISequencer {
        boolean testEndEOL;

        DifflReader() {
            this.testEndEOL = true;
        }

        @Override
        boolean Equal(int lineA, Sequence b, int lineB) throws IOException, FileEncoderException {
            long lb;
            ISequencer bs = b.sequencer;
            long la = this.a.Length(lineA);
            if (la > (lb = b.Length(lineB)) + 1L || la + 1L < lb) {
                return false;
            }
            this.a.SeekLine(lineA);
            b.SeekLine(lineB);
            char ca = '\u0000';
            char cb = '\u0000';
            while (la != 0L && lb != 0L && (ca = this.src.Get()) == (cb = bs.src.Get())) {
                --la;
                --lb;
            }
            if (this.testEndEOL && (la == 0L && lb == 1L && this.IsNewLine(bs.src.Get()) || lb == 0L && la == 1L && this.IsNewLine(this.src.Get()))) {
                return true;
            }
            return la == 0L && lb == 0L || this.IsNewLine(ca) || this.IsNewLine(cb);
        }

        @Override
        void Load() throws IOException {
            int h = 0;
            while (!this.src.Eof()) {
                int c = this.src.Char();
                this.src.Next();
                if (this.IsNewLine((char)c)) {
                    if (!this.src.Eof() && c == 13 && this.src.Char() == '\n') {
                        this.src.Next();
                    }
                    c = 10;
                }
                h = Sequence.CHARHASH(h, (char)c);
                if (this.src.Eof() && c != 10) {
                    h = Sequence.CHARHASH(h, '\n');
                }
                if (!this.src.Eof() && c != 10) continue;
                this.a.StoreLine(h);
                h = 0;
            }
        }

        boolean IsNewLine(char c) {
            return c == '\r' || c == '\n';
        }
    }

    class WClassReader
    extends LineReader {
        WClassReader() {
        }

        @Override
        void Load() throws IOException {
            int h = 0;
            int lastcharclass = 0;
            char c = '\u0000';
            if (this.src.Eof()) {
                return;
            }
            do {
                int charclass;
                if ((charclass = (c = this.src.Char()) == '\r' ? 1 : (c == '\n' ? 5 : (Character.isAlphabetic(c) || (c & 0x80) != 0 ? 2 : (Sequence.this.isspace(c) ? 3 : 4)))) != lastcharclass) {
                    if (charclass == 5) {
                        charclass = 6;
                        if (lastcharclass == 1) {
                            lastcharclass = 0;
                        }
                    }
                    if (lastcharclass != 0) {
                        this.a.StoreLine(h);
                        h = 0;
                    }
                    lastcharclass = charclass;
                }
                h = Sequence.CHARHASH(h, c);
                this.src.Next();
            } while (!this.src.Eof());
            this.a.StoreLine(h);
        }
    }

    class WordReader
    extends LineReader {
        WordReader() {
        }

        @Override
        void Load() throws IOException {
            int h = 0;
            if (!this.src.Eof()) {
                while (true) {
                    char c = this.src.Char();
                    this.src.Next();
                    h = Sequence.CHARHASH(h, c);
                    if (this.src.Eof()) {
                        this.a.StoreLine(h);
                        break;
                    }
                    if (!Sequence.this.isspace(c)) continue;
                    this.a.StoreLine(h);
                    h = 0;
                }
            }
        }
    }

    class LineReader
    extends ISequencer {
        LineReader() {
        }

        @Override
        boolean Equal(int lineA, Sequence b, int lineB) throws IOException, FileEncoderException {
            if (this.a.Length(lineA) != b.Length(lineB)) {
                return false;
            }
            this.a.SeekLine(lineA);
            b.SeekLine(lineB);
            return this.src.Memcmp(b.sequencer.src, this.a.Length(lineA)) == 0L;
        }

        @Override
        void Load() throws IOException {
            int h = 0;
            if (!this.src.Eof()) {
                while (true) {
                    char c = this.src.Char();
                    this.src.Next();
                    h = Sequence.CHARHASH(h, c);
                    if (this.src.Eof()) {
                        this.a.StoreLine(h);
                        break;
                    }
                    if (c != '\n') continue;
                    this.a.StoreLine(h);
                    h = 0;
                }
            }
        }
    }

    abstract class ISequencer {
        Sequence a;
        ReadFile src;

        ISequencer() {
        }

        abstract boolean Equal(int var1, Sequence var2, int var3) throws IOException, FileEncoderException;

        abstract void Load() throws IOException;
    }

    class VarInfo {
        public int hash;
        public long offset;

        VarInfo() {
        }
    }

    public static enum LineType {
        LineTypeRaw,
        LineTypeCr,
        LineTypeCrLf,
        LineTypeLfcrlf;

    }

    class ReadFile {
        private Charset charset = null;
        private RpcPerforceFile file = null;
        private int pos;
        private int len;
        private byte[] buf;
        private long size;
        private long offset;
        private RpcInputStream in;

        ReadFile() {
        }

        public void Open(RpcPerforceFile f, Charset charset) throws IOException, FileEncoderException {
            this.file = f;
            this.charset = charset;
            this.in = new RpcInputStream(f, charset);
            this.buf = new byte[P4TUNE_FILESYS_BUFSIZE];
        }

        public void Close() throws IOException {
            this.in.close();
        }

        private void deleteFile() throws IOException {
            this.file.delete();
        }

        public char Char() {
            return (char)this.buf[this.pos];
        }

        public char Get() throws IOException {
            return this.Eof() ? (char)'\u0000' : (char)this.buf[this.pos++];
        }

        public void Prev() throws IOException, FileEncoderException {
            if (--this.pos < 0) {
                this.Seek(this.Tell());
            }
        }

        public void Next() {
            ++this.pos;
        }

        public long Size() {
            return this.size;
        }

        public long Tell() {
            return this.offset - (long)this.len + (long)this.pos;
        }

        public boolean Eof() throws IOException {
            return this.InMem() == 0;
        }

        public void Seek(long o) throws IOException, FileEncoderException {
            long windowStart = this.offset - (long)this.len;
            if (o > this.offset) {
                if (this.Read() != 0) {
                    this.Seek(o);
                }
            } else if (o < windowStart) {
                this.in.close();
                this.in = new RpcInputStream(this.file, this.charset);
                this.offset = 0L;
                if (this.Read() != 0) {
                    this.Seek(o);
                }
            } else {
                this.pos = (int)(o - windowStart);
            }
        }

        public long Memcmp(ReadFile other, long length) throws IOException {
            long l2;
            long l1;
            while (length != 0L && (l1 = (long)this.InMem()) != 0L && (l2 = (long)other.InMem()) != 0L) {
                if (l1 > length) {
                    l1 = length;
                }
                if (l1 > l2) {
                    l1 = l2;
                }
                int x = 0;
                int i = 0;
                while (x == 0 && (long)i < l1) {
                    x = this.buf[this.pos++] - other.buf[other.pos++];
                    ++i;
                }
                if (x != 0) {
                    return x;
                }
                length -= l1;
            }
            return 0L;
        }

        public int Memcpy(byte[] buf, int length) throws IOException {
            int l;
            int olen = length;
            int bpos = 0;
            while (length != 0 && (l = this.InMem()) != 0) {
                if (l > length) {
                    l = length;
                }
                for (int i = 0; i < l; ++i) {
                    buf[bpos++] = this.buf[this.pos++];
                }
                length -= l;
            }
            return olen - length;
        }

        public int Memccpy(byte[] buf, char c, int length) throws IOException {
            int l;
            int olen = length;
            int bpos = 0;
            boolean hit = false;
            while (!hit && length != 0 && (l = this.InMem()) != 0) {
                if (l > length) {
                    l = length;
                }
                for (int i = 0; !hit && i < l; ++i) {
                    hit = this.buf[this.pos] == c;
                    buf[bpos++] = this.buf[this.pos++];
                }
                length -= l;
            }
            return olen - length;
        }

        public int Memchr(char c, int length) throws IOException {
            int l;
            if (length == -1) {
                length = (int)(this.Size() - this.Tell());
            }
            int olen = length;
            boolean hit = false;
            while (!hit && length != 0 && (l = this.InMem()) != 0) {
                if (l > length) {
                    l = length;
                }
                for (int i = 0; !hit && i < l; ++i) {
                    hit = this.buf[this.pos++] == c;
                }
                length -= l;
            }
            return olen - length;
        }

        public int Textcpy(byte[] dst, int dstlen, long srclen, LineType type) throws IOException {
            switch (type) {
                default: {
                    return this.Memcpy(dst, (int)((long)dstlen < srclen ? (long)dstlen : srclen));
                }
                case LineTypeCr: {
                    if ((long)dstlen > srclen) {
                        dstlen = (int)srclen;
                    }
                    int l = 0;
                    while (dstlen != 0 && (l = this.Memccpy(dst, '\r', dstlen)) != 0) {
                        dstlen -= l;
                        if (dst[l - 1] != 13) continue;
                        dst[l - 1] = 10;
                    }
                    return l;
                }
                case LineTypeCrLf: 
                case LineTypeLfcrlf: 
            }
            int l = 0;
            while (dstlen != 0 && srclen > 0L && (l = this.Memccpy(dst, '\r', (int)((long)dstlen < srclen ? (long)dstlen : srclen))) != 0) {
                dstlen -= l;
                srclen -= (long)l;
                if (dst[l - 1] != 13 || this.Eof() || this.Char() != '\n') continue;
                this.Next();
                dst[l - 1] = 10;
                --srclen;
            }
            return l;
        }

        private int Read() throws IOException {
            int l = this.in.read(this.buf);
            if (l <= 0) {
                this.size = this.offset;
                return 0;
            }
            this.pos = 0;
            this.offset += (long)l;
            this.len = l;
            if (this.offset > this.size) {
                this.size = this.offset;
            }
            return l;
        }

        private int InMem() throws IOException {
            return this.len - this.pos > 0 ? this.len - this.pos : this.Read();
        }
    }
}

