/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.mapapi;

import com.perforce.p4java.mapapi.Joiner;
import com.perforce.p4java.mapapi.MapChar;
import com.perforce.p4java.mapapi.MapParam;
import com.perforce.p4java.mapapi.MapParams;
import java.util.concurrent.atomic.AtomicInteger;

public class MapHalf {
    static final int PARAM_VECTOR_LENGTH = 30;
    static final int PARAM_MAX_BACKTRACK = 10;
    static final int PARAM_MAX_WILDS = 10;
    private MapChar[] mapChar = null;
    private int mapTail;
    private int mapEnd;
    private int fixedLen;
    private boolean isWild;
    private int nWilds;
    private int caseMode = -1;
    private String half = "";
    static final int[][] CmpGrid = new int[][]{{0, -1, -1, 0, 0, 0}, {1, -2, -2, 1, 1, 1}, {1, -2, 2, 1, 1, 1}, {0, -1, -1, 0, 0, 0}, {0, -1, -1, 0, 0, 0}, {0, -1, -1, 0, 0, 0}};
    static final Action[][][] Grid = new Action[][][]{{{Action.aOK, Action.aMISS, Action.aMISS, Action.aRWILD, Action.aRWILD, Action.aRWILD}, {Action.aMISS, Action.aMATCH, Action.aMISS, Action.aRWILD, Action.aRWILD, Action.aRWILD}, {Action.aMISS, Action.aMISS, Action.aMATCH, Action.aRWILD, Action.aRWILD, Action.aRWILD}, {Action.aLWILD, Action.aLWILD, Action.aLWILD, Action.aSTAR, Action.aSTAR, Action.aSTAR}, {Action.aLWILD, Action.aLWILD, Action.aLWILD, Action.aSTAR, Action.aSTAR, Action.aSTAR}, {Action.aLWILD, Action.aLWILD, Action.aLWILD, Action.aSTAR, Action.aSTAR, Action.aSTAR}}, {{Action.aOK, Action.aMISS, Action.aMISS, Action.aMISS, Action.aMISS, Action.aMISS}, {Action.aMISS, Action.aMATCH, Action.aMISS, Action.aRBACK, Action.aRBACK, Action.aRBACK}, {Action.aMISS, Action.aMISS, Action.aMATCH, Action.aMISS, Action.aMISS, Action.aRBACK}, {Action.aMISS, Action.aLBACK, Action.aMISS, Action.aLSTAR, Action.aLSTAR, Action.aLSTAR}, {Action.aMISS, Action.aLBACK, Action.aMISS, Action.aLSTAR, Action.aLSTAR, Action.aLSTAR}, {Action.aMISS, Action.aLBACK, Action.aLBACK, Action.aLSTAR, Action.aLSTAR, Action.aLSTAR}}, {{Action.aOK, Action.aMISS, Action.aMISS, Action.aMISS, Action.aMISS, Action.aMISS}, {Action.aMISS, Action.aMATCH, Action.aMISS, Action.aRBACK, Action.aRBACK, Action.aRBACK}, {Action.aMISS, Action.aMISS, Action.aMATCH, Action.aMISS, Action.aMISS, Action.aRBACK}, {Action.aMISS, Action.aLBACK, Action.aMISS, Action.aRSTAR, Action.aRSTAR, Action.aRSTAR}, {Action.aMISS, Action.aLBACK, Action.aMISS, Action.aRSTAR, Action.aRSTAR, Action.aRSTAR}, {Action.aMISS, Action.aLBACK, Action.aLBACK, Action.aRSTAR, Action.aRSTAR, Action.aRSTAR}}};

    public MapHalf() {
    }

    public MapHalf(String newHalf) {
        this.set(newHalf);
    }

    public String get() {
        return this.toString();
    }

    public String toString() {
        return this.half;
    }

    void set(String newHalf) {
        if (newHalf == null) {
            newHalf = "";
        }
        int l = newHalf.length() + 1;
        this.half = newHalf;
        this.mapChar = new MapChar[l];
        for (int i = 0; i < this.mapChar.length; ++i) {
            this.mapChar[i] = new MapChar();
        }
        AtomicInteger nStars = new AtomicInteger(0);
        AtomicInteger nDots = new AtomicInteger(0);
        AtomicInteger pos = new AtomicInteger(0);
        int mc = 0;
        while (this.mapChar[mc].set(newHalf.toCharArray(), pos, nStars, nDots, this.caseMode)) {
            ++mc;
        }
        this.mapEnd = mc;
        while (mc > 0 && (this.mapChar[mc - 1].cc == MapChar.MapCharClass.cCHAR || this.mapChar[mc - 1].cc == MapChar.MapCharClass.cSLASH)) {
            --mc;
        }
        this.mapTail = mc;
        mc = 0;
        while (this.mapChar[mc].cc == MapChar.MapCharClass.cCHAR || this.mapChar[mc].cc == MapChar.MapCharClass.cSLASH) {
            ++mc;
        }
        this.isWild = this.mapChar[mc].cc != MapChar.MapCharClass.cEOS;
        this.fixedLen = mc;
        this.nWilds = 0;
        mc = 0;
        while (this.mapChar[mc].cc != MapChar.MapCharClass.cEOS) {
            if (this.mapChar[mc].isWild()) {
                ++this.nWilds;
            }
            ++mc;
        }
    }

    boolean tooWild(Error e) {
        return this.nWilds > 10;
    }

    boolean hasSubDirs(int match) {
        int mc = match;
        while (this.mapChar[mc].cc != MapChar.MapCharClass.cEOS && this.mapChar[mc].cc != MapChar.MapCharClass.cSLASH && this.mapChar[mc].cc != MapChar.MapCharClass.cDOTS) {
            ++mc;
        }
        return this.mapChar[mc].cc != MapChar.MapCharClass.cEOS;
    }

    boolean hasEndSlashEllipses() {
        int mc = this.mapEnd - 1;
        if (!this.isWild) {
            return false;
        }
        if (mc == 0 || this.mapChar[mc - 1].cc != MapChar.MapCharClass.cSLASH && this.mapChar[mc - 1].c != '\\') {
            return false;
        }
        return this.mapChar[mc].cc == MapChar.MapCharClass.cDOTS;
    }

    int compare(MapHalf item) {
        int l;
        int mc1 = 0;
        int mc2 = 0;
        int n = l = this.fixedLen < item.fixedLen ? this.fixedLen : item.fixedLen;
        while (l-- != 0 && this.mapChar[mc1].c - item.mapChar[mc2].c == 0) {
            ++mc1;
            ++mc2;
        }
        while (true) {
            switch (CmpGrid[this.mapChar[mc1].cc.code][item.mapChar[mc2].cc.code]) {
                case -1: {
                    return -1;
                }
                case 1: {
                    return 1;
                }
                case 0: {
                    return 0;
                }
                case -2: {
                    int d = this.mapChar[mc1].c - item.mapChar[mc2].c;
                    if (d == 0) break;
                    return d;
                }
            }
            ++mc1;
            ++mc2;
        }
    }

    private void findParams(char[] params) throws Exception {
        int mc = 0;
        int mn = 0;
        int wilds = 0;
        while (this.mapChar[mc].cc != MapChar.MapCharClass.cEOS) {
            switch (this.mapChar[mc].cc) {
                case cDOTS: {
                    if (this.mapChar[mc].paramNumber >= 23) {
                        throw new Exception("MsgDb::ExtraDots " + this.half);
                    }
                    params[this.mapChar[mc].paramNumber] = '\u0001';
                    ++wilds;
                    break;
                }
                case cSTAR: {
                    if (this.mapChar[mc].paramNumber >= 20) {
                        throw new Exception("MsgDb::ExtraStars " + this.half);
                    }
                }
                case cPERC: {
                    if (params[this.mapChar[mc].paramNumber] != '\u0000') {
                        throw new Exception("MsgDb::Duplicate " + this.half);
                    }
                    params[this.mapChar[mc].paramNumber] = '\u0001';
                    ++wilds;
                    break;
                }
                default: {
                    mn = mc;
                }
            }
            if (this.mapChar[mn].c < this.mapChar[mc].c - '\u0001') {
                throw new Exception("MsgDb::Juxtaposed " + this.half);
            }
            ++mc;
        }
        if (wilds > 10) {
            throw new Exception("MsgDb::TooWild2 " + this.half);
        }
    }

    boolean validate(MapHalf item) throws Exception {
        int i;
        char[][] params = new char[2][30];
        for (i = 0; i < 30; ++i) {
            params[1][i] = '\u0000';
            params[0][i] = '\u0000';
        }
        this.findParams(params[0]);
        if (item == null) {
            return true;
        }
        item.findParams(params[1]);
        for (i = 0; i < 30; ++i) {
            if (params[0][i] == params[1][i]) continue;
            throw new Exception("MsgDb::WildMismatch " + this.half + " " + item.get());
        }
        return true;
    }

    void setCaseMode(int caseMode) {
        this.caseMode = caseMode;
        if (this.mapChar != null) {
            int mc = 0;
            while (this.mapChar[mc].cc != MapChar.MapCharClass.cEOS) {
                this.mapChar[mc].caseMode = caseMode;
                ++mc;
            }
        }
    }

    int getCommonLen(MapHalf prev) {
        int matchLen = 0;
        int mc1 = 0;
        int mc2 = 0;
        while (matchLen < this.fixedLen && this.mapChar[mc1].c - prev.mapChar[mc2].c == 0) {
            ++matchLen;
            ++mc1;
            ++mc2;
        }
        return matchLen;
    }

    int match1(String from, int coff) {
        int r = 0;
        while (coff < this.fixedLen && coff < from.length()) {
            r = this.mapChar[coff].c - from.charAt(coff);
            if (r != 0) {
                return -r;
            }
            ++coff;
        }
        if (from.length() < this.fixedLen) {
            return -1;
        }
        return 0;
    }

    boolean match2(String from, MapParams params) {
        int mc;
        int input;
        if (from.length() < this.fixedLen) {
            return false;
        }
        if (this.isWild) {
            input = from.length() - 1;
            mc = 0;
            while (mc > this.mapTail && input > 0) {
                if (this.mapChar[--mc].c - from.charAt(--input) == 0) continue;
                return false;
            }
        }
        mc = this.fixedLen;
        input = this.fixedLen;
        if (this.caseMode == 2) {
            input -= this.fixedLen;
            mc -= this.fixedLen;
        }
        int backup = 0;
        match2Backup[] backups = new match2Backup[20];
        for (int i = 0; i < backups.length; ++i) {
            backups[i] = new match2Backup();
        }
        block7: while (true) {
            switch (this.mapChar[mc].cc) {
                case cDOTS: 
                case cSTAR: 
                case cPERC: {
                    backups[backup].param = params.vector[this.mapChar[mc].paramNumber];
                    backups[backup].param.start = input;
                    if (this.mapChar[mc].cc == MapChar.MapCharClass.cDOTS) {
                        while (input < from.length() && from.charAt(input) != '\u0000') {
                            ++input;
                        }
                    } else {
                        while (input < from.length() && from.charAt(input) != '\u0000' && from.charAt(input) != '/') {
                            ++input;
                        }
                    }
                    backups[backup].param.end = input;
                    backups[backup].mc = ++mc;
                    ++backup;
                    break;
                }
                case cSLASH: 
                case cCHAR: {
                    do {
                        if (input != from.length() && this.mapChar[mc++].c == from.charAt(input++)) continue;
                        if (input == from.length()) {
                            ++input;
                            ++mc;
                        }
                        while (true) {
                            if (backup <= 0) {
                                return false;
                            }
                            mc = backups[backup - 1].mc;
                            if ((input = --backups[backup - 1].param.end) >= backups[backup - 1].param.start) continue block7;
                            --backup;
                        }
                    } while (this.mapChar[mc].cc == MapChar.MapCharClass.cCHAR || this.mapChar[mc].cc == MapChar.MapCharClass.cSLASH);
                    break;
                }
                case cEOS: {
                    if (input < from.length() && from.charAt(input) != '\u0000') {
                        while (true) {
                            if (backup <= 0) {
                                return false;
                            }
                            mc = backups[backup - 1].mc;
                            if ((input = --backups[backup - 1].param.end) >= backups[backup - 1].param.start) continue block7;
                            --backup;
                        }
                    }
                    return true;
                }
            }
        }
    }

    public boolean match(MapHalf from) {
        int mc = 0;
        int mc2 = 0;
        int backup = 0;
        matchBackup[] backups = new matchBackup[20];
        for (int i = 0; i < 20; ++i) {
            backups[i] = new matchBackup();
        }
        block7: while (true) {
            switch (this.mapChar[mc].cc) {
                case cDOTS: {
                    backups[backup].mc2start = mc2;
                    while (from.mapChar[mc2].cc != MapChar.MapCharClass.cEOS) {
                        ++mc2;
                    }
                    backups[backup].mc2end = mc2;
                    backups[backup].mc = ++mc;
                    ++backup;
                    break;
                }
                case cSTAR: 
                case cPERC: {
                    backups[backup].mc2start = mc2;
                    while (from.mapChar[mc2].cc != MapChar.MapCharClass.cEOS && from.mapChar[mc2].cc != MapChar.MapCharClass.cSLASH && from.mapChar[mc2].cc != MapChar.MapCharClass.cDOTS) {
                        ++mc2;
                    }
                    backups[backup].mc2end = mc2;
                    backups[backup].mc = ++mc;
                    ++backup;
                    break;
                }
                case cSLASH: 
                case cCHAR: {
                    do {
                        if (this.mapChar[mc].cc == from.mapChar[mc2].cc && this.mapChar[mc++].c == from.mapChar[mc2++].c) continue;
                        while (true) {
                            if (backup <= 0) {
                                return false;
                            }
                            mc = backups[backup - 1].mc;
                            if ((mc2 = --backups[backup - 1].mc2end) >= backups[backup - 1].mc2start) continue block7;
                            --backup;
                        }
                    } while (this.mapChar[mc].cc == MapChar.MapCharClass.cCHAR || this.mapChar[mc].cc == MapChar.MapCharClass.cSLASH);
                    break;
                }
                case cEOS: {
                    if (from.mapChar[mc2].cc != MapChar.MapCharClass.cEOS) {
                        while (true) {
                            if (backup <= 0) {
                                return false;
                            }
                            mc = backups[backup - 1].mc;
                            if ((mc2 = --backups[backup - 1].mc2end) >= backups[backup - 1].mc2start) continue block7;
                            --backup;
                        }
                    }
                    return true;
                }
            }
        }
    }

    int matchHead(MapHalf other) {
        for (int coff = 0; coff < this.fixedLen && coff < other.fixedLen; ++coff) {
            int r = this.mapChar[coff].c - other.mapChar[coff].c;
            if (r == 0) continue;
            return -r;
        }
        return 0;
    }

    boolean matchTail(MapHalf other) {
        int mc1 = 0;
        int mc2 = 0;
        while (mc1 > this.mapTail && mc2 > other.mapTail) {
            if (this.mapChar[--mc1].c - other.mapChar[--mc2].c != 0) continue;
            return true;
        }
        return false;
    }

    String expand(String from, MapParams params) {
        int mc = 0;
        Object output = "";
        while (this.mapChar[mc].cc != MapChar.MapCharClass.cEOS) {
            if (this.mapChar[mc].isWild()) {
                int slot = this.mapChar[mc].paramNumber;
                int in = params.vector[slot].start;
                int end = params.vector[slot].end;
                output = (String)output + from.substring(in, end);
            } else {
                output = (String)output + this.mapChar[mc].c;
            }
            ++mc;
        }
        return output;
    }

    void join(MapHalf map2, Joiner joiner) {
        Retry[] retries = new Retry[32];
        for (int i = 0; i < retries.length; ++i) {
            retries[i] = new Retry();
        }
        int retry = 0;
        joiner.clear();
        Backup backup = Backup.BACKUP_NONE;
        AtomicInteger wilds = new AtomicInteger(0);
        int maxWildChars = 10;
        int nonWild = map2.fixedLen;
        if (this.fixedLen < nonWild) {
            nonWild = this.fixedLen;
        }
        int mc1 = nonWild;
        int mc2 = nonWild;
        while (mc1 > 0) {
            if (this.mapChar[--mc1].c == map2.mapChar[--mc2].c) continue;
            return;
        }
        mc1 = nonWild;
        mc2 = nonWild;
        while (true) {
            Action a;
            if ((a = Grid[backup.code][this.mapChar[mc1].cc.code][map2.mapChar[mc2].cc.code]) == Action.aMATCH && this.mapChar[mc1].c != map2.mapChar[mc2].c) {
                a = Action.aMISS;
            }
            backup = Backup.BACKUP_NONE;
            switch (a) {
                case aMATCH: {
                    ++mc1;
                    ++mc2;
                    break;
                }
                case aLWILD: {
                    retries[retry].wilds = wilds.get();
                    retries[retry].backup = Backup.BACKUP_LHS;
                    retries[retry].param = joiner.params.vector[this.mapChar[mc1].paramNumber];
                    retries[retry].param.start = joiner.length();
                    retries[retry].param.end = joiner.length();
                    retries[retry].mc1 = mc1++;
                    retries[retry].mc2 = mc2;
                    ++retry;
                    break;
                }
                case aRWILD: {
                    retries[retry].wilds = wilds.get();
                    retries[retry].backup = Backup.BACKUP_RHS;
                    retries[retry].param = joiner.params2.vector[map2.mapChar[mc2].paramNumber];
                    retries[retry].param.start = joiner.length();
                    retries[retry].param.end = joiner.length();
                    retries[retry].mc1 = mc1;
                    retries[retry].mc2 = mc2++;
                    ++retry;
                    break;
                }
                case aLBACK: {
                    joiner.extend(map2.mapChar[mc2++].c);
                    retries[retry].param.end = joiner.length();
                    retries[retry].mc2 = mc2;
                    if (Grid[retries[retry].backup.code][this.mapChar[mc1].cc.code][map2.mapChar[mc2].cc.code] == Action.aLSTAR) {
                        backup = retries[retry].backup;
                        break;
                    }
                    retries[retry].mc1 = mc1++;
                    ++retry;
                    break;
                }
                case aRBACK: {
                    joiner.extend(this.mapChar[mc1++].c);
                    retries[retry].param.end = joiner.length();
                    retries[retry].mc1 = mc1;
                    if (Grid[retries[retry].backup.code][this.mapChar[mc1].cc.code][map2.mapChar[mc2].cc.code] == Action.aRSTAR) {
                        backup = retries[retry].backup;
                        break;
                    }
                    retries[retry].mc2 = mc2++;
                    ++retry;
                    break;
                }
                case aSTAR: {
                    retries[retry].param = joiner.params.vector[this.mapChar[mc1].paramNumber];
                    retries[retry].param.start = joiner.length();
                    retries[retry].backup = Backup.BACKUP_LHS;
                }
                case aLSTAR: {
                    retries[retry + 1].param = joiner.params2.vector[map2.mapChar[mc2].paramNumber];
                    retries[retry + 1].param.start = joiner.length();
                    joiner.data = this.mapChar[mc1].makeParam(joiner.data, map2.mapChar[mc2], wilds);
                    retries[retry].param.end = joiner.length();
                    retries[retry + 1].param.end = joiner.length();
                    retries[retry].mc1 = mc1++;
                    retries[retry + 1].mc1 = mc1;
                    retries[retry + 1].mc2 = mc2++;
                    retries[retry].mc2 = mc2;
                    retries[retry + 1].backup = Backup.BACKUP_RHS;
                    retries[retry].wilds = wilds.get();
                    retries[retry + 1].wilds = wilds.get();
                    retry += 2;
                    break;
                }
                case aRSTAR: {
                    retries[retry + 1].param = joiner.params.vector[this.mapChar[mc1].paramNumber];
                    retries[retry + 1].param.start = joiner.length();
                    joiner.data = this.mapChar[mc1].makeParam(joiner.data, map2.mapChar[mc2], wilds);
                    retries[retry].param.end = joiner.length();
                    retries[retry + 1].param.end = joiner.length();
                    retries[retry + 1].mc1 = mc1++;
                    retries[retry].mc1 = mc1;
                    retries[retry].mc2 = mc2++;
                    retries[retry + 1].mc2 = mc2;
                    retries[retry + 1].backup = Backup.BACKUP_LHS;
                    retries[retry].wilds = wilds.get();
                    retries[retry + 1].wilds = wilds.get();
                    retry += 2;
                    break;
                }
                case aOK: {
                    if (wilds.get() > maxWildChars) {
                        joiner.badJoin = true;
                        return;
                    }
                    joiner.insert();
                }
                case aMISS: {
                    if (--retry < 0) {
                        return;
                    }
                    mc1 = retries[retry].mc1;
                    mc2 = retries[retry].mc2;
                    backup = retries[retry].backup;
                    joiner.setLength(retries[retry].param.end);
                    wilds.set(retries[retry].wilds);
                    if (retry <= 0) break;
                    retries[retry].param.end = retries[retry - 1].param.end;
                }
            }
        }
    }

    int hasPosWild(String h) {
        int pos = h.indexOf("%%");
        if (pos != -1 && h.charAt(pos + 2) >= '0' && h.charAt(pos + 2) <= '9') {
            return 1;
        }
        return 0;
    }

    int hasEmbWild(String h, boolean ignore) {
        int prevwild = -1;
        int pos = 0;
        while (h.charAt(pos) != '\u0000') {
            if (h.charAt(pos) == '.' && h.charAt(pos + 1) == '.' && h.charAt(pos + 2) == '.') {
                ++prevwild;
                pos += 2;
            } else if (h.charAt(pos) == '%' && h.charAt(pos + 1) == '%' && h.charAt(pos + 2) >= '0' && h.charAt(pos + 2) <= '9') {
                ++prevwild;
                pos += 2;
            } else if (h.charAt(pos) == '*') {
                ++prevwild;
            } else {
                if (h.charAt(pos) == '\u0000' || h.indexOf(47, pos) == -1 && h.indexOf(42, pos) == -1 && h.indexOf("...", pos) == -1) break;
                if (prevwild != -1 && !ignore || ignore && prevwild > 1) {
                    return 1;
                }
            }
            ++pos;
        }
        return 0;
    }

    int getFixedLen() {
        return this.fixedLen;
    }

    boolean isWild() {
        return this.isWild;
    }

    int wildcardCount() {
        return this.nWilds;
    }

    boolean match(String i, MapParams p) {
        MapParam o = new MapParam();
        return this.match1(i, 0) == 0 && this.match2(i, p);
    }

    static enum Action {
        aMATCH(0, "MATCH"),
        aLWILD(1, "LHS-WILD"),
        aLBACK(2, "LHS-NEXT"),
        aRWILD(3, "RHS-WILD"),
        aRBACK(4, "RHS-NEXT"),
        aSTAR(5, "BOTH-STAR"),
        aLSTAR(6, "LHS-STAR"),
        aRSTAR(7, "RHS-STAR"),
        aMISS(8, "MISS"),
        aOK(9, "OK");

        int code;
        String name;

        private Action(int i, String name) {
            this.code = i;
            this.name = name;
        }
    }

    private class Retry {
        int mc1;
        int mc2;
        MapParam param;
        Backup backup;
        int wilds;

        private Retry() {
        }
    }

    static enum Backup {
        BACKUP_NONE(0),
        BACKUP_LHS(1),
        BACKUP_RHS(2);

        int code;

        private Backup(int i) {
            this.code = i;
        }
    }

    private class matchBackup {
        int mc;
        int mc2start;
        int mc2end;

        private matchBackup() {
        }
    }

    private class match2Backup {
        int mc;
        MapParam param;

        private match2Backup() {
        }
    }
}

