/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.server.cmd;

import com.perforce.p4java.common.base.P4ResultMapUtils;
import com.perforce.p4java.core.IUser;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.impl.mapbased.server.Parameters;
import com.perforce.p4java.impl.mapbased.server.cmd.BaseDelegator;
import com.perforce.p4java.impl.mapbased.server.cmd.ResultMapParser;
import com.perforce.p4java.option.Options;
import com.perforce.p4java.option.server.Login2Options;
import com.perforce.p4java.server.CmdSpec;
import com.perforce.p4java.server.IOptionsServer;
import com.perforce.p4java.server.IServer;
import com.perforce.p4java.server.delegator.ILogin2Delegator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class Login2Delegator
extends BaseDelegator
implements ILogin2Delegator {
    public Login2Delegator(IOptionsServer server) {
        super(server);
    }

    @Override
    public List<Map<String, Object>> login2(Login2Options opts, String user) throws P4JavaException {
        String[] params = user == null || user.isEmpty() ? Parameters.processParameters(opts, this.server) : Parameters.processParameters((Options)opts, null, user, (IServer)this.server);
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.LOGIN2, params, null);
        return resultMaps;
    }

    @Override
    public String getLogin2Status() throws P4JavaException {
        Login2Options opts = new Login2Options();
        opts.setStatus(true);
        List<Map<String, Object>> resultMaps = this.login2(opts, null);
        String statusStr = "";
        if (Objects.nonNull(resultMaps) && !resultMaps.isEmpty()) {
            Map<String, Object> firstResultMap = resultMaps.get(0);
            statusStr = ResultMapParser.getErrorOrInfoStr(firstResultMap);
        }
        return StringUtils.isBlank((CharSequence)statusStr) ? "" : statusStr;
    }

    @Override
    public String getLogin2Status(IUser user) throws P4JavaException {
        Validate.notNull((Object)user);
        Validate.notBlank((CharSequence)user.getLoginName(), (String)"Login name shouldn't null or empty", (Object[])new Object[0]);
        Login2Options opts = new Login2Options();
        opts.setStatus(true);
        List<Map<String, Object>> resultMaps = this.login2(opts, user.getLoginName());
        String statusStr = "";
        if (Objects.nonNull(resultMaps) && !resultMaps.isEmpty()) {
            Map<String, Object> firstResultMap = resultMaps.get(0);
            statusStr = ResultMapParser.getErrorOrInfoStr(firstResultMap);
        }
        return StringUtils.isBlank((CharSequence)statusStr) ? "" : statusStr;
    }

    @Override
    public Map<String, String> login2ListMethods() throws P4JavaException {
        Login2Options opts = new Login2Options();
        opts.setState("list-methods");
        List<Map<String, Object>> resultMaps = this.login2(opts, null);
        HashMap<String, String> methods = new HashMap<String, String>();
        for (Map<String, Object> map : resultMaps) {
            ResultMapParser.handleErrorStr(map);
            if (!map.containsKey("id") || !map.containsKey("desc")) continue;
            String id = P4ResultMapUtils.parseString(map, "id");
            String desc = P4ResultMapUtils.parseString(map, "desc");
            methods.put(id, desc);
        }
        return methods;
    }

    @Override
    public String login2InitAuth(String method) throws P4JavaException {
        Login2Options opts = new Login2Options();
        opts.setState("init-auth");
        opts.setMethod(method);
        List<Map<String, Object>> resultMaps = this.login2(opts, null);
        String message = ResultMapParser.parseCommandResultMapIfIsInfoMessageAsString(resultMaps);
        return message;
    }

    @Override
    public String login2CheckAuth(String auth, boolean persist) throws P4JavaException {
        Login2Options opts = new Login2Options();
        opts.setState("check-auth");
        opts.setPersist(persist);
        Object authCheck = auth;
        if (StringUtils.isNotBlank((CharSequence)auth)) {
            authCheck = auth + "\n";
        }
        HashMap<String, Object> pwdMap = new HashMap<String, Object>();
        pwdMap.put("password", authCheck);
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.LOGIN2, Parameters.processParameters(opts, this.server), pwdMap);
        String message = ResultMapParser.parseCommandResultMapIfIsInfoMessageAsString(resultMaps);
        return message;
    }

    @Override
    public String login2(IUser user, Login2Options opts) throws P4JavaException {
        Validate.notNull((Object)user);
        Validate.notBlank((CharSequence)user.getLoginName(), (String)"Login name shouldn't null or empty", (Object[])new Object[0]);
        List<Map<String, Object>> resultMaps = this.login2(opts, user.getLoginName());
        String message = ResultMapParser.parseCommandResultMapIfIsInfoMessageAsString(resultMaps);
        return message;
    }
}

