/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.exception;

import com.perforce.p4java.Log;
import com.perforce.p4java.exception.P4JavaException;
import java.io.Serializable;

public class RequestException
extends P4JavaException {
    private static final long serialVersionUID = 1L;
    private int rawCode = 0;
    private int severityCode = 0;
    private int genericCode = 0;
    private int uniqueCode = 0;
    private int subCode = 0;
    private int subSystem = 0;

    public RequestException() {
    }

    public RequestException(String message, Throwable cause) {
        super(message, cause);
    }

    public RequestException(String message) {
        super(message);
    }

    public RequestException(Throwable cause) {
        super(cause);
    }

    public RequestException(String message, int rawCode) {
        super(message);
        this.setCodes(rawCode);
    }

    public RequestException(String message, String codeString) {
        super(message);
        if (codeString != null) {
            try {
                this.setCodes(new Integer(codeString));
            }
            catch (Exception exc) {
                Log.exception(exc);
            }
        }
    }

    public RequestException(String message, int genericCode, int severityCode) {
        super(message);
        this.genericCode = genericCode;
        this.severityCode = severityCode;
    }

    public RequestException(Throwable cause, int genericCode, int severityCode) {
        super(cause);
        this.genericCode = genericCode;
        this.severityCode = severityCode;
    }

    public RequestException(String message, Throwable cause, int genericCode, int severityCode) {
        super(message, cause);
        this.genericCode = genericCode;
        this.severityCode = severityCode;
    }

    public RequestException setCodes(int rawCode) {
        this.rawCode = rawCode;
        this.subCode = rawCode >> 0 & 0x3FF;
        this.subSystem = rawCode >> 10 & 0x3F;
        this.uniqueCode = rawCode & 0xFFFF;
        this.genericCode = rawCode >> 16 & 0xFF;
        this.severityCode = rawCode >> 28 & 0xF;
        return this;
    }

    public void setSeverityCode(int severityCode) {
        this.severityCode = severityCode;
    }

    public void setGenericCode(int genericCode) {
        this.genericCode = genericCode;
    }

    public String getDisplayString() {
        return (String)(this.genericCode != 0 ? "Generic: " + this.genericCode : "") + (String)(this.severityCode != 0 ? " Severity: " + this.severityCode + "; " : "") + this.getMessage() + (Serializable)(this.getCause() != null ? this.getCause() : "");
    }

    public int getUniqueCode() {
        return this.uniqueCode;
    }

    public void setUniqueCode(int uniqueCode) {
        this.uniqueCode = uniqueCode;
    }

    public int getRawCode() {
        return this.rawCode;
    }

    public int getSubCode() {
        return this.subCode;
    }

    public void setSubCode(int subCode) {
        this.subCode = subCode;
    }

    public int getSubSystem() {
        return this.subSystem;
    }

    public void setSubSystem(int subSystem) {
        this.subSystem = subSystem;
    }

    public int getSeverityCode() {
        return this.severityCode;
    }

    public int getGenericCode() {
        return this.genericCode;
    }
}

