/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.option.server;

import com.perforce.p4java.exception.ConnectionException;
import com.perforce.p4java.exception.OptionsException;
import com.perforce.p4java.option.Options;
import com.perforce.p4java.server.IServer;
import java.util.List;

public class GetFileContentsOptions
extends Options {
    public static final String OPTIONS_SPECS = "b:a b:q";
    public static final String OPTION_SPEC_NEW = "l:-offset l:-size";
    protected boolean allrevs = false;
    protected boolean noHeaderLine = false;
    protected boolean dontAnnotateFiles = false;
    protected long offset = 0L;
    protected long size = 0L;

    public GetFileContentsOptions() {
    }

    public GetFileContentsOptions(String ... options) {
        super(options);
    }

    public GetFileContentsOptions(boolean allrevs, boolean noHeaderLine) {
        this.allrevs = allrevs;
        this.noHeaderLine = noHeaderLine;
    }

    @Override
    public List<String> processOptions(IServer server) throws OptionsException {
        int serverVersion = 0;
        try {
            serverVersion = server.getServerVersion();
        }
        catch (ConnectionException e) {
            throw new OptionsException("Can not connect to server.", e);
        }
        this.optionList = serverVersion >= 20221 ? this.processFields("b:a b:q l:-offset l:-size", this.isAllrevs(), this.isNoHeaderLine(), this.offset, this.size) : this.processFields(OPTIONS_SPECS, this.isAllrevs(), this.isNoHeaderLine());
        return this.optionList;
    }

    public boolean isAllrevs() {
        return this.allrevs;
    }

    public GetFileContentsOptions setAllrevs(boolean allrevs) {
        this.allrevs = allrevs;
        return this;
    }

    public boolean isNoHeaderLine() {
        return this.noHeaderLine;
    }

    public GetFileContentsOptions setNoHeaderLine(boolean noHeaderLine) {
        this.noHeaderLine = noHeaderLine;
        return this;
    }

    public boolean isDontAnnotateFiles() {
        return this.dontAnnotateFiles;
    }

    public GetFileContentsOptions setDontAnnotateFiles(boolean dontAnnotateFiles) {
        this.dontAnnotateFiles = dontAnnotateFiles;
        return this;
    }

    public long getOffset() {
        return this.offset;
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }
}

