/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.rpc;

import com.perforce.p4java.Log;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.impl.mapbased.rpc.RpcCmdSpec;
import com.perforce.p4java.impl.mapbased.rpc.RpcServer;
import com.perforce.p4java.impl.mapbased.rpc.connection.RpcConnection;
import com.perforce.p4java.impl.mapbased.rpc.func.proto.ProtocolCommand;
import com.perforce.p4java.impl.mapbased.rpc.packet.helper.RpcPacketFieldRule;
import com.perforce.p4java.server.callback.IFilterCallback;
import com.perforce.p4java.server.callback.IParallelCallback;
import com.perforce.p4java.server.callback.IProgressCallback;
import com.perforce.p4java.server.callback.IStreamingCallback;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CommandEnv {
    public static final int MAX_HANDLERS = 10;
    public static final String LINE_SEPARATOR = System.getProperty("line.separator", "\n");
    private RpcServer server = null;
    private RpcCmdSpec cmdSpec = null;
    private List<Map<String, Object>> resultMaps = null;
    private Map<String, Object> lastResultMap = null;
    private Map<String, Object> stateMap = null;
    private RpcHandler[] handlers = new RpcHandler[10];
    private ProtocolCommand protocolSpecs = null;
    private Map<String, Object> serverProtocolSpecsMap = null;
    private IProgressCallback progressCallback = null;
    private int cmdCallBackKey = 0;
    private boolean syncInPlace = false;
    private boolean nonCheckedSyncs = false;
    private boolean dontWriteTicket = false;
    private boolean streamCmd = false;
    private RpcPacketFieldRule fieldRule = null;
    private IStreamingCallback streamingCallback = null;
    private int streamingCallbackKey = 0;
    private IFilterCallback filterCallback = null;
    private IParallelCallback parallelCallback = null;
    private long syncTime = 0L;
    private boolean nullSync = false;
    private boolean bufferOutput = false;
    private RpcConnection rpcConnection = null;
    private boolean userCanceled = false;

    public CommandEnv(RpcServer server, RpcCmdSpec cmdSpec, RpcConnection rpcConnection, ProtocolCommand protocolSpecs, Map<String, Object> serverProtocolSpecsMap, IProgressCallback progressCallback, int cmdCallBackKey, boolean syncInPlace, boolean nonCheckedSyncs) {
        this.server = server;
        this.cmdSpec = cmdSpec;
        this.rpcConnection = rpcConnection;
        this.protocolSpecs = protocolSpecs;
        this.stateMap = new HashMap<String, Object>();
        this.serverProtocolSpecsMap = serverProtocolSpecsMap;
        this.progressCallback = progressCallback;
        this.cmdCallBackKey = cmdCallBackKey;
        this.syncInPlace = syncInPlace;
        this.nonCheckedSyncs = nonCheckedSyncs;
    }

    public boolean addHandler(RpcHandler handler) {
        for (int i = 0; i < this.handlers.length; ++i) {
            if (this.handlers[i] == null || this.handlers[i].name == null || this.handlers[i].name.equalsIgnoreCase(handler.name)) {
                // empty if block
            }
            if (this.handlers[i] != null) continue;
            this.handlers[i] = handler;
            return true;
        }
        return false;
    }

    public void handleResult(Map<String, Object> resultMap) {
        if (this.lastResultMap != null) {
            this.lastResultMap.putAll(resultMap);
        } else {
            this.lastResultMap = resultMap;
        }
        if (this.streamingCallback != null) {
            if (!this.userCanceled) {
                try {
                    this.userCanceled = !this.streamingCallback.handleResult(this.lastResultMap, this.streamingCallbackKey);
                }
                catch (P4JavaException exc) {
                    Log.error("caught exception from streaming callback handler (key: " + this.streamingCallbackKey + "): " + exc.getLocalizedMessage(), new Object[0]);
                    Log.exception(exc);
                }
            }
        } else {
            this.resultMaps.add(this.lastResultMap);
        }
        this.lastResultMap = null;
    }

    public void handlePartialResult(Map<String, Object> resultMap) {
        if (this.lastResultMap == null) {
            this.lastResultMap = new HashMap<String, Object>();
        }
        if (this.streamingCallback != null) {
            this.lastResultMap.putAll(resultMap);
        } else {
            this.lastResultMap.putAll(resultMap);
        }
    }

    public void resetPartialResult() {
        this.lastResultMap = null;
    }

    public RpcHandler getHandler(String handlerName) {
        for (RpcHandler handler : this.handlers) {
            if (handler == null || handlerName == null || handler.getName() == null || !handler.getName().equalsIgnoreCase(handlerName)) continue;
            return handler;
        }
        return null;
    }

    public RpcCmdSpec getCmdSpec() {
        return this.cmdSpec;
    }

    public void setCmdSpec(RpcCmdSpec cmdSpec) {
        this.cmdSpec = cmdSpec;
    }

    public List<Map<String, Object>> getResultMaps() {
        return this.resultMaps;
    }

    public void setResultMaps(List<Map<String, Object>> resultMaps) {
        this.resultMaps = resultMaps;
    }

    public void clearLastResultMap() {
        this.lastResultMap = null;
    }

    public Map<String, Object> getStateMap() {
        return this.stateMap;
    }

    public void setStateMap(Map<String, Object> stateMap) {
        this.stateMap = stateMap;
    }

    public ProtocolCommand getProtocolSpecs() {
        return this.protocolSpecs;
    }

    public int getServerProtocolLevel() {
        if (this.serverProtocolSpecsMap == null) {
            return -1;
        }
        if (this.serverProtocolSpecsMap.containsKey("server2")) {
            return Integer.parseInt((String)this.serverProtocolSpecsMap.get("server2"));
        }
        if (this.serverProtocolSpecsMap.containsKey("server")) {
            return Integer.parseInt((String)this.serverProtocolSpecsMap.get("server"));
        }
        return -1;
    }

    public void setProtocolSpecs(ProtocolCommand protocolSpecs) {
        this.protocolSpecs = protocolSpecs;
    }

    public RpcConnection getRpcConnection() {
        return this.rpcConnection;
    }

    public void setRpcConnection(RpcConnection rpcConnection) {
        this.rpcConnection = rpcConnection;
    }

    public RpcHandler[] getHandlers() {
        return this.handlers;
    }

    public void setHandlers(RpcHandler[] handlers) {
        this.handlers = handlers;
    }

    public void newHandler() {
    }

    public Map<String, Object> getServerProtocolSpecsMap() {
        return this.serverProtocolSpecsMap;
    }

    public void setServerProtocolSpecsMap(Map<String, Object> serverProtocolSpecsMap) {
        this.serverProtocolSpecsMap = serverProtocolSpecsMap;
    }

    public IProgressCallback getProgressCallback() {
        return this.progressCallback;
    }

    public void setProgressCallback(IProgressCallback progressCallback) {
        this.progressCallback = progressCallback;
    }

    public int getCmdCallBackKey() {
        return this.cmdCallBackKey;
    }

    public void setCmdCallBackKey(int cmdCallBackKey) {
        this.cmdCallBackKey = cmdCallBackKey;
    }

    public boolean isUserCanceled() {
        return this.userCanceled;
    }

    public void setUserCanceled(boolean userCanceled) {
        this.userCanceled = userCanceled;
    }

    public boolean isSyncInPlace() {
        return this.syncInPlace;
    }

    public void setSyncInPlace(boolean syncInPlace) {
        this.syncInPlace = syncInPlace;
    }

    public IStreamingCallback getStreamingCallback() {
        return this.streamingCallback;
    }

    public void setStreamingCallback(IStreamingCallback streamingCallback) {
        this.streamingCallback = streamingCallback;
    }

    public int getStreamingCallbackKey() {
        return this.streamingCallbackKey;
    }

    public void setStreamingCallbackKey(int streamingCallbackKey) {
        this.streamingCallbackKey = streamingCallbackKey;
    }

    public boolean isNonCheckedSyncs() {
        return this.nonCheckedSyncs;
    }

    public void setNonCheckedSyncs(boolean nonCheckedSyncs) {
        this.nonCheckedSyncs = nonCheckedSyncs;
    }

    public boolean isDontWriteTicket() {
        return this.dontWriteTicket;
    }

    public void setDontWriteTicket(boolean dontWriteTicket) {
        this.dontWriteTicket = dontWriteTicket;
    }

    public boolean isStreamCmd() {
        return this.streamCmd;
    }

    public void setStreamCmd(boolean streamCmd) {
        this.streamCmd = streamCmd;
    }

    public RpcPacketFieldRule getFieldRule() {
        return this.fieldRule;
    }

    public void setFieldRule(RpcPacketFieldRule fieldRule) {
        this.fieldRule = fieldRule;
    }

    public IFilterCallback getFilterCallback() {
        return this.filterCallback;
    }

    public void setFilterCallback(IFilterCallback filterCallback) {
        this.filterCallback = filterCallback;
    }

    public IParallelCallback getParallelCallback() {
        return this.parallelCallback;
    }

    public void setParallelCallback(IParallelCallback parallelCallback) {
        this.parallelCallback = parallelCallback;
    }

    public RpcServer getServer() {
        return this.server;
    }

    public long getSyncTime() {
        return this.syncTime;
    }

    public void setSyncTime(long syncTime) {
        this.syncTime = syncTime;
    }

    public boolean isNullSync() {
        return this.nullSync;
    }

    public void setNullSync(boolean nullSync) {
        this.nullSync = nullSync;
    }

    public boolean isBufferOutput() {
        return this.bufferOutput;
    }

    public void setBufferOutput(boolean bufferOutput) {
        this.bufferOutput = bufferOutput;
    }

    public class RpcHandler {
        private String name = null;
        private String type = null;
        private boolean error = false;
        private File file = null;
        private Map<String, Object> map = null;

        public RpcHandler(String name, boolean error, File file) {
            this.name = name;
            this.error = error;
            this.file = file;
            this.map = new HashMap<String, Object>();
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public boolean isError() {
            return this.error;
        }

        public void setError(boolean error) {
            this.error = error;
        }

        public File getFile() {
            return this.file;
        }

        public void setFile(File file) {
            this.file = file;
        }

        public Map<String, Object> getMap() {
            return this.map;
        }

        public void setMap(Map<String, Object> map) {
            this.map = map;
        }
    }
}

