/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.server.cmd;

import com.perforce.p4java.Log;
import com.perforce.p4java.common.base.P4ResultMapUtils;
import com.perforce.p4java.core.file.FileSpecOpStatus;
import com.perforce.p4java.core.file.IFileSpec;
import com.perforce.p4java.exception.AccessException;
import com.perforce.p4java.exception.ConnectionException;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.impl.generic.core.file.FileSpec;
import com.perforce.p4java.impl.mapbased.server.Parameters;
import com.perforce.p4java.impl.mapbased.server.cmd.BaseDelegator;
import com.perforce.p4java.impl.mapbased.server.cmd.ResultMapParser;
import com.perforce.p4java.option.server.GetDirectoriesOptions;
import com.perforce.p4java.server.CmdSpec;
import com.perforce.p4java.server.IOptionsServer;
import com.perforce.p4java.server.delegator.IDirsDelegator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class DirsDelegator
extends BaseDelegator
implements IDirsDelegator {
    public DirsDelegator(IOptionsServer server) {
        super(server);
    }

    @Override
    public List<IFileSpec> getDirectories(@Nonnull List<IFileSpec> fileSpecs, boolean clientOnly, boolean deletedOnly, boolean haveListOnly) throws ConnectionException, AccessException {
        Validate.notNull(fileSpecs);
        try {
            GetDirectoriesOptions directoriesOptions = new GetDirectoriesOptions().setClientOnly(clientOnly).setDeletedOnly(deletedOnly).setHaveListOnly(haveListOnly);
            return this.getDirectories(fileSpecs, directoriesOptions);
        }
        catch (AccessException | ConnectionException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            Log.warn("Unexpected exception in IServer.getDirectories: %s", exc);
            return Collections.emptyList();
        }
    }

    @Override
    public List<IFileSpec> getDirectories(List<IFileSpec> fileSpecs, GetDirectoriesOptions opts) throws P4JavaException {
        HashMap<String, Object> inMap = new HashMap<String, Object>();
        inMap.put("useTags", "no");
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.DIRS, Parameters.processParameters(opts, fileSpecs, this.server), inMap);
        ArrayList<IFileSpec> specList = new ArrayList<IFileSpec>();
        if (Objects.nonNull(resultMaps)) {
            for (Map<String, Object> map : resultMaps) {
                if (!Objects.nonNull(map)) continue;
                String code0String = P4ResultMapUtils.parseCode0ErrorString(map);
                String errStr = ResultMapParser.handleFileErrorStr(map);
                if (StringUtils.isBlank((CharSequence)errStr) || ResultMapParser.isInfoMessage(map)) {
                    String dirName = P4ResultMapUtils.parseString(map, "dirName");
                    String dir = P4ResultMapUtils.parseString(map, "dir");
                    if (StringUtils.isNotBlank((CharSequence)dirName)) {
                        specList.add(new FileSpec(dirName));
                        continue;
                    }
                    if (StringUtils.isNotBlank((CharSequence)dir)) {
                        specList.add(new FileSpec(dir));
                        continue;
                    }
                    if (!ResultMapParser.isInfoMessage(map)) continue;
                    specList.add(new FileSpec(FileSpecOpStatus.INFO, errStr, code0String));
                    continue;
                }
                specList.add(new FileSpec(FileSpecOpStatus.ERROR, errStr, code0String));
            }
        }
        return specList;
    }
}

