/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.server.cmd;

import com.perforce.p4java.admin.ServerConfigurationValue;
import com.perforce.p4java.common.base.P4ResultMapUtils;
import com.perforce.p4java.common.base.StringHelper;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.impl.mapbased.server.cmd.BaseDelegator;
import com.perforce.p4java.impl.mapbased.server.cmd.ResultListBuilder;
import com.perforce.p4java.impl.mapbased.server.cmd.ResultMapParser;
import com.perforce.p4java.server.CmdSpec;
import com.perforce.p4java.server.IOptionsServer;
import com.perforce.p4java.server.delegator.IConfigureDelegator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class ConfigureDelegator
extends BaseDelegator
implements IConfigureDelegator {
    private static final int STRING_BUILDER_SIZE = 100;
    private static final String SHOW_CMD = "show";

    public ConfigureDelegator(IOptionsServer server) {
        super(server);
    }

    @Override
    public String setOrUnsetServerConfigurationValue(@Nonnull String name, @Nullable String value) throws P4JavaException {
        Validate.notBlank((CharSequence)name, (String)"Config name shouldn't null or empty", (Object[])new Object[0]);
        String[] args = new String[]{"unset", name};
        if (StringUtils.isNotBlank((CharSequence)value)) {
            args = new String[]{"set", name + "=" + value};
        }
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.CONFIGURE, args, null);
        StringBuilder messageBuilder = new StringBuilder(100);
        if (Objects.nonNull(resultMaps)) {
            for (Map<String, Object> map : resultMaps) {
                if (!Objects.nonNull(map)) continue;
                String str = ResultMapParser.getErrorOrInfoStr(map);
                if (StringUtils.isBlank((CharSequence)str)) {
                    if (!map.containsKey("Name") || !map.containsKey("Action") || !Objects.nonNull(map.get("Action"))) continue;
                    String message = str;
                    String serverName = P4ResultMapUtils.parseString(map, "ServerName");
                    String configureName = P4ResultMapUtils.parseString(map, "Name");
                    String configureValue = P4ResultMapUtils.parseString(map, "Value");
                    String action = P4ResultMapUtils.parseString(map, "Action");
                    if ("set".equalsIgnoreCase(action)) {
                        message = StringHelper.format("For server '%s', configuration variable '%s' set to '%s'", serverName, configureName, configureValue);
                    } else if ("unset".equalsIgnoreCase(action)) {
                        message = StringHelper.format("For server '%s', configuration variable '%s' removed.", serverName, configureName);
                    }
                    if (!StringUtils.isNotBlank((CharSequence)message)) continue;
                    messageBuilder.append(message).append("\n");
                    continue;
                }
                return str;
            }
        }
        return messageBuilder.toString();
    }

    @Override
    public List<ServerConfigurationValue> showServerConfiguration(String serverName, String variableName) throws P4JavaException {
        String[] args = new String[]{SHOW_CMD};
        if (StringUtils.isNotBlank((CharSequence)serverName)) {
            args = new String[]{SHOW_CMD, serverName};
        } else if (StringUtils.isNotBlank((CharSequence)variableName)) {
            args = new String[]{SHOW_CMD, variableName};
        }
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.CONFIGURE, args, null);
        return ResultListBuilder.buildNonNullObjectListFromCommandResultMaps(resultMaps, map -> new ServerConfigurationValue((Map<String, Object>)map));
    }
}

