/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.rpc.sys.helper;

import com.perforce.p4java.impl.mapbased.rpc.sys.helper.SymbolicLinkHelper;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;

public class WindowsRpcSystemFileCommandsHelper
extends SymbolicLinkHelper {
    private static final List<String> DEFAULT_WINDOWS_EXE_EXT = new ArrayList<String>();

    @Override
    public boolean canExecute(String fileName) {
        for (String ext : DEFAULT_WINDOWS_EXE_EXT) {
            if (!ext.toUpperCase().equals("." + FilenameUtils.getExtension((String)fileName).toUpperCase())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean setWritable(String fileName, boolean writable) {
        if (SymbolicLinkHelper.isSymbolicLink(fileName)) {
            return true;
        }
        return new File(fileName).setWritable(writable);
    }

    @Override
    public boolean setReadable(String fileName, boolean readable, boolean ownerOnly) {
        try {
            Path path = Paths.get(fileName, new String[0]);
            Files.setAttribute(path, "dos:readonly", readable, new LinkOption[0]);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    @Override
    public boolean setOwnerReadOnly(String fileName) {
        boolean set = this.setReadable(fileName, false, false);
        return set &= this.setReadable(fileName, true, true);
    }

    @Override
    public boolean setExecutable(String fileName, boolean executable, boolean ownerOnly) {
        return new File(fileName).setExecutable(executable, ownerOnly);
    }

    @Override
    public boolean isSymlink(String fileName) {
        return WindowsRpcSystemFileCommandsHelper.isSymbolicLink(fileName);
    }

    static {
        String exeExtensions = System.getenv("PATHEXT");
        if (StringUtils.isEmpty((CharSequence)exeExtensions)) {
            DEFAULT_WINDOWS_EXE_EXT.addAll(Arrays.asList(".COM", ".EXE", ".BAT", ".CMD", ".VBS", ".VBE", ".JS", ".JSE", ".WSF", ".WSH", ".MSC"));
        } else {
            DEFAULT_WINDOWS_EXE_EXT.addAll(Arrays.asList(exeExtensions.toUpperCase().split(";")));
        }
    }
}

