/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.server.cmd;

import com.perforce.p4java.Log;
import com.perforce.p4java.admin.ILogTail;
import com.perforce.p4java.common.base.P4JavaExceptions;
import com.perforce.p4java.common.base.P4ResultMapUtils;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.impl.generic.admin.LogTail;
import com.perforce.p4java.impl.mapbased.server.Parameters;
import com.perforce.p4java.impl.mapbased.server.cmd.BaseDelegator;
import com.perforce.p4java.impl.mapbased.server.cmd.ResultMapParser;
import com.perforce.p4java.option.server.LogTailOptions;
import com.perforce.p4java.server.CmdSpec;
import com.perforce.p4java.server.IOptionsServer;
import com.perforce.p4java.server.delegator.ILogTailDelegator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class LogTailDelegator
extends BaseDelegator
implements ILogTailDelegator {
    public LogTailDelegator(IOptionsServer server) {
        super(server);
    }

    @Override
    public ILogTail getLogTail(LogTailOptions opts) throws P4JavaException {
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.LOGTAIL, Parameters.processParameters(opts, this.server), null);
        String logFile = null;
        long offset = -1L;
        ArrayList<String> data = new ArrayList<String>();
        if (Objects.nonNull(resultMaps)) {
            for (Map<String, Object> map : resultMaps) {
                if (!Objects.nonNull(map)) continue;
                String errStr = ResultMapParser.getErrorStr(map);
                P4JavaExceptions.throwRequestExceptionIfConditionFails(StringUtils.isBlank((CharSequence)errStr), P4ResultMapUtils.parseCode0ErrorString(map), errStr, new Object[0]);
                try {
                    if (map.containsKey("file")) {
                        logFile = P4ResultMapUtils.parseString(map, "file");
                    }
                    if (map.containsKey("data")) {
                        data.add(P4ResultMapUtils.parseString(map, "data"));
                    }
                    if (!map.containsKey("offset")) continue;
                    offset = P4ResultMapUtils.parseLong(map, "offset");
                }
                catch (Throwable thr) {
                    Log.exception(thr);
                }
            }
        }
        if (StringUtils.isNotBlank(logFile) && !data.isEmpty() && offset > -1L) {
            return new LogTail(logFile, offset, data);
        }
        return null;
    }
}

