/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.common.base;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class P4ResultMapUtils {
    private P4ResultMapUtils() {
    }

    @Nullable
    public static String parseString(@Nonnull Map<String, Object> map, String key) {
        Object value = map.get(key);
        if (Objects.isNull(value)) {
            return null;
        }
        return String.valueOf(value);
    }

    @Nullable
    public static String parseCode0ErrorString(@Nonnull Map<String, Object> map) {
        return P4ResultMapUtils.parseString(map, "code0");
    }

    public static int parseInt(@Nonnull Map<String, Object> map, String key) {
        return Integer.parseInt(String.valueOf(map.get(key)));
    }

    public static long parseLong(@Nonnull Map<String, Object> map, String key) {
        return Long.parseLong(String.valueOf(map.get(key)));
    }

    public static boolean hasValidDepotPath(@Nonnull Map<String, Object> map) {
        return map.containsKey("depotFile");
    }

    public static boolean containsDescriptionField(@Nonnull Map<String, Object> map) {
        return map.containsKey("desc");
    }

    public static boolean isContainsValidRevisionSpecificInformation(@Nonnull Map<String, Object> map) {
        return P4ResultMapUtils.hasValidDepotPath(map) && !P4ResultMapUtils.containsDescriptionField(map);
    }

    public static List<String> parseDataList(@Nonnull Map<String, Object> map, String key) {
        ArrayList<String> dataList = new ArrayList<String>();
        int i = 0;
        while (Objects.nonNull(map.get(key + i))) {
            dataList.add(String.valueOf(map.get(key + i)));
            ++i;
        }
        return dataList;
    }
}

