/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.generic.core;

import com.perforce.p4java.Log;
import com.perforce.p4java.common.base.P4ResultMapUtils;
import com.perforce.p4java.core.IFileLineMatch;
import com.perforce.p4java.impl.generic.core.file.FileSpec;
import java.util.Map;
import java.util.Objects;

public class FileLineMatch
implements IFileLineMatch {
    protected String file = null;
    protected int revision = -1;
    protected int lineNumber = -1;
    protected String line = null;
    protected IFileLineMatch.MatchType type = IFileLineMatch.MatchType.MATCH;

    public FileLineMatch(String file, int revision, String line, IFileLineMatch.MatchType type) {
        this.file = file;
        this.revision = revision;
        this.line = line;
        this.type = type;
    }

    public FileLineMatch(Map<String, Object> map) {
        if (Objects.nonNull(map)) {
            this.file = P4ResultMapUtils.parseString(map, "depotFile");
            this.revision = FileSpec.getRevFromString(P4ResultMapUtils.parseString(map, "rev"));
            if (Objects.nonNull(map.get("line"))) {
                try {
                    this.lineNumber = P4ResultMapUtils.parseInt(map, "line");
                }
                catch (NumberFormatException exc) {
                    Log.warn("NumberFormatException in FileLineMatch map-based constructor: %s", exc.getLocalizedMessage());
                }
            }
            this.line = P4ResultMapUtils.parseString(map, "matchedLine");
            this.type = IFileLineMatch.MatchType.fromServerString(P4ResultMapUtils.parseString(map, "type"));
        }
    }

    @Override
    public String getDepotFile() {
        return this.file;
    }

    @Override
    public String getLine() {
        return this.line;
    }

    @Override
    public int getRevision() {
        return this.revision;
    }

    @Override
    public int getLineNumber() {
        return this.lineNumber;
    }

    @Override
    public IFileLineMatch.MatchType getType() {
        return this.type;
    }
}

