/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.rpc.func.client;

import com.perforce.p4java.Log;
import com.perforce.p4java.exception.ConnectionException;
import com.perforce.p4java.exception.NullPointerError;
import com.perforce.p4java.impl.mapbased.rpc.CommandEnv;
import com.perforce.p4java.impl.mapbased.rpc.RpcPropertyDefs;
import com.perforce.p4java.impl.mapbased.rpc.RpcServer;
import com.perforce.p4java.impl.mapbased.rpc.connection.RpcConnection;
import com.perforce.p4java.impl.mapbased.rpc.func.client.ClientIgnoreChecker;
import com.perforce.p4java.impl.mapbased.rpc.func.client.ClientMessage;
import com.perforce.p4java.impl.mapbased.rpc.func.helper.MD5Digester;
import com.perforce.p4java.impl.mapbased.rpc.handles.ClientFile;
import com.perforce.p4java.impl.mapbased.rpc.handles.ReconcileHandle;
import com.perforce.p4java.impl.mapbased.rpc.msg.RpcMessage;
import com.perforce.p4java.impl.mapbased.rpc.packet.RpcPacketDispatcher;
import com.perforce.p4java.impl.mapbased.rpc.sys.RpcPerforceDigestType;
import com.perforce.p4java.impl.mapbased.rpc.sys.RpcPerforceFile;
import com.perforce.p4java.impl.mapbased.rpc.sys.RpcPerforceFileType;
import com.perforce.p4java.impl.mapbased.rpc.sys.helper.FilePathHelper;
import com.perforce.p4java.impl.mapbased.rpc.sys.helper.SymbolicLinkHelper;
import com.perforce.p4java.mapapi.MapFlag;
import com.perforce.p4java.mapapi.MapTable;
import com.perforce.p4java.mapapi.MapTableT;
import com.perforce.p4java.mapapi.MapWrap;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;

public class ClientSystemFileMatchCommands {
    public static final String TRACE_PREFIX = "ClientSystemFileCommands";
    public static final String DEFAULT_TMPFILE_PFX = "p4j";
    public static final String DEFAULT_TMPFILE_SFX = ".p4j";
    public static final String SYSTEM_TMPDIR_PROPS_KEY = "java.io.tmpdir";
    public static final String SYSTEM_TMPDIR_DEFAULT = "/tmp";
    public static final String PERMS_RW = "rw";
    protected static final String RECONCILE_HANDLE = "skipAdd";
    private Properties props = null;
    private RpcServer server = null;
    private ClientIgnoreChecker checker = null;
    private String tmpDirName = null;

    protected ClientSystemFileMatchCommands(Properties props, RpcServer server) {
        this.props = props;
        this.server = server;
        this.tmpDirName = RpcPropertyDefs.getProperty(this.props, "com.perforce.p4java.tmpDir", System.getProperty(SYSTEM_TMPDIR_PROPS_KEY));
        if (this.tmpDirName == null) {
            this.tmpDirName = SYSTEM_TMPDIR_DEFAULT;
            Log.warn("Unable to get tmp name from P4 props or System; using " + this.tmpDirName + " instead", new Object[0]);
        }
    }

    void openMatch(RpcConnection rpcConnection, CommandEnv cmdEnv, Map<String, Object> resultsMap, ClientFile cfile) throws ConnectionException {
        String fromFile = (String)resultsMap.get("fromFile");
        String key = (String)resultsMap.get("key");
        String flags = (String)resultsMap.get("diffFlags");
        if (fromFile == null || key == null) {
            throw new NullPointerException("Missing fromFile or key");
        }
        cfile.getMatchDict().put("fromFile", fromFile);
        cfile.getMatchDict().put("key", key);
        if (flags != null) {
            cfile.getMatchDict().put("diffFlags", flags);
        }
        int i = 0;
        while (true) {
            String index = (String)resultsMap.get("index" + i);
            String file = (String)resultsMap.get("toFile" + i);
            if (index == null || file == null) break;
            cfile.getMatchDict().put("index" + i, index);
            cfile.getMatchDict().put("toFile" + i, file);
            ++i;
        }
    }

    void closeMatch(RpcConnection rpcConnection, CommandEnv cmdEnv, Map<String, Object> resultsMap, ClientFile cfile) throws ConnectionException {
        if (rpcConnection == null) {
            throw new NullPointerError("Null rpcConnection in convertFile().");
        }
        if (cmdEnv == null) {
            throw new NullPointerError("Null cmdEnv in convertFile().");
        }
        if (resultsMap == null) {
            throw new NullPointerError("Null resultsMap in convertFile().");
        }
    }

    protected RpcPacketDispatcher.RpcPacketDispatcherResult ackMatch(RpcConnection rpcConnection, CommandEnv cmdEnv, Map<String, Object> resultsMap) throws ConnectionException {
        if (rpcConnection == null) {
            throw new NullPointerError("Null rpcConnection in convertFile().");
        }
        if (cmdEnv == null) {
            throw new NullPointerError("Null cmdEnv in convertFile().");
        }
        if (resultsMap == null) {
            throw new NullPointerError("Null resultsMap in convertFile().");
        }
        String confirm = (String)resultsMap.get("confirm");
        String clientHandle = (String)resultsMap.get("handle");
        CommandEnv.RpcHandler handler = cmdEnv.getHandler(clientHandle);
        ClientFile cfile = new ClientFile(handler);
        String fromFile = cfile.getMatchDict().get("fromFile");
        String key = cfile.getMatchDict().get("key");
        String toFile = cfile.getMatchDict().get("toFile");
        String index = cfile.getMatchDict().get("index");
        String lower = cfile.getMatchDict().get("lower");
        String upper = cfile.getMatchDict().get("upper");
        if (fromFile == null || key == null) {
            throw new RuntimeException("Required parameter 'fromFile/key' not set!");
        }
        resultsMap.put("fromFile", fromFile);
        resultsMap.put("key", key);
        if (toFile != null && index != null && lower != null && upper != null) {
            resultsMap.put("toFile", toFile);
            resultsMap.put("index", index);
            resultsMap.put("lower", lower);
            resultsMap.put("upper", upper);
        }
        rpcConnection.clientConfirm(confirm, resultsMap);
        return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
    }

    protected RpcPacketDispatcher.RpcPacketDispatcherResult exactMatch(RpcConnection rpcConnection, CommandEnv cmdEnv, Map<String, Object> resultsMap) throws ConnectionException {
        if (rpcConnection == null) {
            throw new NullPointerError("Null rpcConnection in exactMatch().");
        }
        if (cmdEnv == null) {
            throw new NullPointerError("Null cmdEnv in exactMatch().");
        }
        if (resultsMap == null) {
            throw new NullPointerError("Null resultsMap in exactMatch().");
        }
        cmdEnv.newHandler();
        String clientType = (String)resultsMap.get("type");
        String digest = (String)resultsMap.get("digest");
        String confirm = (String)resultsMap.get("confirm");
        if (confirm == null) {
            throw new NullPointerError("No confirm value.");
        }
        String matchFile = null;
        String matchIndex = null;
        int i = 0;
        while (resultsMap.containsKey("toFile" + i)) {
            String localDigest;
            File f = new File((String)resultsMap.get("toFile" + i));
            RpcPerforceFileType fileType = RpcPerforceFileType.decodeFromServerString(clientType);
            if (!(f == null || digest == null || !f.exists() && !RpcPerforceFileType.isProbablySymLink(f) || !RpcPerforceFileType.isProbablySymLink(f) && fileType == RpcPerforceFileType.FST_SYMLINK || RpcPerforceFileType.isProbablySymLink(f) && fileType != RpcPerforceFileType.FST_SYMLINK || (localDigest = this.digestFile(f, fileType, rpcConnection.getClientCharset())) == null || localDigest.equals(digest))) {
                matchFile = (String)resultsMap.get("toFile" + i);
                matchIndex = (String)resultsMap.get("index" + i);
                break;
            }
            ++i;
        }
        if (matchFile != null && matchIndex != null) {
            resultsMap.put("toFile", matchFile);
            resultsMap.put("index", matchIndex);
        }
        rpcConnection.clientConfirm(confirm, resultsMap);
        return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
    }

    protected RpcPacketDispatcher.RpcPacketDispatcherResult reconcileEdit(RpcConnection rpcConnection, CommandEnv cmdEnv, Map<String, Object> resultsMap) throws ConnectionException {
        if (rpcConnection == null) {
            throw new NullPointerError("Null rpcConnection in reconcileEdit().");
        }
        if (cmdEnv == null) {
            throw new NullPointerError("Null cmdEnv in reconcileEdit().");
        }
        if (resultsMap == null) {
            throw new NullPointerError("Null resultsMap in reconcileEdit().");
        }
        String clientType = (String)resultsMap.get("type");
        String digest = (String)resultsMap.get("digest");
        String digestType = (String)resultsMap.get("digestType");
        String confirm = (String)resultsMap.get("confirm");
        String fileSize = (String)resultsMap.get("fileSize");
        String submitTime = (String)resultsMap.get("time");
        String clientPath = (String)resultsMap.get("path");
        ReconcileHandle recHandle = this.getReconcileHandle(cmdEnv);
        long checkSize = 0L;
        long time = 0L;
        try {
            checkSize = Long.parseLong(fileSize);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            time = Long.parseLong(submitTime);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        List<String> skipFilesMap = recHandle.getSkipFiles();
        String status = "exists";
        String nType = clientType == null ? "text" : clientType;
        RpcPerforceFileType fileType = RpcPerforceFileType.decodeFromServerString(clientType);
        boolean fstSymlink = fileType == RpcPerforceFileType.FST_SYMLINK;
        File file = new File(clientPath);
        if (!this.fileExists(file, true)) {
            status = "missing";
            recHandle.incrementDelCount();
        } else if (!RpcPerforceFileType.isProbablySymLink(file) && fstSymlink || RpcPerforceFileType.isProbablySymLink(file) && !fstSymlink) {
            skipFilesMap.add(file.getAbsolutePath());
        } else if (digest != null) {
            if (digestType != null) {
                String digestStr = rpcConnection.getDigest(fileType, file, RpcPerforceDigestType.GetType(digestType));
                if (digestStr != null && digestStr.equals(digest)) {
                    status = "same";
                }
            } else if (checkSize == 0L || file.length() == checkSize) {
                long fileModTime = file.lastModified() / 1000L;
                if (time == 0L || time != fileModTime) {
                    String digestStr = rpcConnection.getDigest(fileType, file);
                    if (digestStr != null && digestStr.equals(digest)) {
                        status = "same";
                    }
                } else if (time != 0L) {
                    status = "same";
                }
            }
        }
        resultsMap.put("type", nType);
        resultsMap.put("status", status);
        return rpcConnection.clientConfirm(confirm, resultsMap);
    }

    private ReconcileHandle getReconcileHandle(CommandEnv cmdEnv) {
        CommandEnv.RpcHandler handler = cmdEnv.getHandler(RECONCILE_HANDLE);
        if (handler == null) {
            CommandEnv commandEnv = cmdEnv;
            commandEnv.getClass();
            handler = new CommandEnv.RpcHandler(commandEnv, RECONCILE_HANDLE, false, null);
            cmdEnv.addHandler(handler);
        }
        return new ReconcileHandle(handler);
    }

    protected RpcPacketDispatcher.RpcPacketDispatcherResult reconcileAdd(RpcConnection rpcConnection, CommandEnv cmdEnv, Map<String, Object> resultsMap) throws ConnectionException {
        if (rpcConnection == null) {
            throw new NullPointerError("Null rpcConnection in reconcileAdd().");
        }
        if (cmdEnv == null) {
            throw new NullPointerError("Null cmdEnv in reconcileAdd().");
        }
        if (resultsMap == null) {
            throw new NullPointerError("Null resultsMap in reconcileAdd().");
        }
        String dir = (String)resultsMap.get("dir");
        String confirm = (String)resultsMap.get("confirm");
        String traverse = (String)resultsMap.get("traverse");
        String summary = (String)resultsMap.get("summary");
        String skipIgnore = (String)resultsMap.get("skipIgnore");
        String skipCurrent = (String)resultsMap.get("skipCurrent");
        String sendDigest = (String)resultsMap.get("sendDigest");
        if (dir == null) {
            throw new NullPointerError("Null 'dir' in resultsMap in reconcileAdd().");
        }
        if (confirm == null) {
            throw new NullPointerError("Null 'confirm' in resultsMap in reconcileAdd().");
        }
        boolean isTraverse = traverse != null && !traverse.equalsIgnoreCase("0");
        boolean isSummary = summary != null && !summary.equalsIgnoreCase("0");
        boolean isSkipIgnore = skipIgnore != null && !skipIgnore.equalsIgnoreCase("0");
        boolean isSkipCurrent = skipCurrent != null && !skipCurrent.equalsIgnoreCase("0");
        boolean isSendDigest = sendDigest != null && !sendDigest.equalsIgnoreCase("0");
        MapTable map = new MapTable();
        LinkedList<String> files = new LinkedList<String>();
        HashMap<String, Long> sizes = new HashMap<String, Long>();
        LinkedList<String> dirs = new LinkedList<String>();
        LinkedList<String> depotFiles = new LinkedList<String>();
        HashMap<String, String> digests = new HashMap<String, String>();
        int i = 0;
        while (resultsMap.get("mapTable" + i) != null) {
            String entry = (String)resultsMap.get("mapTable" + i);
            if ((entry = new File(entry).getAbsolutePath()) != null) {
                MapFlag flag = MapFlag.MfMap;
                if (entry.startsWith("-")) {
                    flag = MapFlag.MfUnmap;
                } else if (entry.startsWith("+")) {
                    flag = MapFlag.MfRemap;
                } else if (entry.startsWith("&")) {
                    flag = MapFlag.MfAndmap;
                }
                if (flag != MapFlag.MfMap) {
                    entry = entry.substring(1);
                }
                map.insert(entry, entry, flag);
            }
            ++i;
        }
        ReconcileHandle recHandle = null;
        CommandEnv.RpcHandler handler = cmdEnv.getHandler(RECONCILE_HANDLE);
        if (handler == null && handler == null && isSummary) {
            CommandEnv commandEnv = cmdEnv;
            commandEnv.getClass();
            handler = new CommandEnv.RpcHandler(commandEnv, RECONCILE_HANDLE, false, null);
            cmdEnv.addHandler(handler);
            recHandle = new ReconcileHandle(handler);
        }
        if (isSummary) {
            int j = 0;
            while (resultsMap.containsKey("depotFiles" + j)) {
                depotFiles.add((String)resultsMap.get("depotFiles" + j));
                ++j;
            }
            if (recHandle != null) {
                for (String fname : recHandle.getSkipFiles()) {
                    depotFiles.add(fname);
                }
            }
        }
        int hasIndex = 0;
        if (isSummary) {
            AtomicInteger idx = new AtomicInteger(0);
            AtomicInteger ddx = new AtomicInteger(0);
            this.traverseShort(resultsMap, new File(dir), new File(dir), isTraverse, isSkipIgnore, true, false, isSkipCurrent, map, files, dirs, idx, depotFiles, ddx, rpcConnection.isUnicodeServer(), rpcConnection.getClientCharset(), cmdEnv);
        } else {
            this.traverseDirs(new File(dir), isTraverse, isSkipIgnore, isSendDigest, map, files, sizes, digests, hasIndex, recHandle != null ? recHandle.getSkipFiles() : null, rpcConnection.isUnicodeServer(), rpcConnection.getClientCharset(), cmdEnv);
        }
        int j = 0;
        if (recHandle != null && !isSummary) {
            for (String file : files) {
                if (recHandle.getSkipFiles().contains(file)) continue;
                resultsMap.put("file" + j, file);
                if (!isSendDigest && recHandle.getDelCount() > 0L) {
                    resultsMap.put("fileSize" + j, "" + sizes.get(file));
                }
                if (isSendDigest) {
                    resultsMap.put("digest" + j, digests.get(file));
                }
                ++j;
            }
        } else {
            for (String file : files) {
                resultsMap.put("file" + j, file);
                if (isSendDigest) {
                    resultsMap.put("digest" + j, digests.get(file));
                }
                ++j;
            }
        }
        return rpcConnection.clientConfirm(confirm, resultsMap);
    }

    protected RpcPacketDispatcher.RpcPacketDispatcherResult reconcileFlush(RpcConnection rpcConnection, CommandEnv cmdEnv, Map<String, Object> resultsMap) throws ConnectionException {
        if (rpcConnection == null) {
            throw new NullPointerError("Null rpcConnection in reconcileFlush().");
        }
        if (cmdEnv == null) {
            throw new NullPointerError("Null cmdEnv in reconcileFlush().");
        }
        if (resultsMap == null) {
            throw new NullPointerError("Null resultsMap in reconcileFlush().");
        }
        CommandEnv.RpcHandler handler = cmdEnv.getHandler(RECONCILE_HANDLE);
        if (handler != null) {
            ReconcileHandle recHandle = new ReconcileHandle(handler);
            recHandle.getSkipFiles().clear();
        }
        return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
    }

    private void traverseDirs(File file, boolean traverse, boolean skipIgnore, boolean sendDigest, MapTable map, List<String> addFilesMap, Map<String, Long> sizes, Map<String, String> digests, int hasIndex, List<String> skipFiles, boolean unicode, Charset charset, CommandEnv cmdEnv) {
        if (addFilesMap == null) {
            throw new IllegalArgumentException("Must pass in a non-null 'files' list as a parameter.");
        }
        if (file == null || !file.exists()) {
            return;
        }
        if (file.isFile()) {
            if (skipIgnore || !this.isIgnore(file, charset, cmdEnv)) {
                String digestStr;
                addFilesMap.add(file.getAbsolutePath());
                sizes.put(file.getAbsolutePath(), file.length());
                if (sendDigest && (digestStr = this.digestFile(file, RpcPerforceFileType.FST_BINARY, charset)) != null) {
                    digests.put(file.getAbsolutePath(), digestStr);
                }
            }
            return;
        }
        if (file.isDirectory() && RpcPerforceFileType.isProbablySymLink(file)) {
            if (skipIgnore || !this.isIgnore(file, charset, cmdEnv)) {
                String digestStr;
                addFilesMap.add(file.getAbsolutePath());
                sizes.put(file.getAbsolutePath(), file.length());
                if (sendDigest && (digestStr = this.digestFile(file, RpcPerforceFileType.FST_BINARY, charset)) != null) {
                    digests.put(file.getAbsolutePath(), digestStr);
                }
            }
            return;
        }
        if (!file.isDirectory()) {
            return;
        }
        if (!skipIgnore && this.isIgnoreDir(file, charset, cmdEnv)) {
            return;
        }
        File[] files = file.listFiles();
        if (files == null) {
            return;
        }
        for (File f : files) {
            String digestStr;
            MapWrap mw;
            String matched;
            String from;
            String fileName = f.getAbsolutePath();
            int cmp = -1;
            while (skipFiles != null && hasIndex < skipFiles.size() && (cmp = fileName.compareTo(skipFiles.get(hasIndex))) >= 0) {
                ++hasIndex;
                if (cmp != 0) continue;
            }
            if (cmp == 0) continue;
            if (f.isDirectory()) {
                if (RpcPerforceFileType.isProbablySymLink(f)) {
                    from = fileName + "/";
                    matched = null;
                    mw = map.translate(MapTableT.LHS, from);
                    String string = matched = mw == null ? null : mw.getTo();
                    if (matched == null || !skipIgnore && this.isIgnore(f, charset, cmdEnv)) continue;
                    addFilesMap.add(fileName);
                    sizes.put(fileName, file.length());
                    if (!sendDigest || (digestStr = this.digestFile(f, RpcPerforceFileType.FST_BINARY, charset)) == null) continue;
                    digests.put(fileName, digestStr);
                    continue;
                }
                if (!traverse) continue;
                this.traverseDirs(f, traverse, skipIgnore, sendDigest, map, addFilesMap, sizes, digests, hasIndex, skipFiles, unicode, charset, cmdEnv);
                continue;
            }
            from = fileName;
            matched = null;
            mw = map.translate(MapTableT.LHS, from);
            String string = matched = mw == null ? null : mw.getTo();
            if (matched == null || !skipIgnore && this.isIgnore(f, charset, cmdEnv)) continue;
            addFilesMap.add(fileName);
            sizes.put(fileName, file.length());
            if (!sendDigest || (digestStr = this.digestFile(f, RpcPerforceFileType.FST_BINARY, charset)) == null) continue;
            digests.put(fileName, digestStr);
        }
    }

    private String digestFile(File file, RpcPerforceFileType fileType, Charset charset) {
        MD5Digester digester = new MD5Digester();
        RpcPerforceFile pFile = new RpcPerforceFile(file.getName(), fileType);
        return digester.digestFileAs32ByteHex(pFile, charset);
    }

    private boolean traverseShort(Map<String, Object> resultsMap, File cwd, File file, boolean traverse, boolean skipIgnore, boolean initial, boolean skipCheck, boolean skipCurrent, MapTable map, List<String> addFilesMap, List<String> dirs, AtomicInteger idx, List<String> depotFiles, AtomicInteger ddx, boolean unicode, Charset charset, CommandEnv cmdEnv) {
        File[] files;
        boolean found = false;
        if (addFilesMap == null) {
            throw new IllegalArgumentException("Must pass in a non-null 'files' list as a parameter.");
        }
        if (file == null || !file.exists()) {
            return false;
        }
        if (!file.isDirectory() && (file.isFile() || RpcPerforceFileType.isProbablySymLink(file))) {
            if (skipIgnore || !this.isIgnore(file, charset, cmdEnv)) {
                addFilesMap.add(file.getAbsolutePath());
                found = true;
            }
            return found;
        }
        if (file.isDirectory() && RpcPerforceFileType.isProbablySymLink(file)) {
            if (skipIgnore || !this.isIgnore(file, charset, cmdEnv)) {
                addFilesMap.add(file.getAbsolutePath());
                found = true;
            }
            return found;
        }
        if (!file.isDirectory()) {
            return false;
        }
        if (!skipIgnore && this.isIgnoreDir(file, charset, cmdEnv)) {
            return false;
        }
        boolean doSkipCheck = skipCheck;
        int dddx = 0;
        LinkedList<String> depotDirs = new LinkedList<String>();
        if (initial) {
            int j = 0;
            while (resultsMap.containsKey("depotDirs" + j)) {
                depotDirs.add((String)resultsMap.get("depotDirs" + j));
                ++j;
            }
        }
        if ((files = file.listFiles()) == null) {
            return found;
        }
        for (File f : files) {
            String alt;
            boolean isDir = false;
            boolean isSymDir = false;
            String fileName = f.getAbsolutePath();
            if (f.isDirectory() && !RpcPerforceFileType.isProbablySymLink(f)) {
                isDir = true;
            } else if (f.isDirectory() && RpcPerforceFileType.isProbablySymLink(f)) {
                isDir = true;
                isSymDir = true;
            } else if (!f.exists() && !RpcPerforceFileType.isProbablySymLink(f)) continue;
            boolean checkFile = false;
            if (isDir) {
                if (isSymDir) {
                    String from = fileName + "/";
                    String matched = null;
                    MapWrap mw = map.translate(MapTableT.LHS, from);
                    String string = matched = mw == null ? null : mw.getTo();
                    if (matched == null) continue;
                    if (skipIgnore || !this.isIgnore(f, charset, cmdEnv)) {
                        if (doSkipCheck) {
                            String alt2 = this.sendDir(f, cwd, dirs, idx, skipCurrent);
                            addFilesMap.add(alt2 != null ? alt2 : f.getAbsolutePath());
                            found = true;
                            break;
                        }
                        checkFile = true;
                    }
                } else if (traverse) {
                    if (initial) {
                        dirs.add(fileName);
                        boolean foundOne = false;
                        int l = 0;
                        while (dddx < depotDirs.size() && !foundOne) {
                            String depotDir = (String)depotDirs.get(dddx);
                            l = this.sysCompare(fileName, depotDir);
                            if (l == 0) {
                                foundOne = true;
                            } else if (l < 0) break;
                            ++dddx;
                        }
                        boolean bl = skipCheck = !foundOne;
                    }
                    if ((found = this.traverseShort(resultsMap, cwd, f, traverse, skipIgnore, false, skipCheck, skipCurrent, map, addFilesMap, dirs, idx, depotFiles, ddx, unicode, charset, cmdEnv)) && !initial) break;
                    if (found && initial && !skipCurrent) {
                        found = false;
                    }
                    if (found) {
                        break;
                    }
                }
            } else {
                String matched = null;
                MapWrap mw = map.translate(MapTableT.LHS, fileName);
                String string = matched = mw == null ? null : mw.getTo();
                if (matched == null) continue;
                if (skipIgnore || !this.isIgnore(f, charset, cmdEnv)) {
                    if (doSkipCheck) {
                        alt = this.sendDir(f, cwd, dirs, idx, skipCurrent);
                        addFilesMap.add(alt != null ? alt : f.getAbsolutePath());
                        found = true;
                        break;
                    }
                    checkFile = true;
                }
            }
            if (!checkFile) continue;
            int l = 0;
            boolean finished = false;
            while (!finished) {
                l = ddx.get() >= depotFiles.size() ? -1 : this.sysCompare(fileName, depotFiles.get(ddx.get()));
                if (l == 0) {
                    ddx.incrementAndGet();
                    finished = true;
                    continue;
                }
                if (l < 0) {
                    if (initial && skipCurrent) {
                        addFilesMap.add(FilePathHelper.getLocal(f.getParentFile().getAbsolutePath(), "..."));
                    } else {
                        alt = this.sendDir(f, cwd, dirs, idx, skipCurrent);
                        addFilesMap.add(alt != null ? alt : f.getAbsolutePath());
                    }
                    found = true;
                    break;
                }
                ddx.incrementAndGet();
            }
            if ((!initial || skipCurrent) && found) break;
        }
        return found;
    }

    private String sendDir(File file, File cwd, List<String> dirs, AtomicInteger idx, boolean skip) {
        if (skip) {
            return FilePathHelper.getLocal(cwd.getAbsolutePath(), "...");
        }
        if (this.sysCompare((file = file.getParentFile()).getAbsolutePath(), cwd.getAbsolutePath()) != 0) {
            return null;
        }
        boolean isDir = false;
        while (idx.get() < dirs.size() && !isDir) {
            if (file.getAbsolutePath().startsWith(new File(dirs.get(idx.get())).getAbsolutePath())) {
                return FilePathHelper.getLocal(dirs.get(idx.get()), "...");
            }
            idx.getAndIncrement();
        }
        return null;
    }

    private boolean fileExists(File file, boolean fstSymlink) {
        if (file != null) {
            if (file.exists()) {
                return true;
            }
            if (fstSymlink) {
                return SymbolicLinkHelper.exists(file.getPath());
            }
        }
        return false;
    }

    boolean isIgnore(File file, Charset charset, CommandEnv cmdEnv) {
        if (this.getChecker(charset) != null) {
            try {
                if (this.checker.match(file)) {
                    cmdEnv.handleResult(new RpcMessage(ClientMessage.ClientMessageId.CANT_ADD_FILE_TYPE, 1, 34, new String[]{file.getAbsolutePath(), "ignored"}).toMap());
                    return true;
                }
            }
            catch (FileNotFoundException e) {
                Log.error("Exception occurred during ignore files checking: " + e, new Object[0]);
            }
            catch (IOException e) {
                Log.error("Exception occurred during ignore files checking: " + e, new Object[0]);
            }
        }
        return false;
    }

    boolean isIgnoreDir(File file, Charset charset, CommandEnv cmdEnv) {
        if (this.getChecker(charset) != null) {
            try {
                if (this.checker.match(file)) {
                    cmdEnv.handleResult(new RpcMessage(ClientMessage.ClientMessageId.CANT_ADD_FILE_TYPE, 1, 34, new String[]{file.getAbsolutePath(), "ignored"}).toMap());
                    return true;
                }
            }
            catch (FileNotFoundException e) {
                Log.error("Exception occurred during ignore files checking: " + e, new Object[0]);
            }
            catch (IOException e) {
                Log.error("Exception occurred during ignore files checking: " + e, new Object[0]);
            }
        }
        return false;
    }

    int sysCompare(String a, String b) {
        String os = System.getProperty("os.name").toLowerCase();
        if (os.contains("windows") || os.contains("mac os")) {
            return a.compareToIgnoreCase(b);
        }
        return a.compareTo(b);
    }

    public static void getFiles(File dir, FilenameFilter filter, List<File> files) {
        if (files == null) {
            throw new IllegalArgumentException("Must pass in a non-null 'files' list as a parameter.");
        }
        if (dir != null) {
            if (dir.isDirectory()) {
                String[] children = dir.list(filter);
                if (children != null) {
                    for (int i = 0; i < children.length; ++i) {
                        ClientSystemFileMatchCommands.getFiles(new File(dir, children[i]), filter, files);
                    }
                }
            } else {
                files.add(dir);
            }
        }
    }

    private ClientIgnoreChecker getChecker(Charset charset) {
        if (this.checker == null && this.server != null && this.server.getCurrentClient() != null && this.server.getIgnoreFileName() != null) {
            this.checker = new ClientIgnoreChecker(this.server.getCurrentClient().getRoot(), this.server.getIgnoreFileName(), charset);
        }
        return this.checker;
    }
}

