/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.server.cmd;

import com.perforce.p4java.core.IRepo;
import com.perforce.p4java.exception.AccessException;
import com.perforce.p4java.exception.ConnectionException;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.exception.RequestException;
import com.perforce.p4java.impl.generic.core.Repo;
import com.perforce.p4java.impl.mapbased.server.Parameters;
import com.perforce.p4java.impl.mapbased.server.cmd.BaseDelegator;
import com.perforce.p4java.impl.mapbased.server.cmd.ResultMapParser;
import com.perforce.p4java.option.server.ReposOptions;
import com.perforce.p4java.server.CmdSpec;
import com.perforce.p4java.server.IOptionsServer;
import com.perforce.p4java.server.delegator.IReposDelegator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;

public class ReposDelegator
extends BaseDelegator
implements IReposDelegator {
    public ReposDelegator(IOptionsServer server) {
        super(server);
    }

    @Override
    public List<IRepo> getRepos() throws ConnectionException, RequestException, AccessException {
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.REPOS, new String[0], null);
        return this.processResults(resultMaps);
    }

    @Override
    public List<IRepo> getRepos(ReposOptions options) throws P4JavaException {
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.REPOS, Parameters.processParameters(options, this.server), null);
        return this.processResults(resultMaps);
    }

    @Override
    public List<IRepo> getRepos(@Nonnull String client) throws ConnectionException, RequestException, AccessException {
        if (!client.equals(this.server.getCurrentClient().getName())) {
            this.server.setCurrentClient(this.server.getClient(client));
        }
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.REPOS, new String[]{"-C"}, null);
        return this.processResults(resultMaps);
    }

    private List<IRepo> processResults(List<Map<String, Object>> resultMaps) throws AccessException, RequestException {
        ArrayList<IRepo> metadataArray = new ArrayList<IRepo>();
        if (Objects.nonNull(resultMaps)) {
            for (Map<String, Object> map : resultMaps) {
                if (ResultMapParser.handleErrorStr(map)) continue;
                metadataArray.add(new Repo(map));
            }
        }
        return metadataArray;
    }
}

