/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.server.cmd;

import com.perforce.p4java.common.base.P4ResultMapUtils;
import com.perforce.p4java.core.IChangelist;
import com.perforce.p4java.core.IChangelistSummary;
import com.perforce.p4java.core.file.IFileSpec;
import com.perforce.p4java.exception.AccessException;
import com.perforce.p4java.exception.ConnectionException;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.exception.RequestException;
import com.perforce.p4java.impl.generic.core.Changelist;
import com.perforce.p4java.impl.generic.core.ChangelistSummary;
import com.perforce.p4java.impl.generic.core.file.FileSpec;
import com.perforce.p4java.impl.mapbased.server.Parameters;
import com.perforce.p4java.impl.mapbased.server.cmd.BaseDelegator;
import com.perforce.p4java.option.Options;
import com.perforce.p4java.option.server.GetInterchangesOptions;
import com.perforce.p4java.server.CmdSpec;
import com.perforce.p4java.server.IOptionsServer;
import com.perforce.p4java.server.IServer;
import com.perforce.p4java.server.delegator.IInterchangesDelegator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class InterchangesDelegator
extends BaseDelegator
implements IInterchangesDelegator {
    public InterchangesDelegator(IOptionsServer server) {
        super(server);
    }

    @Override
    public List<IChangelist> getInterchanges(IFileSpec fromFile, IFileSpec toFile, GetInterchangesOptions opts) throws P4JavaException {
        ArrayList<IFileSpec> files = new ArrayList<IFileSpec>();
        files.add(fromFile);
        files.add(toFile);
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.INTERCHANGES, Parameters.processParameters(opts, files, this.server), null);
        return this.processInterchangeMaps(resultMaps, InterchangesDelegatorHidden.isListIndividualFilesThatRequireIntegration(opts));
    }

    @Override
    public List<IChangelist> getInterchanges(String branchSpecName, List<IFileSpec> fromFileList, List<IFileSpec> toFileList, GetInterchangesOptions opts) throws P4JavaException {
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.INTERCHANGES, Parameters.processParameters((Options)opts, fromFileList, toFileList, branchSpecName, (IServer)this.server), null);
        return this.processInterchangeMaps(resultMaps, InterchangesDelegatorHidden.isListIndividualFilesThatRequireIntegration(opts));
    }

    public List<IChangelist> getInterchanges(IFileSpec fromFile, IFileSpec toFile, boolean showFiles, boolean longDesc, int maxChangelistId) throws ConnectionException, RequestException, AccessException {
        try {
            GetInterchangesOptions getInterchangesOptions = new GetInterchangesOptions().setShowFiles(showFiles).setLongDesc(longDesc).setMaxChangelistId(maxChangelistId);
            return this.getInterchanges(fromFile, toFile, getInterchangesOptions);
        }
        catch (AccessException | ConnectionException | RequestException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            throw new RequestException(exc.getMessage(), exc);
        }
    }

    public List<IChangelist> getInterchanges(String branchSpecName, List<IFileSpec> fromFileList, List<IFileSpec> toFileList, boolean showFiles, boolean longDesc, int maxChangelistId, boolean reverseMapping, boolean biDirectional) throws ConnectionException, RequestException, AccessException {
        try {
            GetInterchangesOptions getInterchangesOptions = new GetInterchangesOptions().setShowFiles(showFiles).setLongDesc(longDesc).setMaxChangelistId(maxChangelistId).setReverseMapping(reverseMapping).setBiDirectional(biDirectional);
            return this.getInterchanges(branchSpecName, fromFileList, toFileList, getInterchangesOptions);
        }
        catch (AccessException | ConnectionException | RequestException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            throw new RequestException(exc.getMessage(), exc);
        }
    }

    public List<IChangelist> processInterchangeMaps(List<Map<String, Object>> resultMaps, boolean showFiles) throws ConnectionException, AccessException, RequestException {
        ArrayList<IChangelist> interchangeList = new ArrayList<IChangelist>();
        if (Objects.nonNull(resultMaps)) {
            for (Map<String, Object> map : resultMaps) {
                if (!Objects.nonNull(map)) continue;
                String errStr = this.server.handleFileErrorStr(map);
                if (StringUtils.isNotBlank((CharSequence)errStr)) {
                    if (this.server.getGenericCode(map) == 17 || this.server.getSeverityCode(map) == 2 || StringUtils.contains((CharSequence)errStr, (CharSequence)"all revision(s) already integrated")) continue;
                    throw new RequestException(errStr, P4ResultMapUtils.parseCode0ErrorString(map));
                }
                ChangelistSummary changelistSummary = new ChangelistSummary(map, true, (IServer)this.server);
                Changelist changelist = new Changelist((IChangelistSummary)changelistSummary, this.server, false);
                interchangeList.add(changelist);
                ArrayList<IFileSpec> fileSpecs = new ArrayList<IFileSpec>();
                changelist.setFileSpecs(fileSpecs);
                if (!showFiles) continue;
                int i = 0;
                while (Objects.nonNull(map.get("depotFile" + i))) {
                    FileSpec fileSpec = new FileSpec(map, this.server, i);
                    fileSpec.setChangelistId(changelist.getId());
                    fileSpecs.add(fileSpec);
                    ++i;
                }
            }
        }
        return interchangeList;
    }

    public static class InterchangesDelegatorHidden {
        private static boolean isListIndividualFilesThatRequireIntegration(GetInterchangesOptions opts) {
            return Objects.nonNull(opts) && opts.isShowFiles();
        }
    }
}

